/*
 * #%L
 * IsisFish
 * 
 * $Id: RuleDiscreteDomainXMLVisitor.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/mexico/xml/RuleDiscreteDomainXMLVisitor.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import java.util.List;

import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;

/**
 * XML rule domain visitor.
 *
 * @author chatellier
 * @version $Revision: 4156 $
 * 
 * Last update : $Date: 2014-12-09 12:27:18 +0100 (mar., 09 déc. 2014) $
 * By : $Author: echatellier $
 */
public class RuleDiscreteDomainXMLVisitor extends DiscreteDomainXMLVisitor {

    @Override
    public void start(Domain domain) {
        // lorsque le facteur est catégoriel, la liste de ses niveaux, par une
        // liste ouverte d'éléments 'level', d'attributs 'value' et 'weight')
        xmlBuffer.append("<domain distributionName=\"categorical\" type=\"rule\">");
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void visit(Domain domain, Object label, Object value) {
        List<Rule> rulesList = (List<Rule>)value;
        String rulesAsXml = MexicoHelper.getRulesAsXml(rulesList);

        xmlBuffer.append("<level>");
        xmlBuffer.append(rulesAsXml);
        xmlBuffer.append("</level>");
    }
}
