package fr.ifremer.isisfish.entities;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Wed Jun 24 10:15:37 CEST 2015")
public abstract class VesselTypeAbstract extends TopiaEntityAbstract implements VesselType {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : length
     */
    protected int length;

    /**
     * Nom de l'attribut en BD : speed
     */
    protected double speed;

    /**
     * Nom de l'attribut en BD : maxTripDuration
     */
    protected TimeUnit maxTripDuration;

    /**
     * Nom de l'attribut en BD : activityRange
     */
    protected double activityRange;

    /**
     * <p>Taille minimum de l'&eacute;quipage sur ce style de bateau</p>
     * 
     * Nom de l'attribut en BD : minCrewSize
     */
    protected int minCrewSize;

    /**
     * <p>Co&ucirc;t d'un heure de carburant</p>
     * 
     * Nom de l'attribut en BD : unitFuelCostOfTravel
     */
    protected double unitFuelCostOfTravel;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : tripType
     */
    protected Collection<TripType> tripType;

    private static final long serialVersionUID = 3762534722424748387L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(VesselType.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(VesselType.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_LENGTH, int.class, length);
        visitor.visit(this, PROPERTY_SPEED, double.class, speed);
        visitor.visit(this, PROPERTY_MAX_TRIP_DURATION, TimeUnit.class, maxTripDuration);
        visitor.visit(this, PROPERTY_ACTIVITY_RANGE, double.class, activityRange);
        visitor.visit(this, PROPERTY_MIN_CREW_SIZE, int.class, minCrewSize);
        visitor.visit(this, PROPERTY_UNIT_FUEL_COST_OF_TRAVEL, double.class, unitFuelCostOfTravel);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_TRIP_TYPE, Collection.class, TripType.class, tripType);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        String result = this.name;

        return result;
    }

    @Override
    public void setLength(int length) {
        int oldValue = this.length;
        fireOnPreWrite(PROPERTY_LENGTH, oldValue, length);
        this.length = length;
        fireOnPostWrite(PROPERTY_LENGTH, oldValue, length);
    }

    @Override
    public int getLength() {
        int result = this.length;

        return result;
    }

    @Override
    public void setSpeed(double speed) {
        double oldValue = this.speed;
        fireOnPreWrite(PROPERTY_SPEED, oldValue, speed);
        this.speed = speed;
        fireOnPostWrite(PROPERTY_SPEED, oldValue, speed);
    }

    @Override
    public double getSpeed() {
        double result = this.speed;

        return result;
    }

    @Override
    public void setMaxTripDuration(TimeUnit maxTripDuration) {
        TimeUnit oldValue = this.maxTripDuration;
        fireOnPreWrite(PROPERTY_MAX_TRIP_DURATION, oldValue, maxTripDuration);
        this.maxTripDuration = maxTripDuration;
        fireOnPostWrite(PROPERTY_MAX_TRIP_DURATION, oldValue, maxTripDuration);
    }

    @Override
    public TimeUnit getMaxTripDuration() {
        TimeUnit result = this.maxTripDuration;

        return result;
    }

    @Override
    public void setActivityRange(double activityRange) {
        double oldValue = this.activityRange;
        fireOnPreWrite(PROPERTY_ACTIVITY_RANGE, oldValue, activityRange);
        this.activityRange = activityRange;
        fireOnPostWrite(PROPERTY_ACTIVITY_RANGE, oldValue, activityRange);
    }

    @Override
    public double getActivityRange() {
        double result = this.activityRange;

        return result;
    }

    @Override
    public void setMinCrewSize(int minCrewSize) {
        int oldValue = this.minCrewSize;
        fireOnPreWrite(PROPERTY_MIN_CREW_SIZE, oldValue, minCrewSize);
        this.minCrewSize = minCrewSize;
        fireOnPostWrite(PROPERTY_MIN_CREW_SIZE, oldValue, minCrewSize);
    }

    @Override
    public int getMinCrewSize() {
        int result = this.minCrewSize;

        return result;
    }

    @Override
    public void setUnitFuelCostOfTravel(double unitFuelCostOfTravel) {
        double oldValue = this.unitFuelCostOfTravel;
        fireOnPreWrite(PROPERTY_UNIT_FUEL_COST_OF_TRAVEL, oldValue, unitFuelCostOfTravel);
        this.unitFuelCostOfTravel = unitFuelCostOfTravel;
        fireOnPostWrite(PROPERTY_UNIT_FUEL_COST_OF_TRAVEL, oldValue, unitFuelCostOfTravel);
    }

    @Override
    public double getUnitFuelCostOfTravel() {
        double result = this.unitFuelCostOfTravel;

        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        String result = this.comment;

        return result;
    }

    @Override
    public void addTripType(TripType tripType) {
        fireOnPreWrite(PROPERTY_TRIP_TYPE, null, tripType);
        if (this.tripType == null) {
            this.tripType = new ArrayList<TripType>();
        }

        this.tripType.add(tripType);
        fireOnPostWrite(PROPERTY_TRIP_TYPE, this.tripType.size(), null, tripType);
    }

    @Override
    public void addAllTripType(Collection<TripType> tripType) {
        if (tripType == null) {
            return;
        }
        for (TripType item : tripType) {
            addTripType(item);
        }
    }

    @Override
    public void setTripType(Collection<TripType> tripType) {
        // Copy elements to keep data for fire with new reference
        Collection<TripType> oldValue = this.tripType != null ? new ArrayList<TripType>(this.tripType) : null;
        fireOnPreWrite(PROPERTY_TRIP_TYPE, oldValue, tripType);
        this.tripType = tripType;
        fireOnPostWrite(PROPERTY_TRIP_TYPE, oldValue, tripType);
    }

    @Override
    public void removeTripType(TripType tripType) {
        fireOnPreWrite(PROPERTY_TRIP_TYPE, tripType, null);
        if (this.tripType == null || !this.tripType.remove(tripType)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_TRIP_TYPE, this.tripType.size() + 1, tripType, null);
    }

    @Override
    public void clearTripType() {
        if (this.tripType == null) {
            return;
        }
        Collection<TripType> oldValue = new ArrayList<TripType>(this.tripType);
        fireOnPreWrite(PROPERTY_TRIP_TYPE, oldValue, this.tripType);
        this.tripType.clear();
        fireOnPostWrite(PROPERTY_TRIP_TYPE, oldValue, this.tripType);
    }

    @Override
    public Collection<TripType> getTripType() {
        return tripType;
    }

    @Override
    public TripType getTripTypeByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(tripType, topiaId);
    }

    @Override
    public int sizeTripType() {
        if (tripType == null) {
            return 0;
        }
        return tripType.size();
    }

    @Override
    public boolean isTripTypeEmpty() {
        int size = sizeTripType();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_LENGTH, this.length).
            append(PROPERTY_SPEED, this.speed).
            append(PROPERTY_MAX_TRIP_DURATION, this.maxTripDuration).
            append(PROPERTY_ACTIVITY_RANGE, this.activityRange).
            append(PROPERTY_MIN_CREW_SIZE, this.minCrewSize).
            append(PROPERTY_UNIT_FUEL_COST_OF_TRAVEL, this.unitFuelCostOfTravel).
            append(PROPERTY_COMMENT, this.comment).
            append(PROPERTY_TRIP_TYPE, this.tripType).
         toString();
        return result;
    }

} //VesselTypeAbstract
