/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging.io;

import fr.ifremer.isisfish.logging.io.LineReader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Pattern;

public abstract class OffsetReader {
    protected long nbLines;
    private static Pattern LOG_ENTRY_PATTERN = Pattern.compile("(WARN|ERROR|INFO|DEBUG|TRACE).*");

    protected abstract void storeOffset(long var1, long var3) throws IOException;

    protected abstract boolean needCreate() throws IOException;

    public abstract long getOffset(long var1) throws IOException;

    public void open(LineReader reader) throws IOException {
        if (this.needCreate()) {
            this.nbLines = reader.getParent() != null ? this.createOffsets(reader, reader.getParent()) : this.createOffsets(reader);
        }
    }

    public void close() throws IOException {
    }

    public long getNbLines() {
        return this.nbLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(LineReader lineReader) throws IOException {
        long newLength = lineReader.getFile().length();
        lineReader.close();
        long nbNewLines = 0L;
        try (RandomAccessFile reader = new RandomAccessFile(lineReader.getFile(), "r");){
            String line;
            long offset = newLength;
            reader.seek(offset);
            while ((line = reader.readLine()) != null) {
                if (lineReader.match(line)) {
                    this.storeOffset(this.nbLines + ++nbNewLines, offset);
                }
                int lineSize = line.length();
                reader.seek(offset += (long)lineSize);
                int next = reader.read();
                int nbCharAtEnd = 1;
                if (next == 13 && (next = reader.read()) == 10) {
                    nbCharAtEnd = 2;
                }
                reader.seek(offset += (long)nbCharAtEnd);
            }
        }
    }

    protected boolean isLogEntry(String line) throws IOException {
        boolean result = false;
        int index = line.indexOf(124);
        if (index == -1) {
            return false;
        }
        result = LOG_ENTRY_PATTERN.matcher(line.substring(0, index)).matches();
        return result;
    }

    protected String readLine(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int c = reader.read();
            switch (c) {
                case -1: {
                    return sb.toString();
                }
                case 10: {
                    sb.append((char)c);
                    return sb.toString();
                }
            }
            sb.append((char)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long createOffsets(LineReader lineReader) throws IOException {
        long nbLines = 0L;
        try (BufferedReader reader = new BufferedReader(new FileReader(lineReader.getFile()));){
            String line;
            long offset = 0L;
            while (!(line = this.readLine(reader)).isEmpty()) {
                int lineSize = line.length();
                if (lineReader.match(line)) {
                    this.storeOffset(nbLines, offset);
                    ++nbLines;
                }
                offset += (long)lineSize;
            }
        }
        return nbLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long createOffsetsForLog(LineReader lineReader) throws IOException {
        long nbLines = 0L;
        try (BufferedReader reader = new BufferedReader(new FileReader(lineReader.getFile()));){
            String line;
            long offset = 0L;
            StringBuilder currentEntry = null;
            while (!(line = this.readLine(reader)).isEmpty()) {
                if (!this.isLogEntry(line)) {
                    if (currentEntry == null) continue;
                    System.out.println("no a log entry " + line);
                    currentEntry.append(line);
                    continue;
                }
                if (currentEntry != null) {
                    String toSave = currentEntry.toString();
                    System.out.println("[" + nbLines + "] save entry " + line);
                    int lineSize = toSave.length();
                    if (lineReader.match(toSave)) {
                        this.storeOffset(nbLines, offset);
                        ++nbLines;
                    }
                    offset += (long)lineSize;
                }
                currentEntry = new StringBuilder(line);
            }
        }
        return nbLines;
    }

    protected long createOffsets(LineReader lineReader, LineReader parent) throws IOException {
        long nbLines = 0L;
        long max = parent.getNbLines();
        for (long i = 0L; i < max; ++i) {
            String line = parent.readLine(i);
            if (!lineReader.match(line)) continue;
            long offset = parent.getOffsetReader().getOffset(i);
            this.storeOffset(nbLines, offset);
            ++nbLines;
        }
        return nbLines;
    }

    public void deleteOffsetFile() {
    }
}

