/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationException;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationResultGetter;
import fr.ifremer.isisfish.simulator.SimulationResultListener;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixSemanticsDecorator;
import org.nuiton.math.matrix.SemanticsDecorator;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.ArrayUtil;
import org.nuiton.util.HashList;

public abstract class ResultStorageAbstract
implements SimulationResultListener,
SimulationResultGetter,
ResultStorage {
    private static Log log = LogFactory.getLog(ResultStorageAbstract.class);
    protected SimulationStorage simulation = null;
    protected EntitySemanticsDecorator decorator;
    protected transient Set<String> enabledResult = null;

    protected abstract MatrixND readResult(TimeStep var1, String var2);

    protected abstract void writeResult(TimeStep var1, String var2, MatrixND var3);

    protected abstract void writeActiveRule(TimeStep var1, String var2, String var3);

    @Override
    public abstract List<String> getResultName();

    protected MatrixFactory getMatrixFactory() {
        return MatrixFactory.getInstance();
    }

    public ResultStorageAbstract(SimulationStorage simulation) {
        this.simulation = simulation;
        this.decorator = new EntitySemanticsDecorator();
    }

    @Override
    public String getInfo() {
        return this.getClass().getSimpleName() + " No more information";
    }

    protected MatrixND decorate(MatrixND mat, TopiaContext tx) {
        MatrixSemanticsDecorator result = null;
        if (mat != null) {
            tx = this.getTx(tx);
            result = new MatrixSemanticsDecorator(mat, (SemanticsDecorator)new EntitySemanticsDecorator(tx));
        }
        return result;
    }

    protected MatrixND undecorate(MatrixND mat) {
        MatrixND result = null;
        if (mat != null) {
            String name = mat.getName();
            String[] dimNames = mat.getDimensionNames();
            List[] sems = new List[mat.getDimCount()];
            int maxi = sems.length;
            for (int i = 0; i < maxi; ++i) {
                sems[i] = this.undecorate(mat.getSemantic(i));
            }
            result = this.getMatrixFactory().create(name, sems, dimNames);
            result.paste(mat);
        }
        return result;
    }

    protected List<String> undecorate(List l) {
        ArrayList<String> result = new ArrayList<String>(l.size());
        for (Object o : l) {
            result.add(this.undecorate(o));
        }
        return result;
    }

    protected String undecorate(Object o) {
        return this.decorator.undecorate(o);
    }

    @Override
    public void delete() {
        this.close();
    }

    @Override
    public void close() {
    }

    @Override
    public void addResult(TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), mat);
    }

    @Override
    public void addResult(TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), pop, mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), pop, mat);
    }

    @Override
    public void addResult(TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, pop, mat);
    }

    @Override
    public void addResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            this.doAddResult(step, name + " " + pop, mat);
        }
    }

    @Override
    public void addResult(boolean force, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            this.doAddResult(step, name, mat);
        }
    }

    protected void doAddResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        for (int i = 0; i < mat.getDimCount(); ++i) {
            if (!mat.getSemantic(i).contains(null)) continue;
            throw new SimulationException("Erreur le r\u00e9sultat que vous souhaitez enregistrer n'a pas d'information convenable pour la dimension: " + i + " " + mat.getDimensionName(i));
        }
        try {
            this.writeResult(step, name, mat);
        }
        catch (Exception eee) {
            log.warn((Object)("Can't add result '" + name + "' at step " + step), (Throwable)eee);
        }
    }

    @Override
    public boolean isEnabled(String name) {
        name = name.trim();
        if (this.enabledResult == null && this.simulation.getSimulationParametersFile().exists()) {
            Optimization optimization;
            Objective objective;
            List<SimulationPlan> plans;
            List<Rule> rules;
            List<SensitivityExport> sensitivityExports;
            this.enabledResult = new HashSet<String>();
            Collection<String> resultEnabled = this.simulation.getParameter().getResultEnabled();
            this.enabledResult.addAll(resultEnabled);
            List<String> exportNames = this.simulation.getParameter().getExportNames();
            if (exportNames != null) {
                for (String exportName : exportNames) {
                    ExportStorage storage = ExportStorage.getExport(exportName, new CodeSourceStorage.Location[0]);
                    try {
                        Export export = (Export)storage.getNewInstance();
                        Collections.addAll(this.enabledResult, export.getNecessaryResult());
                    }
                    catch (IsisFishException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)I18n.t((String)"isisfish.error.instanciate.export", (Object[])new Object[]{exportName}), (Throwable)eee);
                    }
                }
            }
            if ((sensitivityExports = this.simulation.getParameter().getSensitivityExport()) != null) {
                for (SensitivityExport sensitivityExport : sensitivityExports) {
                    Collections.addAll(this.enabledResult, sensitivityExport.getNecessaryResult());
                }
            }
            if ((rules = this.simulation.getParameter().getRules()) != null) {
                for (Rule rule : rules) {
                    Collections.addAll(this.enabledResult, rule.getNecessaryResult());
                }
            }
            if ((plans = this.simulation.getParameter().getSimulationPlans()) != null) {
                for (SimulationPlan plan : plans) {
                    Collections.addAll(this.enabledResult, plan.getNecessaryResult());
                }
            }
            if ((objective = this.simulation.getParameter().getObjective()) != null) {
                Collections.addAll(this.enabledResult, objective.getNecessaryResult());
            }
            if ((optimization = this.simulation.getParameter().getOptimization()) != null) {
                Collections.addAll(this.enabledResult, optimization.getNecessaryResult());
            }
            log.info((Object)("Enabled result: " + this.enabledResult));
        }
        boolean result = true;
        if (this.enabledResult != null) {
            result = this.enabledResult.contains(name);
        }
        return result;
    }

    @Override
    public void addActiveRule(TimeStep step, Rule rule) throws IsisFishException {
        String name = RuleStorage.getName(rule);
        String params = RuleStorage.getParamAsString(rule);
        this.writeActiveRule(step, name, params);
    }

    @Override
    public MatrixND getMatrix(TimeStep step, Population pop, String name) {
        String newName = name + " " + pop;
        return this.getMatrix(step, newName, null);
    }

    public MatrixND getMatrix(TimeStep step, Population pop, String name, TopiaContext tx) {
        String newName = name + " " + pop;
        return this.getMatrix(step, newName, tx);
    }

    @Override
    public MatrixND getMatrix(TimeStep step, String name) {
        return this.getMatrix(step, name, null);
    }

    @Override
    public MatrixND getMatrix(TimeStep step, String name, TopiaContext tx) {
        MatrixND mat = this.readResult(step, name);
        mat = this.decorate(mat, tx);
        return mat;
    }

    @Override
    public MatrixND getMatrix(Population pop, String name) {
        String newName = name + " " + pop;
        return this.getMatrix(newName, null);
    }

    @Override
    public MatrixND getMatrix(Population pop, String name, TopiaContext tx) {
        String newName = name + " " + pop;
        return this.getMatrix(newName, tx);
    }

    @Override
    public MatrixND getMatrix(String name) {
        return this.getMatrix(name, null);
    }

    @Override
    public MatrixND getMatrix(String name, TopiaContext tx) {
        log.debug((Object)("Get result: " + name));
        TimeStep lastStep = this.getLastStep();
        ArrayList<TimeStep> steps = new ArrayList<TimeStep>();
        TimeStep step = new TimeStep(0);
        steps.add(step);
        while (step.before(lastStep)) {
            step = step.next();
            steps.add(step);
        }
        LinkedHashMap<TimeStep, MatrixND> results = new LinkedHashMap<TimeStep, MatrixND>();
        MatrixND sample = null;
        for (TimeStep s : steps) {
            MatrixND m = this.readResult(s, name);
            if (m == null) continue;
            results.put(s, m);
            sample = m;
        }
        if (sample == null) {
            return null;
        }
        String[] dimNames = new String[1 + sample.getDimCount()];
        dimNames[0] = I18n.t((String)"isisfish.common.date", (Object[])new Object[0]);
        for (int i = 1; i < dimNames.length; ++i) {
            dimNames[i] = sample.getDimensionName(i - 1);
        }
        List[] sem = new List[1 + sample.getDimCount()];
        sem[0] = this.undecorate(steps);
        for (int i = 1; i < sem.length; ++i) {
            sem[i] = new HashList();
        }
        for (MatrixND m : results.values()) {
            if (m == null) continue;
            for (int s = 0; s < m.getDimCount(); ++s) {
                sem[s + 1].addAll(m.getSemantic(s));
            }
        }
        MatrixND resultMat = this.getMatrixFactory().create(name, sem, dimNames);
        for (Map.Entry result : results.entrySet()) {
            TimeStep s = (TimeStep)result.getKey();
            String stepString = this.undecorate(s);
            MatrixND m = (MatrixND)result.getValue();
            MatrixND submat = resultMat.getSubMatrix(0, (Object)stepString, 1);
            MatrixIterator mi = m.iteratorNotZero();
            while (mi.next()) {
                submat.setValue(ArrayUtil.concat((Object[][])new Object[][]{{stepString}, mi.getSemanticsCoordinates()}), mi.getValue());
            }
        }
        resultMat = this.decorate(resultMat, tx);
        return resultMat;
    }

    @Override
    public TimeStep getLastStep() {
        int monthNumber = this.simulation.getParameter().getNumberOfYear() * Month.NUMBER_OF_MONTH;
        TimeStep result = new TimeStep(monthNumber - 1);
        return result;
    }

    @Override
    public void addResult(SimulationContext context, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        this.doAddResult(step, name, mat);
    }

    @Override
    public MatrixND getMatrix(SimulationContext context, TimeStep step, String name) {
        MatrixND result;
        block2: {
            result = null;
            try {
                result = this.getMatrix(step, name, context.getDB());
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)String.format("Can't get result: %1$s", name), (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public MatrixND getMatrix(SimulationContext context, String name) {
        MatrixND result;
        block2: {
            result = null;
            try {
                result = this.getMatrix(name, context.getDB());
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)String.format("Can't get result: %1$s", name), (Throwable)eee);
            }
        }
        return result;
    }

    protected TopiaContext getTx(TopiaContext tx) {
        TopiaContext result = tx;
        if (tx == null && this.simulation == SimulationContext.get().getSimulationStorage()) {
            try {
                result = SimulationContext.get().getDB();
            }
            catch (TopiaException eee) {
                throw new IsisFishRuntimeException("Can't get database from SimulationContext", eee);
            }
        }
        return result;
    }

    @Override
    public void afterSimulation(SimulationContext context) {
    }

    @Override
    public void beforeSimulation(SimulationContext context) {
    }

    @Override
    public void stepChange(SimulationContext context, TimeStep step) {
    }

    protected static class EntitySemanticsDecorator
    implements SemanticsDecorator<Object, String> {
        private static final String SEP = ":";
        protected TopiaContext tx;
        protected BidiMap<String, Object> cache = new DualHashBidiMap();

        public EntitySemanticsDecorator() {
        }

        public EntitySemanticsDecorator(TopiaContext tx) {
            this.tx = tx;
        }

        public Object decorate(String internalValue) {
            Object result = this.cache.get((Object)internalValue);
            if (result == null && internalValue != null) {
                internalValue = internalValue.intern();
                result = internalValue;
                if (StringUtils.startsWith((CharSequence)internalValue, (CharSequence)"Month")) {
                    String val = StringUtils.substringAfter((String)internalValue, (String)SEP);
                    int monthNumber = Integer.parseInt(val);
                    result = Month.MONTH[monthNumber];
                } else if (StringUtils.startsWith((CharSequence)internalValue, (CharSequence)"TimeStep")) {
                    String val = StringUtils.substringAfter((String)internalValue, (String)SEP);
                    int stepNumber = Integer.parseInt(val);
                    result = new TimeStep(stepNumber);
                } else if (StringUtils.startsWith((CharSequence)internalValue, (CharSequence)"fr.ifremer.isisfish.entities.")) {
                    if (this.tx == null) {
                        result = StringUtils.substringAfter((String)internalValue, (String)SEP);
                    } else {
                        try {
                            String id = StringUtils.substringBefore((String)internalValue, (String)SEP);
                            result = this.tx.findByTopiaId(id);
                        }
                        catch (TopiaException eee) {
                            log.info((Object)("Fallback use string representation because i can't decorate (String->Entity): " + internalValue), (Throwable)eee);
                        }
                    }
                }
                this.cache.put((Object)internalValue, result);
            }
            return result;
        }

        public String undecorate(Object decoratedValue) {
            String result = (String)this.cache.getKey(decoratedValue);
            if (result == null && decoratedValue != null) {
                result = decoratedValue instanceof Month ? "Month:" + ((Month)decoratedValue).getMonthNumber() : (decoratedValue instanceof TimeStep ? "TimeStep:" + ((TimeStep)decoratedValue).getStep() : (decoratedValue instanceof TopiaEntity ? ((TopiaEntity)decoratedValue).getTopiaId() + SEP + decoratedValue : String.valueOf(decoratedValue)));
                result = result.intern();
                this.cache.put((Object)result, decoratedValue);
            }
            return result;
        }
    }
}

