/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.ActiveRule;
import fr.ifremer.isisfish.entities.ActiveRuleDAO;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Result;
import fr.ifremer.isisfish.entities.ResultDAO;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationException;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationResultGetter;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.ArrayUtil;
import org.nuiton.util.HashList;

public class ResultDatabaseStorage
implements SimulationResultGetter,
ResultStorage {
    private static Log log = LogFactory.getLog(ResultDatabaseStorage.class);
    protected SimulationStorage simulation = null;
    protected transient ReferenceMap<String, TopiaContext> cacheContext = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);
    protected transient ReferenceMap<String, MatrixND> cache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.SOFT);
    protected transient Set<String> availableResult = null;
    protected transient Set<String> enabledResult = null;

    public ResultDatabaseStorage(SimulationStorage simulation) {
        this.simulation = simulation;
    }

    @Override
    public String getInfo() {
        return "ResultDatabaseStorage no more info.";
    }

    @Override
    public void delete() {
        block5: {
            TopiaContext tx = null;
            boolean mustClose = false;
            try {
                if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                    tx = SimulationContext.get().getDbResult();
                }
                if (tx == null) {
                    tx = this.simulation.getStorage().beginTransaction();
                    mustClose = true;
                }
                tx.execute("DELETE " + Result.class.getName(), new Object[0]);
                if (mustClose) {
                    tx.closeContext();
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Can't delete results", (Throwable)ex);
            }
        }
    }

    @Override
    public void close() {
    }

    protected void putInCache(TimeStep step, String name, MatrixND mat, TopiaContext context) {
        String key = step.getStep() + ":" + name;
        this.putInCache(key, mat, context);
    }

    protected void putInCache(String name, MatrixND mat, TopiaContext context) {
        if (mat != null) {
            this.cache.put((Object)name, (Object)mat);
            this.cacheContext.put((Object)name, (Object)context);
        }
    }

    protected void removeInCache(String name) {
        this.cache.remove((Object)name);
        this.cacheContext.remove((Object)name);
    }

    protected MatrixND getInCache(TimeStep step, String name) {
        String key = step.getStep() + ":" + name;
        MatrixND result = this.getInCache(key);
        return result;
    }

    protected MatrixND getInCache(String name) {
        MatrixND result = null;
        TopiaContext context = (TopiaContext)this.cacheContext.get((Object)name);
        if (context != null && !context.isClosed()) {
            result = (MatrixND)this.cache.get((Object)name);
        }
        return result;
    }

    protected Set<String> getAvailableResult() {
        block6: {
            if (this.availableResult == null) {
                this.availableResult = new HashSet<String>();
                try {
                    TopiaContext tx = null;
                    boolean mustClose = false;
                    if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                        tx = SimulationContext.get().getDbResult();
                    }
                    if (tx == null) {
                        tx = this.simulation.getStorage().beginTransaction();
                        mustClose = true;
                    }
                    List result = tx.findAll("Select resultStep||':'||name from fr.ifremer.isisfish.entities.Result", new Object[0]);
                    if (mustClose) {
                        tx.closeContext();
                    }
                    this.availableResult.addAll(result);
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block6;
                    log.warn((Object)"Can't get result available", (Throwable)eee);
                }
            }
        }
        return this.availableResult;
    }

    protected boolean isAvailableResult(TimeStep step, String name) {
        String key = step.getStep() + ":" + name;
        boolean result = this.getAvailableResult().contains(key);
        return result;
    }

    protected void addAvailableResult(TimeStep step, String name) {
        String key = step.getStep() + ":" + name;
        this.getAvailableResult().add(key);
    }

    @Override
    public boolean isEnabled(String name) {
        name = name.trim();
        if (this.enabledResult == null) {
            Optimization optimization;
            Objective objective;
            List<SimulationPlan> plans;
            List<Rule> rules;
            List<SensitivityExport> sensitivityExports;
            this.enabledResult = new HashSet<String>();
            Collection<String> resultEnabled = this.simulation.getParameter().getResultEnabled();
            this.enabledResult.addAll(resultEnabled);
            List<String> exportNames = this.simulation.getParameter().getExportNames();
            if (exportNames != null) {
                for (String exportName : exportNames) {
                    ExportStorage storage = ExportStorage.getExport(exportName, new CodeSourceStorage.Location[0]);
                    try {
                        Export export = (Export)storage.getNewInstance();
                        for (String resultName : export.getNecessaryResult()) {
                            this.enabledResult.add(resultName);
                        }
                    }
                    catch (IsisFishException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)I18n.t((String)"isisfish.error.instanciate.export", (Object[])new Object[]{exportName}), (Throwable)eee);
                    }
                }
            }
            if ((sensitivityExports = this.simulation.getParameter().getSensitivityExport()) != null) {
                for (SensitivityExport sensitivityExport : sensitivityExports) {
                    for (String resultName : sensitivityExport.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((rules = this.simulation.getParameter().getRules()) != null) {
                for (Rule rule : rules) {
                    for (String resultName : rule.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((plans = this.simulation.getParameter().getSimulationPlans()) != null) {
                for (SimulationPlan plan : plans) {
                    for (String resultName : plan.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((objective = this.simulation.getParameter().getObjective()) != null) {
                for (String resultName : objective.getNecessaryResult()) {
                    this.enabledResult.add(resultName);
                }
            }
            if ((optimization = this.simulation.getParameter().getOptimization()) != null) {
                for (String resultName : optimization.getNecessaryResult()) {
                    this.enabledResult.add(resultName);
                }
            }
            log.info((Object)("Enabled result: " + this.enabledResult));
        }
        boolean result = this.enabledResult.contains(name);
        return result;
    }

    @Override
    public void addResult(TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), mat);
    }

    @Override
    public void addResult(TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), pop, mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), pop, mat);
    }

    @Override
    public void addResult(TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, pop, mat);
    }

    @Override
    public void addResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            this.doAddResult(step, name + " " + pop, mat);
        }
    }

    @Override
    public void addResult(boolean force, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            this.doAddResult(step, name, mat);
        }
    }

    protected void doAddResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        try {
            TopiaContext tx = null;
            boolean mustClose = false;
            if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                tx = SimulationContext.get().getDbResult();
            }
            if (tx == null) {
                tx = this.simulation.getStorage().beginTransaction();
                mustClose = true;
            }
            this.doAddResult(step, name, mat, tx);
            if (mustClose) {
                tx.commitTransaction();
                tx.closeContext();
            }
        }
        catch (TopiaException eee) {
            log.warn((Object)("Can't add result '" + name + "' at step " + step), (Throwable)eee);
        }
    }

    protected void doAddResult(TimeStep step, String name, MatrixND mat, TopiaContext tx) throws IsisFishException {
        for (int i = 0; i < mat.getDimCount(); ++i) {
            if (!mat.getSemantic(i).contains(null)) continue;
            throw new SimulationException("Erreur le r\u00e9sultat que vous souhaitez enregistrer n'a pas d'information convenable pour la dimension: " + i + " " + mat.getDimensionName(i));
        }
        MatrixND newMat = mat.copy();
        try {
            ResultDAO resultPS = IsisFishDAOHelper.getResultDAO(tx);
            Result result = (Result)resultPS.create(new Object[0]);
            result.setResultStep(step);
            result.setName(name);
            result.setMatrix(newMat);
            resultPS.update((TopiaEntity)result);
            this.addAvailableResult(step, name);
            this.putInCache(step, name, newMat, tx);
            tx.commitTransaction();
            tx.clearCache();
            this.removeInCache(name);
        }
        catch (TopiaException eee) {
            log.warn((Object)("Can't add result '" + name + "' at step " + step), (Throwable)eee);
        }
    }

    @Override
    public void addActiveRule(TimeStep step, Rule rule) throws IsisFishException {
        try {
            TopiaContext tx = null;
            boolean mustClose = false;
            if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                tx = SimulationContext.get().getDbResult();
            }
            if (tx == null) {
                tx = this.simulation.getStorage().beginTransaction();
                mustClose = true;
            }
            ActiveRuleDAO ps = IsisFishDAOHelper.getActiveRuleDAO(tx);
            ActiveRule result = (ActiveRule)ps.create(new Object[0]);
            result.setActiveRuleStep(step);
            result.setName(RuleStorage.getName(rule));
            result.setParam(RuleStorage.getParamAsString(rule));
            ps.update((TopiaEntity)result);
            if (mustClose) {
                tx.commitTransaction();
                tx.closeContext();
            }
        }
        catch (TopiaException eee) {
            throw new IsisFishException("Can't add result", eee);
        }
    }

    @Override
    public List<String> getResultName() {
        List result;
        block6: {
            result = null;
            try {
                TopiaContext tx = null;
                boolean mustClose = false;
                if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                    tx = SimulationContext.get().getDbResult();
                }
                if (tx == null) {
                    tx = this.simulation.getStorage().beginTransaction();
                    mustClose = true;
                }
                ResultDAO resultPS = IsisFishDAOHelper.getResultDAO(tx);
                result = resultPS.getContext().findAll("Select distinct name from fr.ifremer.isisfish.entities.Result order by name", new Object[0]);
                if (mustClose) {
                    tx.closeContext();
                }
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)"Can't get result name", (Throwable)eee);
            }
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    @Override
    public MatrixND getMatrix(TimeStep step, Population pop, String name) {
        String newName = name + " " + pop;
        return this.getMatrix(step, newName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MatrixND getMatrix(TimeStep step, String name) {
        MatrixND mat = this.getInCache(step, name);
        if (mat != null || !this.isAvailableResult(step, name)) return mat;
        try {
            TopiaContext tx = null;
            boolean mustClose = false;
            if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                tx = SimulationContext.get().getDbResult();
            }
            if (tx == null) {
                tx = this.simulation.getStorage().beginTransaction();
                mustClose = true;
            }
            mat = this.getMatrix(step, name, tx);
            if (!mustClose) return mat;
        }
        catch (Exception eee) {
            if (!log.isWarnEnabled()) return mat;
            log.warn((Object)("Can't return matrix '" + name + "' for step " + step), (Throwable)eee);
        }
        return mat;
    }

    @Override
    public MatrixND getMatrix(TimeStep step, String name, TopiaContext tx) {
        MatrixND mat;
        block4: {
            mat = this.getInCache(step, name);
            if (mat == null && this.isAvailableResult(step, name)) {
                try {
                    ResultDAO resultPS = IsisFishDAOHelper.getResultDAO(tx);
                    Result result = (Result)resultPS.findByProperties("resultStep", step, new Object[]{"name", name});
                    if (result != null) {
                        mat = result.getMatrix();
                        this.putInCache(step, name, mat, tx);
                    }
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Can't return matrix '" + name + "' for step " + step), (Throwable)eee);
                }
            }
        }
        return mat;
    }

    @Override
    public MatrixND getMatrix(Population pop, String name) {
        String newName = name + " " + pop;
        return this.getMatrix(newName);
    }

    @Override
    public MatrixND getMatrix(Population pop, String name, TopiaContext tx) {
        String newName = name + " " + pop;
        return this.getMatrix(newName, tx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MatrixND getMatrix(String name) {
        MatrixND resultMat = null;
        try {
            TopiaContext tx = null;
            boolean mustClose = false;
            if (this.simulation == SimulationContext.get().getSimulationStorage()) {
                tx = SimulationContext.get().getDbResult();
            }
            if (tx == null) {
                tx = this.simulation.getStorage().beginTransaction();
                mustClose = true;
            }
            resultMat = this.getMatrix(name, tx);
            if (!mustClose) return resultMat;
        }
        catch (TopiaException eee) {
            if (!log.isWarnEnabled()) return resultMat;
            log.warn((Object)("Can't get result: " + name), (Throwable)eee);
        }
        return resultMat;
    }

    @Override
    public MatrixND getMatrix(String name, TopiaContext tx) {
        List results;
        MatrixND resultMat;
        block14: {
            log.debug((Object)("Get result: " + name));
            resultMat = this.getInCache(name);
            if (resultMat != null) {
                return resultMat;
            }
            results = null;
            try {
                ResultDAO resultPS = IsisFishDAOHelper.getResultDAO(tx);
                results = resultPS.findAllByName(name);
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block14;
                log.warn((Object)("Can't get result: " + name), (Throwable)eee);
            }
        }
        if (results == null || results.size() == 0) {
            return null;
        }
        TimeStep lastStep = this.getLastStep();
        ArrayList<TimeStep> steps = new ArrayList<TimeStep>();
        TimeStep step = new TimeStep(0);
        steps.add(step);
        while (step.before(lastStep)) {
            step = step.next();
            steps.add(step);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Steps list : " + steps));
        }
        MatrixND mat = ((Result)results.get(0)).getMatrix();
        String[] dimNames = new String[1 + mat.getDimCount()];
        dimNames[0] = I18n.t((String)"isisfish.common.date", (Object[])new Object[0]);
        for (int i = 1; i < dimNames.length; ++i) {
            dimNames[i] = mat.getDimensionName(i - 1);
        }
        List[] sem = new List[1 + mat.getDimCount()];
        sem[0] = steps;
        for (int i = 1; i < sem.length; ++i) {
            sem[i] = new HashList();
        }
        for (Result result : results) {
            MatrixND mattmp = result.getMatrix();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Ajout de la semantics: " + Arrays.asList(mattmp.getSemantics())));
            }
            for (int s = 0; s < mattmp.getDimCount(); ++s) {
                sem[s + 1].addAll(mattmp.getSemantic(s));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("La semantique final est: " + Arrays.asList(sem)));
        }
        resultMat = MatrixFactory.getInstance().create(name, sem, dimNames);
        for (Result result : results) {
            TimeStep d = result.getResultStep();
            mat = result.getMatrix();
            if (mat == null) continue;
            MatrixND submat = resultMat.getSubMatrix(0, (Object)d, 1);
            MatrixIterator mi = mat.iteratorNotZero();
            while (mi.next()) {
                submat.setValue(ArrayUtil.concat((Object[][])new Object[][]{{d}, mi.getSemanticsCoordinates()}), mi.getValue());
            }
        }
        this.putInCache(name, resultMat, tx);
        return resultMat;
    }

    @Override
    public TimeStep getLastStep() {
        int monthNumber = this.simulation.getParameter().getNumberOfYear() * Month.NUMBER_OF_MONTH;
        TimeStep result = new TimeStep(monthNumber - 1);
        return result;
    }

    @Override
    public void addResult(SimulationContext context, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        try {
            this.doAddResult(step, name, mat, context.getDbResult());
        }
        catch (TopiaException eee) {
            log.warn((Object)I18n.t((String)"Can't add result '%1$s' at date %2$s", (Object[])new Object[]{name, step}), (Throwable)eee);
        }
    }

    @Override
    public MatrixND getMatrix(SimulationContext context, TimeStep step, String name) {
        MatrixND result;
        block2: {
            result = null;
            try {
                result = this.getMatrix(step, name, context.getDbResult());
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)I18n.t((String)"Can't get result: %1$s", (Object[])new Object[]{name}), (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public MatrixND getMatrix(SimulationContext context, String name) {
        MatrixND result;
        block2: {
            result = null;
            try {
                result = this.getMatrix(name, context.getDbResult());
            }
            catch (TopiaException eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)I18n.t((String)"Can't get result: %1$s", (Object[])new Object[]{name}), (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public void afterSimulation(SimulationContext context) {
    }

    @Override
    public void beforeSimulation(SimulationContext context) {
    }

    @Override
    public void stepChange(SimulationContext context, TimeStep step) {
    }
}

