/*
 * #%L
 * IsisFish
 * 
 * $Id: ProxyCommand.java 4016 2014-06-16 15:21:40Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.1.2/src/main/java/fr/ifremer/isisfish/util/ssh/ProxyCommand.java $
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.util.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.SocketFactory;

/**
 * Implementation du proxy commande pour pouvoir utiliser un proxy local dans le
 * but de faire un rebond à travers un serveur intermédiaire.
 * 
 * @author Eric Chatellier
 */
public class ProxyCommand implements Proxy {
    protected String command;
    protected Process p = null;
    protected InputStream in = null;
    protected OutputStream out = null;

    public ProxyCommand(String command) {
        this.command = command;
    }

    public void connect(SocketFactory socket_factory, String host, int port, int timeout) throws Exception {
        String fullCommand = command.replace("%h", host);
        fullCommand = fullCommand.replace("%p", new Integer(port).toString());
        p = Runtime.getRuntime().exec(fullCommand);
        in = p.getInputStream();
        out = p.getOutputStream();
    }

    public Socket getSocket() {
        return null;
    }

    public InputStream getInputStream() {
        return in;
    }

    public OutputStream getOutputStream() {
        return out;
    }

    public void close() {
        try {
            if (p != null) {
                p.getErrorStream().close();
                p.getOutputStream().close();
                p.getInputStream().close();
                p.destroy();
                p = null;
            }
        } catch (IOException e) {
        }
    }
}
