/*
 * #%L
 * $Id: MonthComponent.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.1.2/src/main/java/fr/ifremer/isisfish/ui/widget/editor/MonthComponent.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.widget.editor;

import javax.swing.JComboBox;

import org.nuiton.util.MonthEnum;

/**
 * Subclass JComboBox to get a typed ComboBox.
 * Usefull when editing factors.
 * 
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * By : $Author: echatellier $
 */
public class MonthComponent extends JComboBox<MonthEnum> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 2992441627176713132L;

    public MonthComponent(MonthEnum[] values) {
        super(values);
    }

    public static MonthComponent createMounthCombo(int mounth) {
        MonthComponent monthComponent = new MonthComponent(MonthEnum.values());
        monthComponent.setSelectedIndex(mounth);
        return monthComponent;
    }
    
    public int getSelectedValue() {
        return getSelectedIndex();
    }
}
