package fr.ifremer.isisfish.ui.sensitivity;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.ui.NavigationUI;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorTree;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorTreeCellRenderer;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorTreeModel;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SensitivityTabUI extends NavigationUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FISHERY_REGION = "fisheryRegion";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28bRRSemDipkzSFmKQpDSWllkAVrNsifqipSkqK1VhOGsUuKkQCxrtje6rxzjIzm2x6QBy4cEH8CXDngsSNE+LAmQMX1H8BIQ5cEW9m7V1vs1kvsg+76/fjm++9efPN93+iohTo8iMcBJbwXUX7xKrfefjwfvsRsdVdIm1BPcUFCn9TBVQ4QPNOZJcKXTlo6PTqIL26xfsed4k7kr3RQHNSHTMie4QohV5MZthSVpuReyPwfDFEjUiloX7791+Fb5wvvisgFHjAbhlKWR+XFVcy3UAF6ii0BCsd4irDbhdoCOp2ge9ZbdtiWMpd3Cefoc/RbAPNeFgAmEIv5y/ZYJj8wFNosbKLD2kXK8rdB9vXFHqjIyzaEaRP4C2p7FDZs3xqSeJKqughVcdWM/5u4faDbc8zgDMKzfaw6zAiFLr5/3C2Xc9X98LkGO6sziLieJ90gZ9CV9NAoUwAIdKqjQbHIAuVetNjVO1hl0CBK7qRgSWPoK9W7NHBpSjnTKWujQzilxLxxqqDllLxr2vb8/qxHBcBfltwxgYEzicJRC4dvhplvZQovSUIaRIGRwD+7HCHMGjGKI6CAOsu6WCfqZPBcTOeOwELtgQhbdPBL8SbWoFdZpr6amKYwwTjS3IvVerv+UpxF1LKCfDQrMOunIw2zXv1FOeNFGeisyZ7LRkw38G2FoWwzjyj3dftsmombdiJ1yO8so2Fw/Ax99UenEubepgNSrTwkbK2wN0w7rjjS1SPtmYYpWjP+eQQDQfueuR7M/JNu3CWnx7EBm6Hg/h2FDcXs1PoUspWxfRuxPxKEb/RpQW6mAAASbRiSYw1a+oAFYUPZhiOg5Mqug+uUD9Xn9JPDWi8/66Uf//pyY+1oWhehLWXU0NHNB/EzBPcA6GheulzoWL6irLqDvY2DlBJmgNgLoS1FGLNgRvIwXrmBFg63bqHZQ8girN//PzLyqe/PYMKNTTHOHbCmdhGJdUT0AXOnMB7d9MwWjg6A89nNTfg4sAkOUQ0uG1UFTbuFnUZdck6VqDmbV+R2wF0ZC2lIxGtdunXf8rNHzaHXZkClhdODY87U/wIzYSrmctkcE+kXh7zniS+w+P7IO2GmNLvsjcYl5p51tPKXoIZbXHf7r0feCDjQ1HYCXz92jUl6K+93IjzXFDQdtPECaFmhqdi8ZaDFV5vU9eBA3E7HXFlLKI2NzI4XciF0JoY4cOJEEBA5eg1ocM+SQe7lAOsaLQzA+Rynk0XnKsPQJ2z5ycP1GKiuEmJLURo+/xoQmbT1A5H+hQ+r+RplOKctajXIoHKoDMeSpu/yiBzNRfC1xkc8iFkcXhtYg7jEWCLbcLYPnFBvInIYHMtFxt/YoTHGfXkQ/hyYoSPM6p4a2KEd3LsSrkH98BjuEcxu8No1+3DnZBR1s08509lH5rxGOMK2wSE/wD3PqlGzA4AAA==";
    private static final Log log = LogFactory.getLog(SensitivityTabUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CardLayout2 cardlayout;
    protected CardLayout cardlayoutPrincipal;
    protected FactorTree factorsTree;
    protected FisheryRegion fisheryRegion;
    protected JTree fisheryRegionTree;
    protected DefaultTreeSelectionModel fisheryRegionTreeSelectionModel;
    protected SensitivityInputHandler handler;
    protected JPanel inputPane;
    protected JPanel inputPanePrincipal;
    protected JLabel none;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JSplitPane $JSplitPane0;
    private JSplitPane $JSplitPane1;
    private SensitivityTabUI $NavigationUI0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected InputAction getInputAction() {
        return getContextValue(InputAction.class);
    }
    
    protected SimulAction getSimulAction() {
        return getContextValue(SimulAction.class);
    }
    
    protected InputSaveVerifier getVerifier() {
        return getContextValue(InputSaveVerifier.class);
    }
    
    protected RegionStorage getRegionStorage() {
        return getContextValue(RegionStorage.class);
    }
    
    public void setTreeModel() {
        if (getFisheryRegion() != null) {
            getCardlayoutPrincipal().show(inputPanePrincipal,"normale");
            setContextValue(getFisheryRegion());
            getHandler().loadFisheryRegionTree(this);
        }
    }
    protected void setInfoText(String s) {
        WelcomePanelUI root = getParentContainer(WelcomePanelUI.class);
        root.setStatusMessage(s);
    }
    protected void regionNull() {
        getCardlayoutPrincipal().show(inputPanePrincipal,"none");
        DefaultTreeModel model = new DefaultTreeModel(null);
        fisheryRegionTree.setModel(model);
    }
    public void setFactorModel() {
        FactorGroup factorGroup = getSimulAction().getFactorGroup();
        FactorTreeModel model = new FactorTreeModel(factorGroup);
        factorsTree.setModel(model);
        getParentContainer(SensitivityUI.class).getSensitivityChooserUI().setFactorCardinalityTableModel();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SensitivityTabUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SensitivityTabUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SensitivityTabUI() {
        $initialize();
    }

    public SensitivityTabUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SensitivityTabUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SensitivityTabUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SensitivityTabUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SensitivityTabUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addNewFactorGroup(this, false);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addNewFactorGroup(this, true);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().exportFactorsToMexico(this);
    }

    public void doMouseClicked__on__factorsTree(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().factorsTreeMouseClicked(this, event);
    }

    public void doValueChanged__on__fisheryRegionTree(TreeSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().nodeSelectionChanged(this, event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public CardLayout2 getCardlayout() {
        return cardlayout;
    }

    public CardLayout getCardlayoutPrincipal() {
        return cardlayoutPrincipal;
    }

    public FactorTree getFactorsTree() {
        return factorsTree;
    }

    public FisheryRegion getFisheryRegion() {
        return fisheryRegion;
    }

    public JTree getFisheryRegionTree() {
        return fisheryRegionTree;
    }

    public DefaultTreeSelectionModel getFisheryRegionTreeSelectionModel() {
        return fisheryRegionTreeSelectionModel;
    }

    public SensitivityInputHandler getHandler() {
        return handler;
    }

    public JPanel getInputPane() {
        return inputPane;
    }

    public JPanel getInputPanePrincipal() {
        return inputPanePrincipal;
    }

    public JLabel getNone() {
        return none;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFisheryRegion(FisheryRegion fisheryRegion) {
        FisheryRegion oldValue = this.fisheryRegion;
        this.fisheryRegion = fisheryRegion;
        firePropertyChange(PROPERTY_FISHERY_REGION, oldValue, fisheryRegion);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected JSplitPane get$JSplitPane1() {
        return $JSplitPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToInputPanePrincipal() {
        if (!allComponentsCreated) {
            return;
        }
        inputPanePrincipal.add($JPanel1, "none");
        inputPanePrincipal.add(inputPane, "normale");
    }

    protected void createCardlayout() {
        $objectMap.put("cardlayout", cardlayout = new CardLayout2());
    }

    protected void createCardlayoutPrincipal() {
        $objectMap.put("cardlayoutPrincipal", cardlayoutPrincipal = new CardLayout());
    }

    protected void createFactorsTree() {
        $objectMap.put("factorsTree", factorsTree = new FactorTree(this));
        
        factorsTree.setName("factorsTree");
        factorsTree.setRootVisible(true);
        factorsTree.setSelectionRow(0);
        factorsTree.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__factorsTree"));
    }

    protected void createFisheryRegion() {
        $objectMap.put("fisheryRegion", fisheryRegion = null);
    }

    protected void createFisheryRegionTree() {
        $objectMap.put("fisheryRegionTree", fisheryRegionTree = new JTree());
        
        fisheryRegionTree.setName("fisheryRegionTree");
        fisheryRegionTree.setRootVisible(true);
        fisheryRegionTree.setSelectionRow(0);
        fisheryRegionTree.addTreeSelectionListener(JAXXUtil.getEventListener(TreeSelectionListener.class, "valueChanged", this, "doValueChanged__on__fisheryRegionTree"));
    }

    protected void createFisheryRegionTreeSelectionModel() {
        $objectMap.put("fisheryRegionTreeSelectionModel", fisheryRegionTreeSelectionModel = new DefaultTreeSelectionModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SensitivityInputHandler());
    }

    protected void createInputPane() {
        $objectMap.put("inputPane", inputPane = new JPanel());
        
        inputPane.setName("inputPane");
        inputPane.setLayout(getCardlayout());
    }

    protected void createInputPanePrincipal() {
        $objectMap.put("inputPanePrincipal", inputPanePrincipal = new JPanel());
        
        inputPanePrincipal.setName("inputPanePrincipal");
        inputPanePrincipal.setLayout(getCardlayoutPrincipal());
    }

    protected void createNone() {
        $objectMap.put("none", none = new JLabel());
        
        none.setName("none");
        none.setHorizontalAlignment(0);
        none.setText(t("isisfish.input.selectRegion"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $NavigationUI0
        add($JSplitPane0, BorderLayout.CENTER);
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add(inputPanePrincipal, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add($JSplitPane1, BorderLayout.CENTER);
        // inline complete setup of $JSplitPane1
        $JSplitPane1.add($JScrollPane0, JSplitPane.LEFT);
        $JSplitPane1.add($Table0, JSplitPane.RIGHT);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fisheryRegionTree);
        // inline complete setup of $Table0
        $Table0.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(factorsTree);
        addChildrenToInputPanePrincipal();
        // inline complete setup of $JPanel1
        $JPanel1.add(none, BorderLayout.CENTER);
        
        // apply 12 property setters
        fisheryRegionTreeSelectionModel.setSelectionMode(javax.swing.tree.TreeSelectionModel.SINGLE_TREE_SELECTION);
        fisheryRegionTree.setModel(new DefaultTreeModel(null));
        fisheryRegionTree.setSelectionModel(getFisheryRegionTreeSelectionModel());
        $JButton0.setIcon(SwingUtil.createImageIcon("factors/dgroup.png"));
        $JButton1.setIcon(SwingUtil.createImageIcon("factors/cgroup.png"));
        $JButton2.setIcon(SwingUtil.createImageIcon("script_go.png"));
        factorsTree.setCellRenderer(new FactorTreeCellRenderer());
        factorsTree.setModel(new FactorTreeModel(getSimulAction().getFactorGroup()));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$NavigationUI0", $NavigationUI0);
        createHandler();
        createFisheryRegion();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(200);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(1);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JSplitPane1
        $objectMap.put("$JSplitPane1", $JSplitPane1 = new JSplitPane());
        
        $JSplitPane1.setName("$JSplitPane1");
        $JSplitPane1.setDividerLocation(400);
        $JSplitPane1.setOneTouchExpandable(true);
        $JSplitPane1.setOrientation(0);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFisheryRegionTreeSelectionModel();
        createFisheryRegionTree();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(t("isisfish.sensitivity.newfactordgroup.tip"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(t("isisfish.sensitivity.newfactorcgroup.tip"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setToolTipText(t("isisfish.sensitivity.mexico.exporttoxml.tip"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFactorsTree();
        createCardlayoutPrincipal();
        createInputPanePrincipal();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createNone();
        createCardlayout();
        createInputPane();
        // inline creation of $NavigationUI0
        setName("$NavigationUI0");
        
        $completeSetup();
    }

}