/*
 * #%L
 * $Id: ResultMatrixFilter.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.1.2/src/main/java/fr/ifremer/isisfish/ui/result/ResultMatrixFilter.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n.t;

import java.util.ArrayList;
import java.util.List;

import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixFilter;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.types.TimeStep;

/**
 * Filtre qui ajoute les trou dans les données (valeur intermédiares absentes)
 * et qui supprime les bornes sans valeures ensuite.
 * 
 * Modifie egalement le titre de la matrice.
 * 
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * By : $Author: echatellier $
 */
public class ResultMatrixFilter implements MatrixFilter {

    protected ResultStorage resultStorage;

    public ResultMatrixFilter(ResultStorage resultStorage) {
        this.resultStorage = resultStorage;
    }

    @Override
    public MatrixND filter(MatrixND matrix) {
        return matrix;
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixFilter#filterDimension(org.nuiton.math.matrix.MatrixND, int, int)
     */
    @Override
    public MatrixND filterDimension(MatrixND matrix, int dim, int sumStep) {

        if (dim == 0 && sumStep == 12) {
            // si c une somme pour les annees, on change l'intitule
            matrix.setDimensionName(0, t("isisfish.common.year"));
        }

        // #1905 : modifie les semantiques de type Date pour que lorsque
        // c'est par exemple une somme par année
        // les semantique se nomment
        // janvier 0, janvier 1...
        // plutot que
        // janvier 0, fevrier 0...
        if (dim == 0) {
            List sem = matrix.getSemantic(dim);
            List<Object> semList = (List<Object>)sem;
            List<Object> newList = new ArrayList<Object>();
            for (int index = 0 ; index < semList.size(); ++index) {
                Object semObject = semList.get(index);
                if (semObject instanceof TimeStep) {
                    TimeStep semStep = (TimeStep)semObject;
                    TimeStep newStep = new TimeStep(semStep.getStep() * sumStep);
                    newList.add(newStep);
                }
                else {
                    newList.add(semObject);
                }
            }
            matrix.setSemantic(dim, newList);
        }
        // end semantics modification */
        
        return matrix;
    }
}
