/*
 * #%L
 * $Id: MatrixMapRenderer.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.1.2/src/main/java/fr/ifremer/isisfish/ui/result/MatrixMapRenderer.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n.t;

import java.awt.Component;

import javax.swing.Icon;

import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixRenderer;

import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.gui.Tool;

import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.ResultatLayer;

/**
 * Result matrix viewer map renderer.
 * 
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * By : $Author: echatellier $
 */
public class MatrixMapRenderer implements MatrixRenderer {

    protected MapRendererUI mapRendererUI;

    public MatrixMapRenderer(FisheryRegion fisheryRegion) {
        mapRendererUI = new MapRendererUI();
        
        // Create the directional and zoom control tool
        //OMToolSet resultatMapOMTS = new OMToolSet();
        // Associate the tool with the map
        //resultatMapOMTS.setupListeners(mapRendererUI.getIsisMapBean());
        // Add the tool to the map toolbar
        //mapRendererUI.getToolPanel().add((Tool)resultatMapOMTS);

        //mapRendererUI.getInformationDelegator().setMap(getIsisMapBean());
        //mapRendererUI.getInformationDelegator().setShowLights(false);
        //mapRendererUI.getInformationDelegator().setLabel(t("isisfish.simpleResult.more.information"));
        
        // set fishery region
        mapRendererUI.getIsisMapBean().setFisheryRegion(fisheryRegion);
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixRenderer#getComponent(org.nuiton.math.matrix.MatrixND)
     */
    @Override
    public Component getComponent(MatrixND matrix) {
        
        ResultatLayer layer = new ResultatLayer();
        layer.setMatriceInfo(matrix);
        mapRendererUI.getIsisMapBean().removeAllResultatLayer();
        
        mapRendererUI.getIsisMapBean().addResultatLayer(matrix.getName(), layer);
        mapRendererUI.getLegendPanel().setModel(new LegendModel(0,Math.round(layer.getDataMapList().getMaxDataMapValue())));
        // poussin 20060822 FIXME: migration vers v3, je ne sais pas comment ca merchait avant, la methode n'existe pas :(
        // getInformationDelegator().addLayer(layer);

        return mapRendererUI;
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixRenderer#getIcon()
     */
    @Override
    public Icon getIcon() {
        return null;
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixRenderer#getName()
     */
    @Override
    public String getName() {
        return t("isisfish.result.map");
    }

}
