/*
 * #%L
 * IsisFish
 * 
 * $Id: ExportNameListRenderer.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.export;

import static org.nuiton.i18n.I18n.t;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.ui.util.TooltipHelper;

/**
 * Renderer pour la combo des noms d'export.
 *
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * By : $Author: echatellier $
 */
public class ExportNameListRenderer extends DefaultListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** Export cache. */
    protected Map<String, Export> exportCache;

    /**
     * Empty constructor.
     */
    public ExportNameListRenderer() {
        exportCache = new HashMap<String, Export>();
    }

    /*
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        // this must be used to have alterned highlight rows and default
        // selection color
        JLabel c = (JLabel) super.getListCellRendererComponent(list, value,
                index, isSelected, cellHasFocus);

        String exportName = (String) value;
        c.setText(exportName);

        // c'est tres couteux d'avoir une instance
        // on les met en cache
        try {
            Export export = exportCache.get(exportName);
            if (export == null) {
                ExportStorage storage = ExportStorage.getExport(exportName);
                export = storage.getNewInstance();
                exportCache.put(exportName, export);
            }

            c.setToolTipText(export.getDescription());
        } catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(t("isisfish.error.compile.fileerror", exportName));
            c.setToolTipText(errorTooltip);
        }

        return c;
    }
}
