package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Species;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PopulationBasicsUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUTTON_POPULATION_BASICS_CREATE_CLASSES_ENABLED = "buttonPopulationBasicsCreateClasses.enabled";
    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_COMMENT_ENABLED = "fieldPopulationBasicsComment.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_COMMENT_TEXT = "fieldPopulationBasicsComment.text";
    public static final String BINDING_FIELD_POPULATION_BASICS_GEOGRAPHIC_ID_ENABLED = "fieldPopulationBasicsGeographicID.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_GEOGRAPHIC_ID_TEXT = "fieldPopulationBasicsGeographicID.text";
    public static final String BINDING_FIELD_POPULATION_BASICS_NAME_ENABLED = "fieldPopulationBasicsName.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_NAME_TEXT = "fieldPopulationBasicsName.text";
    public static final String BINDING_FIELD_POPULATION_BASICS_NB_CLASSES_ENABLED = "fieldPopulationBasicsNbClasses.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_NB_CLASSES_TEXT = "fieldPopulationBasicsNbClasses.text";
    public static final String BINDING_FIELD_POPULATION_BASICS_PLUS_GROUP_ENABLED = "fieldPopulationBasicsPlusGroup.enabled";
    public static final String BINDING_FIELD_POPULATION_BASICS_PLUS_GROUP_SELECTED = "fieldPopulationBasicsPlusGroup.selected";
    public static final String BINDING_FIELD_POPULATION_GROUP_MAX_ENABLED = "fieldPopulationGroupMax.enabled";
    public static final String BINDING_FIELD_POPULATION_GROUP_MAX_TEXT = "fieldPopulationGroupMax.text";
    public static final String BINDING_FIELD_POPULATION_GROUP_MIN_ENABLED = "fieldPopulationGroupMin.enabled";
    public static final String BINDING_FIELD_POPULATION_GROUP_MIN_TEXT = "fieldPopulationGroupMin.text";
    public static final String BINDING_GROWTH_EQUATION_ACTIVE = "growthEquation.active";
    public static final String BINDING_GROWTH_EQUATION_BEAN = "growthEquation.bean";
    public static final String BINDING_GROWTH_REVERSE_EQUATION_ACTIVE = "growthReverseEquation.active";
    public static final String BINDING_GROWTH_REVERSE_EQUATION_BEAN = "growthReverseEquation.bean";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";
    private static final String BINDING_$JLABEL5_ENABLED = "$JLabel5.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHJyY/mqZNSyMnKaRV0gRVqGjdpo0QStU2cUjjyG1CnaAKH2C8O7YnrHe3M7PJpgfEn8CfAHcuSNw4IQ6cOXBBSFy4cKAIIa6IN7v2btbZrEcaH9bxvvc+831vfrzJ13+iEc7QwgEOAoP5jqAdYmyvPX++0zggptgg3GTUEy5D0WeogAp1NGHF77lAi/WqDC91w0tlt+O5DnFORK9W0Xkujm3C24QIga6lI0zOS7XYvBp4PutRY1FZ1C///qvwhfX5VwWEAg/UzUMq84OikkyGq6hALYGuwEiHuGRjpwUyGHVaoPeifFe2MedPcYe8QJ+hsSoa9TADmEA31FMOGWF84Al0eanieL4ou44A9/3KbYFKTWbQJiMdAt+c8iblbcOnBpWOxq7r+TYW1HXWMacm3694XogbFWi4QbAj0M0sANCpoISfACSB44fYphYGmQLdShUsNhj8CAph1OTzw97Lk0O71jGUTlYp6Ppu72KH2InP2NIebtgEUpxNjRF5hzbpeaU/4I78OSMfxX7TcmyajU3nlraruEHs2/1ywrfS6Y3Y92qTEtvqr6mcYYGmU8F7JBCb0jkN6A0Waryeti1kwh8Tt8Ww16ZmZUM6LmQDlzOA17PVNsIlRXgGbbHhC+E6/SFlRrAg3TCBplKZrochKiPv2j5/zFwf1nExhSi3ifnpuhtkp3Y3I7XufN6N5zMxzfSNHY74hDpxusunRrgXj7A8AIODDMykkFrWWqRKnJZo96+jeKUmGidbzD0S7fdf+CF70CYO9/yOQ3r++5U0rhjhnpFDwnjsJY0Ps0u6klHSi0vbNZO5ti23IWyGmVQSiSkdNZc503CgdcKDrnhqU6zBWpKxG/1zee/sbbsSm7aTE4Tjw1DLO/JRjd+Pmtgxo317yhIu4yyLRWyStjD0ZurQgR5jJD0maQJDdTTCfFtui9n66bb0DExRQ5rta0gSGFr/m576+btfv93sdaEVGLuY6XqiiUJ38JjrESbPaIEuRS3IF9QuPcHeah2Nc0jJjDrsXIawWtcM4mC812W4IcONLczbgBgZ++X7H6Y/+ek1VNhE520XW5tY+lfQuGgzqIJrW4H38FGo6MLROXheltpgzogj5wwa4+R9OPXxfIM6Fkz/gwCqMJdRhVhKY/zHf6dq3zzqVWIIlF090z2pxshHaJQ6NnVI2JG7zTazA094nPiWmzTVrDY7JL+ved1OVA+fH2elOixgQcN2vx+NPo8FtH84QgnkKoPMMAn5F1Fkytfh9mhkE+aVCFSbkKdhUV3DgQ4hT8Nb2nVQI+RpuKldh8EEOLKJRUWvg5zBeVs7FzVCXj31NdzSrqcaIU+DoTIj0dFKLC3OoFxUlEwI17X3qCf7qhZqUFnuaKejRsjTsKK9RNUIeRre1a6DGiFPw3vadVAj4JwsVhUW5zjcSbcIbbXzlqYKaBQuHjS6652R0AOVXi3/2dVkXJCM3ejedZyTlQprxLTxy5eagi41XdaBm2EZ7rUtl+lpGrR01Qi/5aS0pkT4XZvwR04WaoRX2hr+0daQNxdqhLxjpKytQY2Qp2FL+yhTI+Rp2NGugxohT8MH2hrUCHkaatoa1Ah5Gva1NUjC/3XsEjKVFgAA";
    private static final Log log = LogFactory.getLog(PopulationBasicsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton buttonPopulationBasicsCreateClasses;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldPopulationBasicsComment;
    protected JTextField fieldPopulationBasicsGeographicID;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldPopulationBasicsName")
    protected JTextField fieldPopulationBasicsName;
    protected JTextField fieldPopulationBasicsNbClasses;
    protected JCheckBox fieldPopulationBasicsPlusGroup;
    protected JTextField fieldPopulationGroupMax;
    protected JTextField fieldPopulationGroupMin;
    protected InputOneEquationUI growthEquation;
    protected InputOneEquationUI growthReverseEquation;
    protected JButton save;
    protected JTable tableAgeLength;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationBasicsUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;
    private Table $Table5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldPopulationBasicsName.setText("");
                    fieldPopulationBasicsGeographicID.setText("");
                    fieldPopulationBasicsNbClasses.setText("");
                    fieldPopulationBasicsComment.setText("");
                    tableAgeLength.setModel(new DefaultTableModel());
                }
                if (evt.getNewValue() != null) {
                    setTableAgeLengthModel();
                }
            }
        });
    }
    
    public void refresh() {
        Population population = getSaveVerifier().getEntity(Population.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean(population);
        
        if (getBean() != null) {
            setTableAgeLengthModel();
        }
        //getSaveVerifier().addCurrentPanel(growthEquation, growthReverseEquation);
    }
    
    /**
     * Open creation classe wizard after confirmation.
     */
    protected void createGroups() {
    
        int response = JOptionPane.showConfirmDialog(this, t("isisfish.populationBasics.confirmCreateGroups"),
            t("isisfish.common.confirm"), JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        
        if (response == JOptionPane.YES_OPTION) {
            JFrame wizardFrame = new JFrame();
            wizardFrame.setLayout(new BorderLayout());
            WizardGroupCreationUI wizard = new WizardGroupCreationUI(this);
            wizard.init(this);
            wizardFrame.add(wizard, BorderLayout.CENTER);
            wizardFrame.setTitle(t("isisfish.wizardGroupCreation.title"));
            Species species = getBean().getSpecies();
            wizard.setAgeType(species.getAgeGroupType());
            if (wizard.isAgeType()) {
                wizard.setCard("singleGroupAge");
            } else {
                wizard.setCard("beginGroupLength");
            }
            wizardFrame.pack();
            wizardFrame.setLocationRelativeTo(this);
            wizardFrame.setVisible(true);
        }
       
    }
    
    protected void setTableAgeLengthModel() {
        java.util.List<PopulationGroup> popGroup = getBean().getPopulationGroup();
        if (popGroup != null){
            DefaultTableModel model = new DefaultTableModel(2, popGroup.size() + 1);
            model.setValueAt("Age", 0, 0);
            model.setValueAt("Lengths", 1, 0);
            int cnt = 1;
            for (PopulationGroup pg : popGroup){
                model.setValueAt(pg.getAge(), 0, cnt);
                model.setValueAt(pg.getLength(), 1, cnt);
                cnt++;
            }
            tableAgeLength.setModel(model);
        }
    }
    
    protected void create() {
        // find species node
        InputUI inputUI = getContextValue(InputUI.class, JAXXUtil.PARENT);
        Species species = inputUI.getHandler().findSpecies(inputUI);
        // create node and select it
        Population population = getContextValue(InputAction.class).createPopulation(getTopiaContext(), species);
        inputUI.getHandler().insertTreeNode(inputUI, Population.class, population);
        setInfoText(t("isisfish.message.creation.finished"));
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationBasicsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationBasicsUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationBasicsUI() {
        $initialize();
    }

    public PopulationBasicsUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationBasicsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationBasicsUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationBasicsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationBasicsUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonPopulationBasicsCreateClasses(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        createGroups();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        create();
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().delete();
    }

    public void doActionPerformed__on__fieldPopulationBasicsPlusGroup(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setPlusGroup(fieldPopulationBasicsPlusGroup.isSelected());
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldPopulationBasicsComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldPopulationBasicsComment.getText());
    }

    public void doKeyReleased__on__fieldPopulationBasicsGeographicID(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setGeographicId(fieldPopulationBasicsGeographicID.getText());
    }

    public void doKeyReleased__on__fieldPopulationBasicsName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldPopulationBasicsName.getText());
    }

    public void doKeyReleased__on__fieldPopulationGroupMax(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setGroupMax(Integer.parseInt(fieldPopulationGroupMax.getText()));
    }

    public void doKeyReleased__on__fieldPopulationGroupMin(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setGroupMin(Integer.parseInt(fieldPopulationGroupMin.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getButtonPopulationBasicsCreateClasses() {
        return buttonPopulationBasicsCreateClasses;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldPopulationBasicsComment() {
        return fieldPopulationBasicsComment;
    }

    public JTextField getFieldPopulationBasicsGeographicID() {
        return fieldPopulationBasicsGeographicID;
    }

    public JTextField getFieldPopulationBasicsName() {
        return fieldPopulationBasicsName;
    }

    public JTextField getFieldPopulationBasicsNbClasses() {
        return fieldPopulationBasicsNbClasses;
    }

    public JCheckBox getFieldPopulationBasicsPlusGroup() {
        return fieldPopulationBasicsPlusGroup;
    }

    public JTextField getFieldPopulationGroupMax() {
        return fieldPopulationGroupMax;
    }

    public JTextField getFieldPopulationGroupMin() {
        return fieldPopulationGroupMin;
    }

    public InputOneEquationUI getGrowthEquation() {
        return growthEquation;
    }

    public InputOneEquationUI getGrowthReverseEquation() {
        return growthReverseEquation;
    }

    public JButton getSave() {
        return save;
    }

    public JTable getTableAgeLength() {
        return tableAgeLength;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    protected Table get$Table5() {
        return $Table5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createButtonPopulationBasicsCreateClasses() {
        $objectMap.put("buttonPopulationBasicsCreateClasses", buttonPopulationBasicsCreateClasses = new JButton());
        
        buttonPopulationBasicsCreateClasses.setName("buttonPopulationBasicsCreateClasses");
        buttonPopulationBasicsCreateClasses.setText(t("isisfish.populationBasics.recreateClasses"));
        buttonPopulationBasicsCreateClasses.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonPopulationBasicsCreateClasses"));
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldPopulationBasicsComment() {
        $objectMap.put("fieldPopulationBasicsComment", fieldPopulationBasicsComment = new JTextArea());
        
        fieldPopulationBasicsComment.setName("fieldPopulationBasicsComment");
        fieldPopulationBasicsComment.setColumns(15);
        fieldPopulationBasicsComment.setLineWrap(true);
        fieldPopulationBasicsComment.setWrapStyleWord(true);
        fieldPopulationBasicsComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationBasicsComment"));
    }

    protected void createFieldPopulationBasicsGeographicID() {
        $objectMap.put("fieldPopulationBasicsGeographicID", fieldPopulationBasicsGeographicID = new JTextField());
        
        fieldPopulationBasicsGeographicID.setName("fieldPopulationBasicsGeographicID");
        fieldPopulationBasicsGeographicID.setColumns(15);
        fieldPopulationBasicsGeographicID.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationBasicsGeographicID"));
    }

    protected void createFieldPopulationBasicsName() {
        $objectMap.put("fieldPopulationBasicsName", fieldPopulationBasicsName = new JTextField());
        
        fieldPopulationBasicsName.setName("fieldPopulationBasicsName");
        fieldPopulationBasicsName.setColumns(15);
        fieldPopulationBasicsName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationBasicsName"));
    }

    protected void createFieldPopulationBasicsNbClasses() {
        $objectMap.put("fieldPopulationBasicsNbClasses", fieldPopulationBasicsNbClasses = new JTextField());
        
        fieldPopulationBasicsNbClasses.setName("fieldPopulationBasicsNbClasses");
        fieldPopulationBasicsNbClasses.setColumns(15);
        fieldPopulationBasicsNbClasses.setEditable(false);
    }

    protected void createFieldPopulationBasicsPlusGroup() {
        $objectMap.put("fieldPopulationBasicsPlusGroup", fieldPopulationBasicsPlusGroup = new JCheckBox());
        
        fieldPopulationBasicsPlusGroup.setName("fieldPopulationBasicsPlusGroup");
        fieldPopulationBasicsPlusGroup.setText(t("isisfish.populationBasics.plusGroup"));
        fieldPopulationBasicsPlusGroup.setToolTipText(t("isisfish.populationBasics.plusGroupTip"));
        fieldPopulationBasicsPlusGroup.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationBasicsPlusGroup"));
        fieldPopulationBasicsPlusGroup.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationBasicsPlusGroup.putClientProperty("sensitivityMethod", "PlusGroup");
    }

    protected void createFieldPopulationGroupMax() {
        $objectMap.put("fieldPopulationGroupMax", fieldPopulationGroupMax = new JTextField());
        
        fieldPopulationGroupMax.setName("fieldPopulationGroupMax");
        fieldPopulationGroupMax.setColumns(15);
        fieldPopulationGroupMax.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationGroupMax"));
        fieldPopulationGroupMax.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationGroupMax.putClientProperty("sensitivityMethod", "MaxAge");
    }

    protected void createFieldPopulationGroupMin() {
        $objectMap.put("fieldPopulationGroupMin", fieldPopulationGroupMin = new JTextField());
        
        fieldPopulationGroupMin.setName("fieldPopulationGroupMin");
        fieldPopulationGroupMin.setColumns(15);
        fieldPopulationGroupMin.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationGroupMin"));
        fieldPopulationGroupMin.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationGroupMin.putClientProperty("sensitivityMethod", "MinAge");
    }

    protected void createGrowthEquation() {
        $objectMap.put("growthEquation", growthEquation = new InputOneEquationUI(this));
        
        growthEquation.setName("growthEquation");
        growthEquation.setBeanProperty("growth");
        growthEquation.setFormuleCategory("Growth");
        growthEquation.setText(t("isisfish.populationBasics.growth"));
        growthEquation.putClientProperty("sensitivityBean", Population.class);
        growthEquation.putClientProperty("sensitivityMethod", "Growth");
    }

    protected void createGrowthReverseEquation() {
        $objectMap.put("growthReverseEquation", growthReverseEquation = new InputOneEquationUI(this));
        
        growthReverseEquation.setName("growthReverseEquation");
        growthReverseEquation.setBeanProperty("GrowthReverse");
        growthReverseEquation.setFormuleCategory("GrowthReverse");
        growthReverseEquation.setText(t("isisfish.populationBasics.growthReverse"));
        growthReverseEquation.putClientProperty("sensitivityBean", Population.class);
        growthReverseEquation.putClientProperty("sensitivityMethod", "GrowthReverse");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createTableAgeLength() {
        $objectMap.put("tableAgeLength", tableAgeLength = new JTable());
        
        tableAgeLength.setName("tableAgeLength");
        tableAgeLength.setEnabled(false);
        tableAgeLength.setRowHeight(24);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Population.class, "basics"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table4, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($Table2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsName)), new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsGeographicID), new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsNbClasses), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(buttonPopulationBasicsCreateClasses), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsPlusGroup), new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add($Table3, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(tableAgeLength), new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(growthEquation), new GridBagConstraints(0, 5, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(growthReverseEquation), new GridBagConstraints(0, 6, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel5, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane0, new GridBagConstraints(1, 7, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table3
        $Table3.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupMin), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel4, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationGroupMax), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldPopulationBasicsComment));
        // inline complete setup of $Table4
        $Table4.add($Table5, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table5
        $Table5.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 30 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        growthEquation.setClazz(fr.ifremer.isisfish.equation.PopulationGrowth.class);
        growthReverseEquation.setClazz(fr.ifremer.isisfish.equation.PopulationGrowthReverse.class);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.populationBasics.name"));
        createFieldPopulationBasicsName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationBasics.geographicID"));
        createFieldPopulationBasicsGeographicID();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.populationBasics.numberGroup"));
        createFieldPopulationBasicsNbClasses();
        createButtonPopulationBasicsCreateClasses();
        createFieldPopulationBasicsPlusGroup();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.populationBasics.groupMin"));
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        createFieldPopulationGroupMin();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.populationBasics.groupMax"));
        createFieldPopulationGroupMax();
        createTableAgeLength();
        createGrowthEquation();
        createGrowthReverseEquation();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("isisfish.population.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldPopulationBasicsComment();
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new Table());
        
        $Table5.setName("$Table5");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 30 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 30 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationBasicsName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationBasicsName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_GEOGRAPHIC_ID_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationBasicsGeographicID.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_GEOGRAPHIC_ID_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationBasicsGeographicID, jaxx.runtime.SwingUtil.getStringValue(getBean().getGeographicId()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_NB_CLASSES_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationBasicsNbClasses.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_NB_CLASSES_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationBasicsNbClasses, String.valueOf(getBean() == null ? "" : getBean().sizePopulationGroup()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_POPULATION_BASICS_CREATE_CLASSES_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                buttonPopulationBasicsCreateClasses.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_PLUS_GROUP_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationBasicsPlusGroup.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_PLUS_GROUP_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    fieldPopulationBasicsPlusGroup.setSelected(getBean().getPlusGroup());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_GROUP_MIN_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationGroupMin.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_GROUP_MIN_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationGroupMin, String.valueOf(getBean().getGroupMin()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_GROUP_MAX_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationGroupMax.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_GROUP_MAX_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationGroupMax, String.valueOf(getBean().getGroupMax()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROWTH_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                growthEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROWTH_EQUATION_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                growthEquation.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROWTH_REVERSE_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                growthReverseEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROWTH_REVERSE_EQUATION_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                growthReverseEquation.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationBasicsComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_BASICS_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationBasicsComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    create.setEnabled(!validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                addPropertyChangeListener("bean", this);
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    delete.setEnabled(!validator.isChanged() && getBean() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                removePropertyChangeListener("bean", this);
            }
        });
    }

}