package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Metier;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

public class MetierUI extends InputContentUI<fr.ifremer.isisfish.entities.Metier> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_METIER_SEASON_INFO_UI_ACTIVE = "metierSeasonInfoUI.active";
    public static final String BINDING_METIER_SEASON_INFO_UI_BEAN = "metierSeasonInfoUI.bean";
    public static final String BINDING_METIER_SEASON_INFO_UI_SENSITIVITY = "metierSeasonInfoUI.sensitivity";
    public static final String BINDING_METIER_SEASON_SPECIES_UI_ACTIVE = "metierSeasonSpeciesUI.active";
    public static final String BINDING_METIER_SEASON_SPECIES_UI_BEAN = "metierSeasonSpeciesUI.bean";
    public static final String BINDING_METIER_SEASON_SPECIES_UI_SENSITIVITY = "metierSeasonSpeciesUI.sensitivity";
    public static final String BINDING_METIER_TAB_UI_ACTIVE = "metierTabUI.active";
    public static final String BINDING_METIER_TAB_UI_BEAN = "metierTabUI.bean";
    public static final String BINDING_METIER_TAB_UI_SENSITIVITY = "metierTabUI.sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHXystlqpgCQiKCSomxsMW0BgT/IHBEEuKEmsTQi9Ou1M6ZDs7zszCcjH+Cf4Jevdi4s2T8eDZgxfjv2CMB6/GN9t2t4UVa9rDbvPe+37mvbfz3pvvkFISLuwQ37ekxzVrUmvt3ubmo+oOren7VNUkE9qV0PolkpCsQNYO7UrDpUrRyPNteX7FbQqXU96lXirCiNL7DlUNSrWG872KmlL5Uuhe8oUnO9QwqTjqq58/ki/tF6+TAL7A7EawlNl/qaJKhoqQZLaGHJ60S/IO4duYhmR8G/M9aWwrDlHqIWnSZ/AchouQFkQiTMPF/ksOGIHeFxrG5gpceHrF5RrDy4V5DZfr0mJ1SZsU34qpOlMNy2MWM4HWOtWMynJBiACS1jBUpYRj2+NkyGQYr9qybpFr72OppirfUntYpLW2QTh1ophMMxA9IVUNZ3oC0VSltgk3oaOhIhsqygUNV/ooJAg16lwIybUgJUqUywu87hrWtT5YkWILm38QO9GNLQlaw7YY8o3/IofCXnhmDgsxfvx+Z3tuXKtjba84LFgwhtkYx2LHIeFcDxGnw4qmI7q+iQqkpIdmDVOVwwP1GF2tUZo6MEoGGHh/T45/ef/t3WpnfjJ49kRsaNf4470W0hVUmnumYbQ1PJ5mTn6diKUKUqiDuyPYDTMxiZXabkwOzztt5JaRWw+IaiAiNfz1w8fJp5+PQXIVRhyX2KvExBcgoxsSu+A6ti/uLgcZndg7js8xk5uGNMaxXezRqVs20WS2yriNX+OOj02YiWlCmEk18+nXeOntcqcRCUxs+q/hUTNSW5Bm3GGcBqukvSViV0dWKOrZbrQN4vZDwrwnRft2XA2eVlylwQ4w3gXfM6/FIGnz73rfjKyiXOG22GV6fyCUMc8fQZjui3BzYMLtgQlHVTEzcBX9EY6qwhD+AGhwfTWzBwAA";
    private static final Log log = LogFactory.getLog(MetierUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Metier bean;
    protected MetierSeasonInfoZoneUI metierSeasonInfoUI;
    protected MetierSeasonInfoSpeciesUI metierSeasonSpeciesUI;
    protected JTabbedPane metierTab;
    protected MetierTabUI metierTabUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MetierUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        setButtonTitle(t("isisfish.input.continueTripTypes"));
        setNextPath(n("isisfish.input.tree.triptypes"));
        
        // install change listener
        // (depends on sensitivity can't be done on constructor)
        installChangeListener(metierTab);
    }
    
    @Override
    public void setLayer(boolean active) {
        super.setLayer(active);
        metierTabUI.setLayer(active);
        metierSeasonInfoUI.setLayer(active);
        metierSeasonSpeciesUI.setLayer(active);
    }
    
    @Override
    public void resetChangeModel() {
        metierTabUI.resetChangeModel();
        metierSeasonInfoUI.resetChangeModel();
        metierSeasonSpeciesUI.resetChangeModel();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MetierUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MetierUI() {
        $initialize();
    }

    public MetierUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public MetierUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MetierUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MetierUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Metier getBean() {
        return bean;
    }

    public MetierSeasonInfoZoneUI getMetierSeasonInfoUI() {
        return metierSeasonInfoUI;
    }

    public MetierSeasonInfoSpeciesUI getMetierSeasonSpeciesUI() {
        return metierSeasonSpeciesUI;
    }

    public JTabbedPane getMetierTab() {
        return metierTab;
    }

    public MetierTabUI getMetierTabUI() {
        return metierTabUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Metier bean) {
        Metier oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(metierTab, BorderLayout.CENTER);
    }

    protected void addChildrenToMetierTab() {
        if (!allComponentsCreated) {
            return;
        }
        metierTab.add(metierTabUI);
        metierTab.add(metierSeasonInfoUI);
        metierTab.add(metierSeasonSpeciesUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(metierTab, 0));
        metierTab.setTitleAt(0, t("isisfish.metier.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(metierTab, 1));
        metierTab.setTitleAt(1, t("isisfish.metierSeasonInfoZone.title"));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(metierTab, 2));
        metierTab.setTitleAt(2, t("isisfish.metierSeasonInfoSpecies.title"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createMetierSeasonInfoUI() {
        $objectMap.put("metierSeasonInfoUI", metierSeasonInfoUI = new MetierSeasonInfoZoneUI(this));
        
        metierSeasonInfoUI.setName("metierSeasonInfoUI");
    }

    protected void createMetierSeasonSpeciesUI() {
        $objectMap.put("metierSeasonSpeciesUI", metierSeasonSpeciesUI = new MetierSeasonInfoSpeciesUI(this));
        
        metierSeasonSpeciesUI.setName("metierSeasonSpeciesUI");
    }

    protected void createMetierTab() {
        $objectMap.put("metierTab", metierTab = new JTabbedPane());
        
        metierTab.setName("metierTab");
    }

    protected void createMetierTabUI() {
        $objectMap.put("metierTabUI", metierTabUI = new MetierTabUI(this));
        
        metierTabUI.setName("metierTabUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToMetierTab();
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createMetierTab();
        createMetierTabUI();
        createMetierSeasonInfoUI();
        createMetierSeasonSpeciesUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.metier.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("isisfish.metierSeasonInfoZone.title"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(t("isisfish.metierSeasonInfoSpecies.title"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_TAB_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                metierTabUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_TAB_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                metierTabUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_TAB_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                metierTabUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_INFO_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                metierSeasonInfoUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_INFO_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                metierSeasonInfoUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_INFO_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                metierSeasonInfoUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_SPECIES_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                metierSeasonSpeciesUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_SPECIES_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                metierSeasonSpeciesUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_SPECIES_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                metierSeasonSpeciesUI.setSensitivity(isSensitivity());
            }
        });
    }

}