package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.ui.input.model.MetierSeasonInfoComboModel;
import fr.ifremer.isisfish.ui.input.model.MetierSeasonInfoTargetSpeciesTableModel;
import fr.ifremer.isisfish.ui.input.model.SpeciesComboModel;
import fr.ifremer.isisfish.ui.widget.editor.EquationTableEditor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MetierSeasonInfoSpeciesUI extends InputContentUI<Metier> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_METIER_SEASON_INFO = "metierSeasonInfo";
    public static final String PROPERTY_SPECIES = "species";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ENABLED = "add.enabled";
    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_FIELD_METIER_SEASON_INFO_ENABLED = "fieldMetierSeasonInfo.enabled";
    public static final String BINDING_FIELD_PRIMARY_CATCH_ENABLED = "fieldPrimaryCatch.enabled";
    public static final String BINDING_FIELD_TARGET_SPECIES_ENABLED = "fieldTargetSpecies.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TABLE_TARGET_SPECIES_ENABLED = "tableTargetSpecies.enabled";
    public static final String BINDING_TARGET_FACTOR_ACTIVE = "targetFactor.active";
    public static final String BINDING_TARGET_FACTOR_BEAN = "targetFactor.bean";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuLEdNw1NE9qmalqlYETFj3UQUgElKiUuUR05NGKTqsIHGO+O7Sm7O9uZ2WSTA+JP4E+AOxckbpwQB84cuCD+BYQ4cEV9M2t7vbazXrE+7HrnvffNN997+95+/xcqCo7uPMNhaPDAk9Qlxt5HT58+bj8jlnxIhMWpLxlH0W+ugAottGgP14VEr7aaKrzWD6/Vmeszj3gj0VtNdFHIU4eIHiFSolvJCEuImjk0b4V+wAeoQ1LTUL/95+/CN/bX3xUQCn1gdx2OsjErKj7JfBMVqC3RCux0jGsO9rpAg1OvC3yX1FrdwUJ8gl3yHH2Fyk1U8jEHMIleyX5kjaHjQ1+i5WrD8wNZZ54E96PGpkT3OtygHU5cAndBRYeKnhFQgypHY59ISrhJsGBew+sw0ycWJeKo4fsatSTRfJtgD/IwDQc2oQAg+jhx0LI7BizR2xkAYv8YqiwiThJVUxH61OPAyjF2qI1BLYneTORtaDDECeTDMNX1yWAxRli0epA1ss9s4kh0N1XJeuw6qh2zT6EEVLbD/mZ7B9gb9SlXD3HbIZCqtQTJyFvblOfN8YB31OOGutwemhaqe03cJs7m+J56VTndGfpe7VDi2OO6w3oiEGqvzXZYmIwd7KM5vJa0rWjcQ8y7RPZzoix3k16XpHbYxZbOTy1VW13Ujz3y8fMAS8q8o8YEHS3qpnq+lbRd0XQOOHUxP61jafUmjtgj1pcTR7yAbXh5VxOeO4GUzEv6LVX3TIszx1EMQPfriYjYNCaSVClMiDSesmHm3x9GvVxtUiFN4kDzBBl0scGWt0fjJj3iUiuBwOxYg76X5DMv8Mh6XFAlC3tWVDkDC0c3E3UK7dWI22vc/+ZaqMgDRx1srTXZkT8FU9SL18Z6sQLU1v+urf7+058/7g4a8DrsfXWq68j8gMboc+YTLrWml6PuG0jq1Paxv9VCFaHV0cNlfQoxs28GcrDfFRVuqHDjERY9gCiW//j5l2tf/HYBFXbRRYdhOyriBqrIHgcVmGOH/ocPNKNLJwtwXVbc4MWN2gmU1Uvb0GnwRpt6NuTsfggqrE9RYUilXfn131XzhwcDJeaA2Y1z3WM1ip+hEvUc6hE9jPpzZurwWfQFCWwWz5NpE2ZO3W/4/Ypq6uvBtKMWdYtVZjMM1O1Qs1b/nmQGKRNPvQNpMNUMMPOShDBUV7YjJTawhCncDiS5/38x1fLnKaxez8BqAUa9TTjhuXBmMXkjE4JWmORBSOPwVgY1SvAK0agDnYNiZMm0+lTJiVG0HHx2lhPkcodxF/oSzBvSZfw0Rd/ZcLMylA0hLUPv5uaQDSGNw73cHGYjwBedSz3qBq5Jz9KK7YMMUEs+Jx3CObFzg83SZjsDnQpnJ48I7fZkikSzgYZUzkHYyZ2mbAhpcjzMzSEbQhqH3dwcFMILmFd45yEPAAA=";
    private static final Log log = LogFactory.getLog(MetierSeasonInfoSpeciesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected Metier bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JComboBox fieldMetierSeasonInfo;
    protected JCheckBox fieldPrimaryCatch;
    protected JComboBox fieldTargetSpecies;
    protected MetierSeasonInfo metierSeasonInfo;
    protected JButton remove;
    protected JButton save;
    protected Species species;
    protected JTable tableTargetSpecies;
    protected InputOneEquationUI targetFactor;
    @Validator( validatorId = "validator")
    protected SwingValidator<MetierSeasonInfo> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MetierSeasonInfoSpeciesUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                setSeasonModel();
                setSpecies(null);
                setMetierSeasonInfo(null);
                setTargetSpeciesModel();
                setTableTargetSpeciesModel();
            }
        });
    }
    
    @Override
    public void resetChangeModel() {
        changeModel.setStayChanged(false);
    }
    
    protected void setSeasonModel() {
        List<MetierSeasonInfo> metierSeasonInfo = null;
        
        if (getBean() != null) {
            metierSeasonInfo = getBean().getMetierSeasonInfo();
        }
        MetierSeasonInfoComboModel seasonModel = new MetierSeasonInfoComboModel(metierSeasonInfo);
        fieldMetierSeasonInfo.setModel(seasonModel);
    }
    
    protected void metierSeasonInfoChanged() {
        MetierSeasonInfo selectedMSI = (MetierSeasonInfo)fieldMetierSeasonInfo.getSelectedItem();
        setMetierSeasonInfo(selectedMSI);
        if (selectedMSI != null) {
            getSaveVerifier().addCurrentEntity(getMetierSeasonInfo());
            setTableTargetSpeciesModel();
        }
    }
    
    protected void setTargetSpeciesModel() {
        List<Species> species = getFisheryRegion().getSpecies();
        SpeciesComboModel fieldTargetSpeciesModel = new SpeciesComboModel(species);
        fieldTargetSpecies.setModel(fieldTargetSpeciesModel);
    }
    
    protected void speciesChanged() {
        Species species = (Species)fieldTargetSpecies.getSelectedItem();
        setSpecies(species);
    }
    
    protected void setTableTargetSpeciesModel() {
        List<TargetSpecies> targetSpecies = new ArrayList<TargetSpecies>();
    
        if (getBean() != null && getMetierSeasonInfo() != null) {
            // SpeciesTargetSpecies can be null durring region creation
            if (getMetierSeasonInfo().getSpeciesTargetSpecies() != null) {
                // move collection to list
                // and add all entity to verifier
                for (TargetSpecies oneTargetSpecies : getMetierSeasonInfo().getSpeciesTargetSpecies()) {
                    targetSpecies.add(oneTargetSpecies);
                    getSaveVerifier().addCurrentEntity(oneTargetSpecies);
                    oneTargetSpecies.addPropertyChangeListener(new PropertyChangeListener() {
                        public void propertyChange(PropertyChangeEvent evt) {
                            changeModel.setStayChanged(true);
                        }
                    });
                }
            }
        }
        
        // set table model
        MetierSeasonInfoTargetSpeciesTableModel model = new MetierSeasonInfoTargetSpeciesTableModel(targetSpecies);
        tableTargetSpecies.setModel(model);
        tableTargetSpecies.setDefaultRenderer(Equation.class, model);
        tableTargetSpecies.setDefaultEditor(Equation.class, new EquationTableEditor());
    }
    
    protected void add() {
        Species selectedSpecies = (Species)fieldTargetSpecies.getSelectedItem();
        if (selectedSpecies != null) {
            // il n'y en a pas a la creation de la base
            //Formule selectedFormule = (Formule)targetFactor.getFormuleComboBox().getSelectedItem();
            getContextValue(InputAction.class).addTargetSpecies(
                    getBean(),
                    getMetierSeasonInfo(),
                    selectedSpecies,
                    targetFactor.getEditor().getText(),
                    fieldPrimaryCatch.isSelected());
            setTableTargetSpeciesModel();
        }
    }
    
    protected void remove() {
        // TODO change delete selected truc from model
        Object[] targetSpecies = getMetierSeasonInfo().getSpeciesTargetSpecies().toArray();
    
        Object o = targetSpecies[tableTargetSpecies.getSelectedRow()];
        if (o != null) {
            TargetSpecies ts = (TargetSpecies)o;
            getAction().removeTargetSpecies(getMetierSeasonInfo(), ts);
            getSaveVerifier().removeCurrentEntity(ts.getTopiaId());
            setTableTargetSpeciesModel();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MetierSeasonInfoSpeciesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI() {
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoSpeciesUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        add();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        remove();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);changeModel.setStayChanged(false);
    }

    public void doItemStateChanged__on__fieldMetierSeasonInfo(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        metierSeasonInfoChanged();
    }

    public void doItemStateChanged__on__fieldTargetSpecies(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        speciesChanged();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        remove.setEnabled(tableTargetSpecies.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public Metier getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public JComboBox getFieldMetierSeasonInfo() {
        return fieldMetierSeasonInfo;
    }

    public JCheckBox getFieldPrimaryCatch() {
        return fieldPrimaryCatch;
    }

    public JComboBox getFieldTargetSpecies() {
        return fieldTargetSpecies;
    }

    public MetierSeasonInfo getMetierSeasonInfo() {
        return metierSeasonInfo;
    }

    public JButton getRemove() {
        return remove;
    }

    public JButton getSave() {
        return save;
    }

    public Species getSpecies() {
        return species;
    }

    public JTable getTableTargetSpecies() {
        return tableTargetSpecies;
    }

    public InputOneEquationUI getTargetFactor() {
        return targetFactor;
    }

    public SwingValidator<MetierSeasonInfo> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Metier bean) {
        Metier oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo) {
        MetierSeasonInfo oldValue = this.metierSeasonInfo;
        this.metierSeasonInfo = metierSeasonInfo;
        firePropertyChange(PROPERTY_METIER_SEASON_INFO, oldValue, metierSeasonInfo);
    }

    public void setSpecies(Species species) {
        Species oldValue = this.species;
        this.species = species;
        firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setText(t("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createFieldMetierSeasonInfo() {
        $objectMap.put("fieldMetierSeasonInfo", fieldMetierSeasonInfo = new JComboBox());
        
        fieldMetierSeasonInfo.setName("fieldMetierSeasonInfo");
        fieldMetierSeasonInfo.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldMetierSeasonInfo"));
    }

    protected void createFieldPrimaryCatch() {
        $objectMap.put("fieldPrimaryCatch", fieldPrimaryCatch = new JCheckBox());
        
        fieldPrimaryCatch.setName("fieldPrimaryCatch");
        fieldPrimaryCatch.setText(t("isisfish.metierSeasonInfoSpecies.mainSpecies"));
    }

    protected void createFieldTargetSpecies() {
        $objectMap.put("fieldTargetSpecies", fieldTargetSpecies = new JComboBox());
        
        fieldTargetSpecies.setName("fieldTargetSpecies");
        fieldTargetSpecies.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldTargetSpecies"));
    }

    protected void createMetierSeasonInfo() {
        $objectMap.put("metierSeasonInfo", metierSeasonInfo = null);
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setEnabled(false);
        remove.setText(t("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSpecies() {
        $objectMap.put("species", species = null);
    }

    protected void createTableTargetSpecies() {
        $objectMap.put("tableTargetSpecies", tableTargetSpecies = new JTable());
        
        tableTargetSpecies.setName("tableTargetSpecies");
        tableTargetSpecies.setRowHeight(24);
    }

    protected void createTargetFactor() {
        $objectMap.put("targetFactor", targetFactor = new InputOneEquationUI(this));
        
        targetFactor.setName("targetFactor");
        targetFactor.setFormuleCategory("TargetFactor");
        targetFactor.setText(t("isisfish.metierSeasonInfoSpecies.targetFactor"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(MetierSeasonInfo.class, "metier"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fieldMetierSeasonInfo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer($JLabel1), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldTargetSpecies), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(targetFactor), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel0, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPrimaryCatch), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(add), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(remove), new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(tableTargetSpecies));
        
        // apply 14 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        fieldMetierSeasonInfo.setRenderer(new fr.ifremer.isisfish.ui.input.renderer.MetierSeasonInfoComboRenderer());
        targetFactor.setClazz(fr.ifremer.isisfish.equation.TargetSpeciesTargetFactorEquation.class);
        $JScrollPane0.setMinimumSize(new Dimension(0,0));
        $JScrollPane0.setPreferredSize(new Dimension(0,0));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createMetierSeasonInfo();
        createSpecies();
        createValidator();
        createChangeModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.metierSeasonInfoSpecies.selectSeason"));
        createFieldMetierSeasonInfo();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.metierSeasonInfoSpecies.selectSpecies"));
        createFieldTargetSpecies();
        createTargetFactor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createFieldPrimaryCatch();
        createAdd();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTableTargetSpecies();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = tableTargetSpecies.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        createRemove();
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 14 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 14 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getMetierSeasonInfo());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    changeModel.setChanged(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    changeModel.setValid(validator.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_METIER_SEASON_INFO_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("active", this);
                addPropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    fieldMetierSeasonInfo.setEnabled(isActive() && (isSensitivity() || !changeModel.isChanged() ) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("active", this);
                removePropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_TARGET_SPECIES_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldTargetSpecies.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TARGET_FACTOR_ACTIVE, true ,"active" ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                targetFactor.setActive(isActive() && getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TARGET_FACTOR_BEAN, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                targetFactor.setBean(getMetierSeasonInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_PRIMARY_CATCH_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldPrimaryCatch.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_ENABLED, true ,"metierSeasonInfo" ,"species") {
        
            @Override
            public void processDataBinding() {
                add.setEnabled(getMetierSeasonInfo() != null && getSpecies() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TABLE_TARGET_SPECIES_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                tableTargetSpecies.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}