package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Wed Jan 28 10:52:10 CET 2015")
public abstract class CellDAOAbstract<E extends Cell> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Cell.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.Cell;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<Zone> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from zone main, cell_zone secondary " +
                    "where main.topiaid=secondary.zone" +
                    " and secondary.cell='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(Zone.class)).list();

            for (Zone item : list) {
                item.removeCell(entity);
            }
        }

                                        {
                                        List<Port> list = getContext()
                                                    .getDAO(Port.class)
                                                    .findAllByProperties(Port.PROPERTY_CELL, entity);
                                            for (Port item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getCell())) {
                                                    item.setCell(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Cell.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Cell.PROPERTY_NAME, v);
        return result;
    }

    public E findByLatitude(float v) throws TopiaException {
        E result = findByProperty(Cell.PROPERTY_LATITUDE, v);
        return result;
    }

    public List<E> findAllByLatitude(float v) throws TopiaException {
        List<E> result = findAllByProperty(Cell.PROPERTY_LATITUDE, v);
        return result;
    }

    public E findByLongitude(float v) throws TopiaException {
        E result = findByProperty(Cell.PROPERTY_LONGITUDE, v);
        return result;
    }

    public List<E> findAllByLongitude(float v) throws TopiaException {
        List<E> result = findAllByProperty(Cell.PROPERTY_LONGITUDE, v);
        return result;
    }

    public E findByLand(boolean v) throws TopiaException {
        E result = findByProperty(Cell.PROPERTY_LAND, v);
        return result;
    }

    public List<E> findAllByLand(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Cell.PROPERTY_LAND, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Cell.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Cell.PROPERTY_COMMENT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Zone.class) {
            ZoneDAO dao = (ZoneDAO)
                getContext().getDAO(Zone.class);
            tmp = dao.findAllContainsCell(entity);
            result.addAll(tmp);
        }

        if (type == Port.class) {
            PortDAO dao = (PortDAO)
                getContext().getDAO(Port.class);
            tmp = dao.findAllByCell(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Zone.class, entity);
        if (!list.isEmpty()) {
            result.put(Zone.class, list);
        }

        list = findUsages(Port.class, entity);
        if (!list.isEmpty()) {
            result.put(Port.class, list);
        }

        return result;
    }

} //CellDAOAbstract<E extends Cell>
