package fr.ifremer.isisfish.ui.sensitivity;

import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.simulator.AdvancedParamsUI;
import fr.ifremer.isisfish.ui.simulator.ExportUI;
import fr.ifremer.isisfish.ui.simulator.ParamsUI;
import fr.ifremer.isisfish.ui.simulator.ResultChoiceUI;
import java.awt.LayoutManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SensitivityUI extends SimulationUI {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_PARAMS_UI_REGION_STORAGE = "paramsUI.regionStorage";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVVz08TQRR+rRYoyC9RQMUElQuXLYg/EksEUiGUVCVUEmIvTrvTdsh2dpyZheVi/BP8E/TuxcSbJ+PBswcvxn/BGA9ejW+2P7YLbaB72N3Me9/3vvdm9tv3vyChJNzYJ75vSY9rVqPW1tre3tPiPi3pR1SVJBPalVC/YnGIF2DIbq0rDbcKOQNPNeCpjFsTLqe8DZ3OwaDSRw5VVUq1hutRREmpVL4VTvvCk03WlqhOrG///I6/sV+/iwP4AtWNYyuzp6HCTs7nIM5sDRex0gFJOYRXUIZkvIJ6h81axiFKPSE1+hJeQX8O+gSRSKbh5tlbDjgCvC80jMzlWc1ziGYu380uaFgoS4uVJa1RfCqmykxVLY9ZinLFNDtg+sjKh++7WSECtj4N/VXCbYdKDQ96I8ly4enNOjikGym69tEzUixSe5twqmHKjMC31CFOxNoKIyFkAOdBamo3q2G+m4R6u660thu5Bjvaohhr04glDNVSb90EqCjppbbUTNV1FZWG+H5vxC1klHyA+sKV+mxNrzdyoxQjkirP0ViAlaghSp1KtBNBHJshsQ8IL5ndaW7H4qmEa8cwUcqptpnkacnlmKcC5h7PWjs4WiI5hzuX5WUXv4Krka+2fuIaUXESsGgW5jsEbncLLHUL3OkWuNstcK8ZkHAtohpdzApdLLSZWAES0sNlDdOFk8a3g6G65U0fszxDGET/TU58//Tz40bT5+JY+3LH1DabRv8R0hVoD8yUHq2bnKeZk3pMRLoASUUd9PjAw2c6CMs3wigO640buGXg1iZRVaRI9P/4/GXyxbdzEN+AQccl9gYx+VlI6ioe8Krr2L5YWQ0UXTgcwPuY0aZhWNIK+l8ek0kFRzWybBNNZouM27jxD32cxUyHWbQEFZNf/07kP6w25xFDfVe6poczSTyHPsYdxmng/A1T7+j0Q0JRz3ZD8+5k5zHznBCNQ5IO7iudGh5q+zjwf7NcFzFLNP5tip6m2LLBZoJezNt6i/o/SDvkv6IHAAA=";
    private static final Log log = LogFactory.getLog(SensitivityUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdvancedParamsUI advancedParamsUI;
    protected ExportUI exportUI;
    protected SensitivityInputHandler handler;
    protected ParamsUI paramsUI;
    protected ResultChoiceUI resultChoiceUI;
    protected SensitivityChooserUI sensitivityChooserUI;
    protected SensitivitySecondPassUI sensitivitySecondPassUI;
    protected SensitivityTabUI sensitivityTabUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SensitivityUI $SimulationUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private TabInfo $TabInfo6;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
         * Refresh all simulation launch UI.
         */
        @Override
        protected void regionStorageChanged() {
            boolean enabled = getRegionStorage() != null;
            bodyTabbedPane.setEnabledAt(1, enabled);
            bodyTabbedPane.setEnabledAt(2, enabled);
        }
    
        @Override
        public void refresh() {
            paramsUI.refresh();
        }
    
        @Override
        public void selectParametersTab() {
            bodyTabbedPane.setSelectedIndex(0);
        }
    
        @Override
        public void setEnabledPrescriptTab(boolean selected) {
            // no prescript in AS
        }
    
        @Override
        public void setEnabledSimulationPlanTab(boolean selected) {
            // no simulation plan in AS
        }
    
        @Override
        public void setEnabledOptimizationTab(boolean selected) {
            // no optimisation.in AS
        }
    
        @Override
        public void refreshFactorTree() {
            sensitivityTabUI.setFactorModel();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SensitivityUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SensitivityUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SensitivityUI() {
        $initialize();
    }

    public SensitivityUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SensitivityUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SensitivityUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SensitivityUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SensitivityUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AdvancedParamsUI getAdvancedParamsUI() {
        return advancedParamsUI;
    }

    public ExportUI getExportUI() {
        return exportUI;
    }

    public SensitivityInputHandler getHandler() {
        return handler;
    }

    public ParamsUI getParamsUI() {
        return paramsUI;
    }

    public ResultChoiceUI getResultChoiceUI() {
        return resultChoiceUI;
    }

    public SensitivityChooserUI getSensitivityChooserUI() {
        return sensitivityChooserUI;
    }

    public SensitivitySecondPassUI getSensitivitySecondPassUI() {
        return sensitivitySecondPassUI;
    }

    public SensitivityTabUI getSensitivityTabUI() {
        return sensitivityTabUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBodyTabbedPane() {
        if (!allComponentsCreated) {
            return;
        }
        bodyTabbedPane.add(paramsUI);
        bodyTabbedPane.add(sensitivityTabUI);
        bodyTabbedPane.add(sensitivityChooserUI);
        bodyTabbedPane.add(exportUI);
        bodyTabbedPane.add(resultChoiceUI);
        bodyTabbedPane.add(advancedParamsUI);
        bodyTabbedPane.add(sensitivitySecondPassUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 0));
        bodyTabbedPane.setTitleAt(0, t("isisfish.params.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 1));
        bodyTabbedPane.setTitleAt(1, t("isisfish.sensitivity.title"));
        bodyTabbedPane.setEnabledAt(1, false);
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 2));
        bodyTabbedPane.setTitleAt(2, t("isisfish.sensitivityChooser.title"));
        bodyTabbedPane.setEnabledAt(2, false);
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 3));
        bodyTabbedPane.setTitleAt(3, t("isisfish.export.title"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 4));
        bodyTabbedPane.setTitleAt(4, t("isisfish.resultChoice.title"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 5));
        bodyTabbedPane.setTitleAt(5, t("isisfish.advancedParameters.title"));
        $TabInfo6.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 6));
        bodyTabbedPane.setTitleAt(6, t("isisfish.sensitivity.secondpass.title"));
    }

    protected void createAdvancedParamsUI() {
        $objectMap.put("advancedParamsUI", advancedParamsUI = new AdvancedParamsUI(this));
        
        advancedParamsUI.setName("advancedParamsUI");
    }

    @Override
    protected void createBodyTabbedPane() {
        super.createBodyTabbedPane();
        bodyTabbedPane.setName("bodyTabbedPane");
    }

    protected void createExportUI() {
        $objectMap.put("exportUI", exportUI = new ExportUI(this));
        
        exportUI.setName("exportUI");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SensitivityInputHandler());
    }

    protected void createParamsUI() {
        $objectMap.put("paramsUI", paramsUI = new ParamsUI(new JAXXInitialContext().add(new InputAction()).add(new SensitivitySaveVerifier()).add("SimulationUI", this).add(this)));
        
        paramsUI.setName("paramsUI");
        paramsUI.setSensitivity(true);
    }

    protected void createResultChoiceUI() {
        $objectMap.put("resultChoiceUI", resultChoiceUI = new ResultChoiceUI(this));
        
        resultChoiceUI.setName("resultChoiceUI");
    }

    protected void createSensitivityChooserUI() {
        $objectMap.put("sensitivityChooserUI", sensitivityChooserUI = new SensitivityChooserUI(this));
        
        sensitivityChooserUI.setName("sensitivityChooserUI");
    }

    protected void createSensitivitySecondPassUI() {
        $objectMap.put("sensitivitySecondPassUI", sensitivitySecondPassUI = new SensitivitySecondPassUI(this));
        
        sensitivitySecondPassUI.setName("sensitivitySecondPassUI");
    }

    protected void createSensitivityTabUI() {
        $objectMap.put("sensitivityTabUI", sensitivityTabUI = new SensitivityTabUI(new JAXXInitialContext().add(new InputAction()).add(new SensitivitySaveVerifier()).add("SimulationUI", this).add(this)));
        
        sensitivityTabUI.setName("sensitivityTabUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBodyTabbedPane();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$SimulationUI0", $SimulationUI0);
        createHandler();
        createParamsUI();
        createSensitivityTabUI();
        createSensitivityChooserUI();
        createExportUI();
        createResultChoiceUI();
        createAdvancedParamsUI();
        createSensitivitySecondPassUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.params.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setEnabled(false);
        $TabInfo1.setTitle(t("isisfish.sensitivity.title"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setEnabled(false);
        $TabInfo2.setTitle(t("isisfish.sensitivityChooser.title"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(t("isisfish.export.title"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(t("isisfish.resultChoice.title"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(t("isisfish.advancedParameters.title"));
        // inline creation of $TabInfo6
        $objectMap.put("$TabInfo6", $TabInfo6 = new TabInfo());
        
        $TabInfo6.setTitle(t("isisfish.sensitivity.secondpass.title"));
        // inline creation of $SimulationUI0
        setName("$SimulationUI0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PARAMS_UI_REGION_STORAGE, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                paramsUI.setRegionStorage(getRegionStorage());
            }
        });
    }

}