/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationPlanComboRenderer.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.simulationplan;

import static org.nuiton.i18n.I18n.t;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.ui.util.TooltipHelper;

/**
 * Renderer pour la combo des plans de simulation.
 *
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (jeu., 17 avril 2014) $
 * By : $Author: echatellier $
 */
public class SimulationPlanComboRenderer extends DefaultListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** Simulation plan cache. */
    protected Map<String, SimulationPlan> simulationPlanCache;

    /**
     * Empty constructor.
     */
    public SimulationPlanComboRenderer() {
        simulationPlanCache = new HashMap<String, SimulationPlan>();
    }

    /*
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        // this must be used to have alterned highlight rows and default
        // selection color
        JLabel c = (JLabel) super.getListCellRendererComponent(list, value,
                index, isSelected, cellHasFocus);

        String simulationPlanName = (String) value;
        c.setText(simulationPlanName);

        // c'est tres couteux d'avoir une instance
        // on les met en cache
        try {
            SimulationPlan plan = simulationPlanCache.get(simulationPlanName);
            if (plan == null) {
                SimulationPlanStorage storage = SimulationPlanStorage
                        .getSimulationPlan(simulationPlanName);
                plan = storage.getNewInstance();
                simulationPlanCache.put(simulationPlanName, plan);
            }

            c.setToolTipText(plan.getDescription());
        } catch (Exception e) {
            String errorTooltip = TooltipHelper.getErrorTooltip(t("isisfish.error.compile.fileerror", simulationPlanName));
            c.setToolTipText(errorTooltip);
        }

        return c;
    }
}
