/*
 * #%L
 * IsisFish
 * 
 * $Id: ScriptParametersTableCellRenderer.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/models/common/ScriptParametersTableCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.common;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import fr.ifremer.isisfish.util.Doc;

/**
 * Specific editor for rule parameters.
 *
 * @author chatellier
 * @version $Revision: 3798 $
 * 
 * Last update : $Date: 2012-10-30 11:39:32 +0100 (mar. 30 oct. 2012) $
 * By : $Author: echatellier $
 */
public class ScriptParametersTableCellRenderer extends DefaultTableCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1655744662816030649L;

    protected Object script;

    public ScriptParametersTableCellRenderer(Object script) {
        this.script = script;
    }

    /*
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {

        JLabel c = (JLabel) super.getTableCellRendererComponent(table, value,
                isSelected, hasFocus, row, column);

        String parameterName = (String) value;
        c.setText(parameterName);

        Doc doc = JavaSourceStorage.getParameterDoc(script, parameterName);
        String documentation = TooltipHelper.docToString(doc);
        c.setToolTipText(documentation);

        return c;
    }

}
