/*
 * #%L
 * IsisFish
 * 
 * $Id: Objective.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/simulator/Objective.java $
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.simulator;

import java.util.List;

import org.nuiton.math.matrix.MatrixND;

/**
 * Interface des fonctions d'objectifs.
 * 
 * @author Eric Chatellier
 * @since 4.3.0.0
 */
public interface Objective {

    /**
     * Return plan necessary Results.
     *
     * @return the necessaryResult name
     */
    public String[] getNecessaryResult();

    /**
     * Return plan description.
     *
     * @return plan description
     * @throws Exception
     */
    public String getDescription() throws Exception;

    /**
     * Effectue une evaluation entre les exports et les observations.
     * 
     * @param context optimisation context
     * @param exports exports
     * @param observations observations
     * @return double value
     */
    double eval(OptimizationContext context, List<MatrixND> exports, List<MatrixND> observations);
}
