package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Mon Jun 16 12:41:24 CEST 2014")
public abstract class SpeciesAbstract extends TopiaEntityAbstract implements Species {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : scientificName
     */
    protected String scientificName;

    /**
     * Nom de l'attribut en BD : codeRubbin
     */
    protected String codeRubbin;

    /**
     * Nom de l'attribut en BD : codeCEE
     */
    protected int codeCEE;

    /**
     * Nom de l'attribut en BD : ageGroupType
     */
    protected boolean ageGroupType;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : metierSeasonInfo
     */
    protected Collection<TargetSpecies> metierSeasonInfoTargetSpecies;

    /**
     * Nom de l'attribut en BD : population
     */
    protected Collection<Population> population;

    private static final long serialVersionUID = 4064048070971962679L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Species.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Species.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_SCIENTIFIC_NAME, String.class, scientificName);
        visitor.visit(this, PROPERTY_CODE_RUBBIN, String.class, codeRubbin);
        visitor.visit(this, PROPERTY_CODE_CEE, int.class, codeCEE);
        visitor.visit(this, PROPERTY_AGE_GROUP_TYPE, boolean.class, ageGroupType);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_METIER_SEASON_INFO_TARGET_SPECIES, Collection.class, TargetSpecies.class, metierSeasonInfoTargetSpecies);
        visitor.visit(this, PROPERTY_POPULATION, Collection.class, Population.class, population);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        String result = this.name;

        return result;
    }

    @Override
    public void setScientificName(String scientificName) {
        String oldValue = this.scientificName;
        fireOnPreWrite(PROPERTY_SCIENTIFIC_NAME, oldValue, scientificName);
        this.scientificName = scientificName;
        fireOnPostWrite(PROPERTY_SCIENTIFIC_NAME, oldValue, scientificName);
    }

    @Override
    public String getScientificName() {
        String result = this.scientificName;

        return result;
    }

    @Override
    public void setCodeRubbin(String codeRubbin) {
        String oldValue = this.codeRubbin;
        fireOnPreWrite(PROPERTY_CODE_RUBBIN, oldValue, codeRubbin);
        this.codeRubbin = codeRubbin;
        fireOnPostWrite(PROPERTY_CODE_RUBBIN, oldValue, codeRubbin);
    }

    @Override
    public String getCodeRubbin() {
        String result = this.codeRubbin;

        return result;
    }

    @Override
    public void setCodeCEE(int codeCEE) {
        int oldValue = this.codeCEE;
        fireOnPreWrite(PROPERTY_CODE_CEE, oldValue, codeCEE);
        this.codeCEE = codeCEE;
        fireOnPostWrite(PROPERTY_CODE_CEE, oldValue, codeCEE);
    }

    @Override
    public int getCodeCEE() {
        int result = this.codeCEE;

        return result;
    }

    @Override
    public void setAgeGroupType(boolean ageGroupType) {
        boolean oldValue = this.ageGroupType;
        fireOnPreWrite(PROPERTY_AGE_GROUP_TYPE, oldValue, ageGroupType);
        this.ageGroupType = ageGroupType;
        fireOnPostWrite(PROPERTY_AGE_GROUP_TYPE, oldValue, ageGroupType);
    }

    @Override
    public boolean isAgeGroupType() {
        boolean result = this.ageGroupType;

        return result;
    }

    @Override
    public boolean getAgeGroupType() {
        boolean result = this.ageGroupType;

        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        String result = this.comment;

        return result;
    }

    @Override
    public void addPopulation(Population population) {
        fireOnPreWrite(PROPERTY_POPULATION, null, population);
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }

        population.setSpecies(this);

        this.population.add(population);
        fireOnPostWrite(PROPERTY_POPULATION, this.population.size(), null, population);
    }

    @Override
    public void addAllPopulation(Collection<Population> population) {
        if (population == null) {
            return;
        }
        for (Population item : population) {
            addPopulation(item);
        }
    }

    @Override
    public void setPopulation(Collection<Population> population) {
        // Copy elements to keep data for fire with new reference
        Collection<Population> oldValue = this.population != null ? new ArrayList<Population>(this.population) : null;
        fireOnPreWrite(PROPERTY_POPULATION, oldValue, population);
        this.population = population;
        fireOnPostWrite(PROPERTY_POPULATION, oldValue, population);
    }

    @Override
    public void removePopulation(Population population) {
        fireOnPreWrite(PROPERTY_POPULATION, population, null);
        if (this.population == null || !this.population.remove(population)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        population.setSpecies(null);

        fireOnPostWrite(PROPERTY_POPULATION, this.population.size() + 1, population, null);
    }

    @Override
    public void clearPopulation() {
        if (this.population == null) {
            return;
        }
        for (Population item : this.population) {
            item.setSpecies(null);
        }
        Collection<Population> oldValue = new ArrayList<Population>(this.population);
        fireOnPreWrite(PROPERTY_POPULATION, oldValue, this.population);
        this.population.clear();
        fireOnPostWrite(PROPERTY_POPULATION, oldValue, this.population);
    }

    @Override
    public Collection<Population> getPopulation() {
        return population;
    }

    @Override
    public Population getPopulationByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(population, topiaId);
    }

    @Override
    public int sizePopulation() {
        if (population == null) {
            return 0;
        }
        return population.size();
    }

    @Override
    public boolean isPopulationEmpty() {
        int size = sizePopulation();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<TargetSpecies> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(TargetSpecies.class);
            List<TargetSpecies> findAllByProperties = dao.findAllByProperties("species", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getPopulation() != null) {
              tmp.addAll(getPopulation());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_SCIENTIFIC_NAME, this.scientificName).
            append(PROPERTY_CODE_RUBBIN, this.codeRubbin).
            append(PROPERTY_CODE_CEE, this.codeCEE).
            append(PROPERTY_AGE_GROUP_TYPE, this.ageGroupType).
            append(PROPERTY_COMMENT, this.comment).
         toString();
        return result;
    }

} //SpeciesAbstract
