package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Mon Jun 16 12:41:24 CEST 2014")
public abstract class MetierDAOAbstract<E extends Metier> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Metier.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.Metier;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<MetierSeasonInfo> list = getContext()
                                                    .getDAO(MetierSeasonInfo.class)
                                                    .findAllByProperties(MetierSeasonInfo.PROPERTY_METIER, entity);
                                            for (MetierSeasonInfo item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getMetier())) {
                                                    item.setMetier(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Metier.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Metier.PROPERTY_NAME, v);
        return result;
    }

    public E findByGearParameterValue(String v) throws TopiaException {
        E result = findByProperty(Metier.PROPERTY_GEAR_PARAMETER_VALUE, v);
        return result;
    }

    public List<E> findAllByGearParameterValue(String v) throws TopiaException {
        List<E> result = findAllByProperty(Metier.PROPERTY_GEAR_PARAMETER_VALUE, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Metier.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Metier.PROPERTY_COMMENT, v);
        return result;
    }

    public E findByCapturableSpeciesComment(String v) throws TopiaException {
        E result = findByProperty(Metier.PROPERTY_CAPTURABLE_SPECIES_COMMENT, v);
        return result;
    }

    public List<E> findAllByCapturableSpeciesComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Metier.PROPERTY_CAPTURABLE_SPECIES_COMMENT, v);
        return result;
    }

    public E findByGear(Gear v) throws TopiaException {
        E result = findByProperty(Metier.PROPERTY_GEAR, v);
        return result;
    }

    public List<E> findAllByGear(Gear v) throws TopiaException {
        List<E> result = findAllByProperty(Metier.PROPERTY_GEAR, v);
        return result;
    }

    public E findContainsMetierSeasonInfo(MetierSeasonInfo v) throws TopiaException {
        E result = findContains(Metier.PROPERTY_METIER_SEASON_INFO, v);
        return result;
    }

    public List<E> findAllContainsMetierSeasonInfo(MetierSeasonInfo v) throws TopiaException {
        List<E> result = findAllContains(Metier.PROPERTY_METIER_SEASON_INFO, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == MetierSeasonInfo.class) {
            MetierSeasonInfoDAO dao = (MetierSeasonInfoDAO)
                getContext().getDAO(MetierSeasonInfo.class);
            tmp = dao.findAllByMetier(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(MetierSeasonInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(MetierSeasonInfo.class, list);
        }

        return result;
    }

} //MetierDAOAbstract<E extends Metier>
