package fr.ifremer.isisfish.ui.widget.filter;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class FilterDialogUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBO_RESULT_ENABLED = "comboResult.enabled";
    public static final String BINDING_OK_ENABLED = "ok.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeFtpSWgQhIESMgNUYD1uiJhohiICNbSoaKgmxF6e703ZwurPuzMpyMf4J/gl692LizZPx4NmDF+O/YIwHr8Y3019sXUuNPey2877ve997nfdef0Mx4aLFfez7huvZkjaIUbi1t3evsk9MuUWE6VJHchc1P5EoipZRyuqcC4nOlYuKnm3Rs5u84XCb2EfYK0U0KuQhI6JOiJToTJBhCpEtdcIrvuO5bdWOqTDVlz++R19Yz19FEfIdcJeGUhaOY3UrGS6iKLUkmoRMT3GWYbsGNlxq18DvmDrbZFiIbdwgT9AzlCiiuINdEJNoafCStYbm+45EyUxhi2LGa8sSXam6Bq26pEHgLaioUlE3PGocUKtGpFGlTEIkp19N0m7ecbRWXKJE5gGuMAI6s4GSxQEUYOiYQiY7hLFMoWS6nLH72Fa0U6pCv4U/ElLwdIc1ZHGzF3vbolBhGzvetWRyW+r+XP6H0pQO280H06bBLIFuY0gEXmeCXtuRICfFcIWwHSI8BhYmA5SiCvXATd6o8DZ8OgDfVKEN7gcZI5mCNrvcq65Pg9gofyzRVAC14UnJbRVf7MBiLhFEqh8XgoG4iW2zKdqOuOh04J+GsTG6Y9O915EyyHpwDFej/Oek7UCoOWOzPTOmBHX018zU53df3+bag5WC3NOh0CN7AS6843KHuJKq1OPNqfIkZdm72Fkpo6QgDJaKXhrzIcZKrTCYg3wnFd1QdOMOFnWQiCW+vP8w8+jTEIrm0Cjj2Mphhc+jpKxDH+ucWb5zc107Sh+MwHNCeYNm1gmt1dWlWKU2ozZZwBIGveJJsuZDI+ZDGtFxU0l+/DlVerPebkYEzM39Fd5tSOwhijez6T3TWiGheyXlCOJZvLsqwpZHRL0nnNYGWNbPq2HVprhLYQqxpM3bds331Ou69q6+3dBScwNIjeiRynFXohOrFpZ4oUJtC27zWrjm/ACaw5L4so+vQTQSxFYLTjd1K1zm7AAycYYPuSf7qCwdq6KOt/sonB9IId+nIYMp9PNw8b89/L/CJVD4DZbbsEhvCAAA";
    private static final Log log = LogFactory.getLog(FilterDialogUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancel;
    protected JComboBox comboResult;
    protected FilterPanelUI content;
    protected JEditorPane doc;
    protected JLabel labelResult;
    protected JButton ok;
    protected JButton reset;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FilterDialogUI $JDialog0 = this;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /** filter model */
        protected FilterModel model;
    /** use to display filtered result in a comboBox */
        protected DefaultComboBoxModel modelResult;
    
          
        public FilterParamModel getParamModel(String paramKey) {
            return model.getParamModel(paramKey);
        }
    
        public java.util.List getOriginal() {
            return model.getOriginal();
        }
        /** @return list of last filter list obtain */
        protected List getFilterResult() {
            // obtain list filtered
            return model.getFiltered();
        }
        public List obtainFilterResult() {
            // compact dialog
            setSize(getMinimumSize());
            repaint();
            doReset();
            // TODO pas de composant parent ?
            org.nuiton.widget.SwingUtil.center(this);
            // launch ui and waits for reply
            setVisible(true);
            return model.getFilteredResult();
        }
        public String obtainSelectResult() {
            // compact dialog
            setSize(getMinimumSize());
            repaint();
            doReset();
            // TODO pas de composant parent ?
            org.nuiton.widget.SwingUtil.center(this);
            // launch ui and waits for reply
            setVisible(true);
            return (String) comboResult.getSelectedItem();
        }
        /**
         * user ui action : reset previous filter results (if any) and restore
         * original dialogModel
         *
         * @see FilterModel#reset()
         */
        public void doReset() {
            content.doReset();
            model.reset();
            model.selectAll();
            refreshResult();
        }
        /**
         * user ui action : check nb matchs found with current params (launch a
         * filter process)
         */
        public void doCheck() {
            // launch new filter process (previous result is lost)
            doFilter();
            // refresh ui nbMatchsFound
            refreshResult();
        }
        /**
         * launch filter process with params grabbed in ui
         *
         * @see FilterModel#doFilter()
         */
        public void doFilter() {
            // rest model before all
            model.reset();
            // synchronize ui values to model
            content.uiToModel();
            // delegate to FilterModel the filter process
            model.doFilter();
        }
        public void doCancel() {        
            // reset ui
            content.doReset();
            // reset model
            model.reset();
            //refreshResult();
            dispose();
        }
        protected boolean canReset() {
            return !(model == null || model.getNbResult() == model.getNbOriginal());
        }
        protected HyperlinkListener createHyperLinkListener() {
            return new HyperlinkListener() {
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (e instanceof HTMLFrameHyperlinkEvent) {
                            ((HTMLDocument)doc.getDocument()).processHTMLFrameHyperlinkEvent(
                                (HTMLFrameHyperlinkEvent)e);
                        } else {
                            try {
                                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                                    Desktop.getDesktop().browse(e.getURL().toURI());
                                } else {
                                    doc.setPage(e.getURL());
                                }
                            } catch (Exception eee) {
                                if (log.isErrorEnabled()) {
                                    log.error("Can't open system browser", eee);
                                }
                            }
                        }
                    }
                }
            };
        }
        protected void refreshResult() {
            if (model == null) return;
            labelResult.setText(t("isisfish.filter.result.found", model.getNbResult(), model.getNbOriginal()));
    
            if (getComboResult() != null) {
                if (modelResult == null) {
                    modelResult = new DefaultComboBoxModel();
                    getComboResult().setModel(modelResult);
                } else {
                    modelResult.removeAllElements();
                    for (Object o : model.getFilteredResult()) {
                        modelResult.addElement(o);
                    }
                }
            }
            processDataBinding("comboResult.enabled");
            processDataBinding("ok.enabled");
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FilterDialogUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI() {
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FilterDialogUI(Window param0) {
        super(param0);
        $initialize();
    }

    public FilterDialogUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__reset(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doReset();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancel() {
        return cancel;
    }

    public JComboBox getComboResult() {
        return comboResult;
    }

    public FilterPanelUI getContent() {
        return content;
    }

    public JEditorPane getDoc() {
        return doc;
    }

    public JLabel getLabelResult() {
        return labelResult;
    }

    public JButton getOk() {
        return ok;
    }

    public JButton getReset() {
        return reset;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.filter.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createComboResult() {
        $objectMap.put("comboResult", comboResult = new JComboBox());
        
        comboResult.setName("comboResult");
    }

    protected void createContent() {
        $objectMap.put("content", content = new FilterPanelUI());
        
        content.setName("content");
    }

    protected void createDoc() {
        $objectMap.put("doc", doc = new JEditorPane());
        
        doc.setName("doc");
    }

    protected void createLabelResult() {
        $objectMap.put("labelResult", labelResult = new JLabel());
        
        labelResult.setName("labelResult");
        labelResult.setText(t("isisfish.filter.result"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("isisfish.filter.apply"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setText(t("isisfish.filter.reset"));
        reset.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__reset"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 0, 4, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(content, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelResult, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(comboResult, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(doc);
        // inline complete setup of $JPanel0
        $JPanel0.add(ok);
        $JPanel0.add(reset);
        $JPanel0.add(cancel);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        labelResult.setLabelFor(comboResult);
        reset.setEnabled(canReset());
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        SwingUtil.setComponentHeight($JScrollPane0,200);
        createDoc();
        createContent();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        $JSeparator0.setOrientation(0);
        createLabelResult();
        createComboResult();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0, 3, 2, 2));
        createOk();
        createReset();
        createCancel();
        // inline creation of $JDialog0
        setName("$JDialog0");
        
        setModalityType(Dialog.ModalityType.APPLICATION_MODAL);doc.setEditable(false);doc.setEditorKit(new HTMLEditorKit());doc.addHyperlinkListener(createHyperLinkListener());// registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMBO_RESULT_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (comboResult != null) {
                    comboResult.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (comboResult != null && comboResult.getModel() != null) {
                    comboResult.setEnabled(comboResult.getModel().getSize()!=0);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (comboResult != null) {
                    comboResult.removePropertyChangeListener("model", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (comboResult != null) {
                    comboResult.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (comboResult != null && comboResult.getModel() != null) {
                    ok.setEnabled(comboResult.getModel().getSize()!=0);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (comboResult != null) {
                    comboResult.removePropertyChangeListener("model", this);
                }
            }
        });
    }

}