package fr.ifremer.isisfish.ui.vcs;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class VCSGenerateSshKeyUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHp5VSyg8FChURIgLReHCrMdEYCAIlRbAqWiTEXpzuTtvB6e46MwuLB+Of4J+gdy8m3jwZD549eDH+C8Z48Gp8s922LCylSXvYbee993nf9zrvvf+FYoKjizvYdTXumJJWiba+tL39sLhDdLlChM6pLS2Oap9IFEULqM9onAuJZgo5FZ72w9MZq2pbJjEPRM/lUK+Q+4yICiFSoslghC5EOt8wz7m2w+vUhqgw6ts/v6NvjNfvogi5NqgbgFKmTopqVtKVQ1FqSDQMmXZxmmGzDDI4Ncugd0CdZRgW4gGukhfoFYrnULeNOcAkmm6/ZI/hxbu2RInZ9RWKmVW+JpFW4hotcVIl8BZUlKioaA7VdnWhbWXyq8QkHEuSF5V7ZP/Jmm17mG6J4rObuMgIIMYC1Yo90K55NuWZaAT0zK7ncJEwiBhWdbm+a+1UOfU3fEcE4buEb3C6C8khc5YyIlEqELdJXJmlhBnB2Hqe6+r3UNCW9LlOkVHdxyrTSNBt1HeDpm1UOBakIfEQb/Cwo0TjAY3KsmdxI0TnRC02Y5klyqsn5zp7jL8yTx5pwQY2Q1rtnQZ9o9Zz6EvAa9mR0jKVfbrh1q9jUydsSZe0Zrrs2zk6H/j/YY605hw1L3qkgGLcgWO4MIWjo/cYTLWhGzs0dAroWf+lkt8//fyYrU/aMOQeDXU9sChgAmxu2YRLqlKfqY2ZIylL38f2XAElBGGwZbwtMhEiLO+bQRzkG1LhmgrX7mJRAUQs/uPzl9Szb6dQNIt6mYWNLFb+ayghKxy6YDHDte8seor693rgOai0SRSrWgZm8BfNU5NRk0xhCYNfdCRZcKEPEyF9aIgpJr7+TeY/LNZ7EQFt5451b/Yj9hR117J5e8dfKaF7ps8WxDGs5uoIWyYR9e61/bWQ9p43QouVVNZm7abrqNctT7X6drttSJeEkW/BGGyDEdct5lRN0QKTbAPTQwwq60uuA06iZJnyqqAvOwV1VwgtV1p152SKOl5uQUi1RVhtQRhri5DrmPCoY8JWx4RWnRzvmHChnTvB8L4FyxydnjewxFNFahqw4RfCiTPtTA8x1aU3Wgi71HFpnROuAOE/oZJ6bVcKAAA=";
    private static final Log log = LogFactory.getLog(VCSGenerateSshKeyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelAction;
    protected JButton ok;
    protected JPasswordField serverConfirmPassPhrase;
    protected JLabel serverConfirmPassPhraseLabel;
    protected JPasswordField serverPassPhrase;
    protected JLabel serverPassPhraseLabel;
    protected JTextField serverPrivateKeyFile;
    protected JTextField serverPublicKeyFile;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private VCSGenerateSshKeyUI $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private static VCSGenerateSshKeyUI instance;
    
    
        public static VCSGenerateSshKeyUI getInstance(JDialog parent) {
            if (instance == null) {
                instance = new VCSGenerateSshKeyUI(parent);
            }
            return instance;
        }public boolean cancel;
    public boolean noPassPhrase;
    public Exception error;
    protected boolean invalidPassPhrase;
    protected String vcsLogin;
    
    
        public void setData(String vcsLogin, File privateKeyFile) {
            this.vcsLogin = vcsLogin ;
            serverPrivateKeyFile.setText(privateKeyFile.getAbsolutePath());
            serverPublicKeyFile.setText(privateKeyFile.getAbsolutePath() + ".pub");
            noPassPhrase=true;
            error=null;
            doCheck();
        }
    
        /**
         * Generate ssh key.
         *
         * Return true if error occurs.
         */
        protected boolean doGenerate() {
            File privateKeyFile = new File(getServerPrivateKeyFile().getText());
            File publicKeyFile = new File(serverPublicKeyFile.getText());
            
            // bug #1623, le dossier parent n'existe pas
            if (privateKeyFile.getParentFile() != null && !privateKeyFile.getParentFile().exists()) {
                privateKeyFile.getParentFile().mkdirs();
            }
            
            try {
                char[] password = getServerPassPhrase().getPassword();
                
                JSch jsch=new JSch();
                KeyPair kpair=KeyPair.genKeyPair(jsch, KeyPair.RSA, 2048);
                if (password.length > 0) {
                    kpair.setPassphrase(Arrays.toString(password));
                }
                kpair.writePrivateKey(privateKeyFile.getAbsolutePath());
                kpair.writePublicKey(publicKeyFile.getAbsolutePath(), vcsLogin + "@forIsisFish");
                if (log.isInfoEnabled()) {
                    log.info("Finger print: "+kpair.getFingerPrint());
                }
                kpair.dispose();
            } catch (Exception e) {
                error=e;       
                return true;
            }
            return false;
        }
        protected boolean check() {
            invalidPassPhrase=!Arrays.equals(serverPassPhrase.getPassword(),serverConfirmPassPhrase.getPassword());
            return !invalidPassPhrase;
        }
    
        protected void doCheck() {
            ok.setEnabled(check());
            setColor(invalidPassPhrase, serverPassPhraseLabel);
            setColor(invalidPassPhrase, serverConfirmPassPhraseLabel);
        }
    
        protected void setColor(boolean invalid, JComponent component) {
            component.setForeground(invalid ? Color.red: Color.black);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    private VCSGenerateSshKeyUI(JDialog instance) {
        super(instance);
                // block close operation
                setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
            $initialize();
    }

    public VCSGenerateSshKeyUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI() {
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VCSGenerateSshKeyUI(Window param0) {
        super(param0);
        $initialize();
    }

    public VCSGenerateSshKeyUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelAction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        cancel = true;dispose();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        cancel = doGenerate();dispose();
    }

    public void doKeyReleased__on__serverConfirmPassPhrase(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    public void doKeyReleased__on__serverPassPhrase(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        doCheck();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelAction() {
        return cancelAction;
    }

    public JButton getOk() {
        return ok;
    }

    public JPasswordField getServerConfirmPassPhrase() {
        return serverConfirmPassPhrase;
    }

    public JLabel getServerConfirmPassPhraseLabel() {
        return serverConfirmPassPhraseLabel;
    }

    public JPasswordField getServerPassPhrase() {
        return serverPassPhrase;
    }

    public JLabel getServerPassPhraseLabel() {
        return serverPassPhraseLabel;
    }

    public JTextField getServerPrivateKeyFile() {
        return serverPrivateKeyFile;
    }

    public JTextField getServerPublicKeyFile() {
        return serverPublicKeyFile;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createCancelAction() {
        $objectMap.put("cancelAction", cancelAction = new JButton());
        
        cancelAction.setName("cancelAction");
        cancelAction.setText(t("isisfish.common.cancel"));
        cancelAction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelAction"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setEnabled(false);
        ok.setText(t("isisfish.common.apply"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createServerConfirmPassPhrase() {
        $objectMap.put("serverConfirmPassPhrase", serverConfirmPassPhrase = new JPasswordField());
        
        serverConfirmPassPhrase.setName("serverConfirmPassPhrase");
        serverConfirmPassPhrase.setColumns(15);
        serverConfirmPassPhrase.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__serverConfirmPassPhrase"));
    }

    protected void createServerConfirmPassPhraseLabel() {
        $objectMap.put("serverConfirmPassPhraseLabel", serverConfirmPassPhraseLabel = new JLabel());
        
        serverConfirmPassPhraseLabel.setName("serverConfirmPassPhraseLabel");
        serverConfirmPassPhraseLabel.setText(t("isisfish.launch.server.ssh.confirm.passphrase"));
    }

    protected void createServerPassPhrase() {
        $objectMap.put("serverPassPhrase", serverPassPhrase = new JPasswordField());
        
        serverPassPhrase.setName("serverPassPhrase");
        serverPassPhrase.setColumns(15);
        serverPassPhrase.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__serverPassPhrase"));
    }

    protected void createServerPassPhraseLabel() {
        $objectMap.put("serverPassPhraseLabel", serverPassPhraseLabel = new JLabel());
        
        serverPassPhraseLabel.setName("serverPassPhraseLabel");
        serverPassPhraseLabel.setText(t("isisfish.launch.server.ssh.passphrase"));
    }

    protected void createServerPrivateKeyFile() {
        $objectMap.put("serverPrivateKeyFile", serverPrivateKeyFile = new JTextField());
        
        serverPrivateKeyFile.setName("serverPrivateKeyFile");
        serverPrivateKeyFile.setColumns(15);
        serverPrivateKeyFile.setColumns(28);
        serverPrivateKeyFile.setEditable(false);
        if (serverPrivateKeyFile.getFont() != null) {
            serverPrivateKeyFile.setFont(serverPrivateKeyFile.getFont().deriveFont((float) 12));
        }
        SwingUtil.setComponentHeight(serverPrivateKeyFile,25);
    }

    protected void createServerPublicKeyFile() {
        $objectMap.put("serverPublicKeyFile", serverPublicKeyFile = new JTextField());
        
        serverPublicKeyFile.setName("serverPublicKeyFile");
        serverPublicKeyFile.setColumns(15);
        serverPublicKeyFile.setColumns(28);
        serverPublicKeyFile.setEditable(false);
        if (serverPublicKeyFile.getFont() != null) {
            serverPublicKeyFile.setFont(serverPublicKeyFile.getFont().deriveFont((float) 12));
        }
        SwingUtil.setComponentHeight(serverPublicKeyFile,25);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverPrivateKeyFile, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverPublicKeyFile, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverPassPhraseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverPassPhrase, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverConfirmPassPhraseLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(serverConfirmPassPhrase, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(ok);
        $JPanel0.add(cancelAction);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.launch.server.ssh.privateKeyFile"));
        createServerPrivateKeyFile();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.launch.server.ssh.publicKeyFile"));
        createServerPublicKeyFile();
        createServerPassPhraseLabel();
        createServerPassPhrase();
        createServerConfirmPassPhraseLabel();
        createServerConfirmPassPhrase();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0, 2, 2, 2));
        createOk();
        createCancelAction();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        setTitle(t("isisfish.server.ssh.generateKey.title"));
        
        $completeSetup();
    }

}