/*
 * #%L
 * $Id: YearSumDimensionAction.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.0.1/src/main/java/fr/ifremer/isisfish/ui/result/YearSumDimensionAction.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.result;

import javax.swing.Icon;

import org.nuiton.math.matrix.viewer.MatrixDimensionAction;
import org.nuiton.util.Resource;

import fr.ifremer.isisfish.types.TimeStep;

/**
 * Action de somme des elements par 12 (année) pour la dimension des pas de temps.
 * 
 * @author chatellier
 * @version $Revision: 3798 $
 * 
 * Last update : $Date: 2012-10-30 11:39:32 +0100 (Tue, 30 Oct 2012) $
 * By : $Author: echatellier $
 */
public class YearSumDimensionAction implements MatrixDimensionAction {

    @Override
    public Icon getIcon() {
        return Resource.getIcon("/images/sigma_an-barre.gif");
    }

    @Override
    public Icon getSelectedIcon() {
        return Resource.getIcon("/images/sigma_an.gif");
    }

    @Override
    public int getDimensionIndex() {
        return 0;
    }

    @Override
    public Class<?> getDimensionType() {
        return TimeStep.class;
    }

    @Override
    public int getSumStep() {
        return 12;
    }

}
