/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationPlan.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.0.1/src/main/java/fr/ifremer/isisfish/simulator/SimulationPlan.java $
 * %%
 * Copyright (C) 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;

/**
 * Simulation plan.
 * 
 * Replace old {@code AnalysePlan}.
 *
 * @author poussin
 * @version $Revision: 3798 $
 *
 * Last update: $Date: 2012-10-30 11:39:32 +0100 (Tue, 30 Oct 2012) $
 * by : $Author: echatellier $
 */
public interface SimulationPlan {

    /**
     * Return plan necessary Results.
     * 
     * @return the necessaryResult name
     */
    public String[] getNecessaryResult();

    /**
     * Return plan description.
     * 
     * @return plan description
     * @throws Exception
     */
    public String getDescription() throws Exception;

    /**
     * Use only once before first simulation.
     * 
     * You can modified Param for all simulation or put value in context.values.
     * 
     * @param context plan context
     * @throws Exception
     */
    public void init(SimulationPlanContext context) throws Exception;

    /**
     * Call before each simulation.
     * 
     * @param context plan context
     * @param nextSimulation storage used for next simulation
     * @return true if we must do next simulation, false to stop plan
     * @throws Exception
     */
    public boolean beforeSimulation(SimulationPlanContext context,
            SimulationStorage nextSimulation) throws Exception;

    /**
     * Call after each simulation.
     * 
     * @param context plan context
     * @param lastSimulation storage used for simulation
     * @return true if we must do next simulation, false to stop plan
     * @throws Exception
     */
    public boolean afterSimulation(SimulationPlanContext context,
            SimulationStorage lastSimulation) throws Exception;

}
