/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationExportResultWrapper.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator;

import static org.nuiton.i18n.I18n.t;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.apache.commons.collections4.ListUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.ExportHelper;
import fr.ifremer.isisfish.export.SensitivityExport;

/**
 * Export simulation listener.
 * 
 * Do export after simulation ends.
 *
 * Created: 14 nov. 07 00:22:51
 *
 * @author poussin
 * @version $Revision: 3969 $
 *
 * Last update: $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * by : $Author: echatellier $
 */
public class SimulationExportResultWrapper implements SimulationListener {

    /** Class logger. */
    private static Log log = LogFactory
            .getLog(SimulationExportResultWrapper.class);

    /*
     * @see fr.ifremer.isisfish.simulator.SimulationListener#afterSimulation(fr.ifremer.isisfish.simulator.SimulationContext)
     */
    @Override
    public void afterSimulation(SimulationContext context) {
        SimulationStorage simulation = context.getSimulationStorage();
        SimulationParameter parameters = simulation.getParameter();
        File rootDirectory = simulation.getDirectory();
        SimulationControl control = context.getSimulationControl();

        // Ici on contantene les 2 listes d'exports

        // first, make export instances based on export
        // names
        List<Export> allExports = new ArrayList<Export>();
        if (parameters.getExportNames() != null) {
            for (String exportName : parameters.getExportNames()) {
                try {
                    ExportStorage storage = ExportStorage.getExport(exportName);
                    Export export = storage.getNewInstance();
                    allExports.add(export);
                } catch (IsisFishException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't get export instance " + exportName, e);
                    }
                }
            }
        }
        
        // second, add already instanciated sensitivity
        // exports (with parameters)
        List<SensitivityExport> sensitivityExports = parameters.getSensitivityExport();
        if (sensitivityExports != null) {
            allExports.addAll(sensitivityExports);
        }

        // third, optimization export
        Set<Export> optimizationExports = parameters.getOptimizationExportsObservations().keySet();
        for (Export export : optimizationExports) {
            // exclude export already added with regular exports
            String exportName = ExportStorage.getName(export);
            if (parameters.getExportNames() == null || !parameters.getExportNames().contains(exportName)) {
                allExports.add(export);
            }
        }

        // make exports
        if (!allExports.isEmpty()) {
            control.setText(t("isisfish.message.export.export"));
            File exportDir = SimulationStorage
                    .getResultExportDirectory(rootDirectory);
            exportDir.mkdirs();
            ExportHelper.doExport(simulation, exportDir, allExports,
                    rootDirectory);
        }
    }

    /*
     * @see fr.ifremer.isisfish.simulator.SimulationListener#beforeSimulation(fr.ifremer.isisfish.simulator.SimulationContext)
     */
    @Override
    public void beforeSimulation(SimulationContext context) {
    }
}
