/*
 * #%L
 * IsisFish
 * 
 * $Id: TargetSpeciesTargetFactorEquation.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;

/**
 * Target species's target factor equation.
 *
 * Created: 23 août 2006 16:44:40
 *
 * @author poussin
 * @version $Revision: 3798 $
 *
 * Last update: $Date: 2012-10-30 11:39:32 +0100 (Tue, 30 Oct 2012) $
 * by : $Author: echatellier $
 */
public interface TargetSpeciesTargetFactorEquation {
    
    /**
     * Compute target factor.
     * 
     * @param context simulation context
     * @param group le group pour lequel on recherche le facteur de ciblage
     * @param species l'espece pour lequel on recherche le facteur de ciblage 
     * @param infoMetier
     * @param primaryCatch
     * @return equation result
     * @throws Exception 
     */
    @Args({"context", "group", "species", "infoMetier", "primaryCatch"})
    public double compute(SimulationContext context,
            PopulationGroup group, Species species,
            MetierSeasonInfo infoMetier, boolean primaryCatch) throws Exception;

}
