package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Tue Jun 10 19:21:29 CEST 2014")
public abstract class ZoneAbstract extends TopiaEntityAbstract implements Zone {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : cell
     */
    protected List<Cell> cell;

    private static final long serialVersionUID = 3702634420704196153L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Zone.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Zone.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_CELL, List.class, Cell.class, cell);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        String result = this.name;

        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        String result = this.comment;

        return result;
    }

    @Override
    public void addCell(Cell cell) {
        fireOnPreWrite(PROPERTY_CELL, null, cell);
        if (this.cell == null) {
            this.cell = new ArrayList<Cell>();
        }

        this.cell.add(cell);
        fireOnPostWrite(PROPERTY_CELL, this.cell.size(), null, cell);
    }

    @Override
    public void addAllCell(List<Cell> cell) {
        if (cell == null) {
            return;
        }
        for (Cell item : cell) {
            addCell(item);
        }
    }

    @Override
    public void setCell(List<Cell> cell) {
        // Copy elements to keep data for fire with new reference
        List<Cell> oldValue = this.cell != null ? new ArrayList<Cell>(this.cell) : null;
        fireOnPreWrite(PROPERTY_CELL, oldValue, cell);
        this.cell = cell;
        fireOnPostWrite(PROPERTY_CELL, oldValue, cell);
    }

    @Override
    public void removeCell(Cell cell) {
        fireOnPreWrite(PROPERTY_CELL, cell, null);
        if (this.cell == null || !this.cell.remove(cell)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_CELL, this.cell.size() + 1, cell, null);
    }

    @Override
    public void clearCell() {
        if (this.cell == null) {
            return;
        }
        List<Cell> oldValue = new ArrayList<Cell>(this.cell);
        fireOnPreWrite(PROPERTY_CELL, oldValue, this.cell);
        this.cell.clear();
        fireOnPostWrite(PROPERTY_CELL, oldValue, this.cell);
    }

    @Override
    public List<Cell> getCell() {
        return cell;
    }

    @Override
    public Cell getCellByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(cell, topiaId);
    }

    @Override
    public int sizeCell() {
        if (cell == null) {
            return 0;
        }
        return cell.size();
    }

    @Override
    public boolean isCellEmpty() {
        int size = sizeCell();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_COMMENT, this.comment).
            append(PROPERTY_CELL, this.cell).
         toString();
        return result;
    }

} //ZoneAbstract
