package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Tue Jun 10 19:21:29 CEST 2014")
public abstract class SpeciesDAOAbstract<E extends Species> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Species.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.Species;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Population> list = getContext()
                                                    .getDAO(Population.class)
                                                    .findAllByProperties(Population.PROPERTY_SPECIES, entity);
                                            for (Population item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSpecies())) {
                                                    item.setSpecies(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Species.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Species.PROPERTY_NAME, v);
        return result;
    }

    public E findByScientificName(String v) throws TopiaException {
        E result = findByProperty(Species.PROPERTY_SCIENTIFIC_NAME, v);
        return result;
    }

    public List<E> findAllByScientificName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Species.PROPERTY_SCIENTIFIC_NAME, v);
        return result;
    }

    public E findByCodeRubbin(String v) throws TopiaException {
        E result = findByProperty(Species.PROPERTY_CODE_RUBBIN, v);
        return result;
    }

    public List<E> findAllByCodeRubbin(String v) throws TopiaException {
        List<E> result = findAllByProperty(Species.PROPERTY_CODE_RUBBIN, v);
        return result;
    }

    public E findByCodeCEE(int v) throws TopiaException {
        E result = findByProperty(Species.PROPERTY_CODE_CEE, v);
        return result;
    }

    public List<E> findAllByCodeCEE(int v) throws TopiaException {
        List<E> result = findAllByProperty(Species.PROPERTY_CODE_CEE, v);
        return result;
    }

    public E findByAgeGroupType(boolean v) throws TopiaException {
        E result = findByProperty(Species.PROPERTY_AGE_GROUP_TYPE, v);
        return result;
    }

    public List<E> findAllByAgeGroupType(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Species.PROPERTY_AGE_GROUP_TYPE, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Species.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Species.PROPERTY_COMMENT, v);
        return result;
    }

    public E findContainsPopulation(Population v) throws TopiaException {
        E result = findContains(Species.PROPERTY_POPULATION, v);
        return result;
    }

    public List<E> findAllContainsPopulation(Population v) throws TopiaException {
        List<E> result = findAllContains(Species.PROPERTY_POPULATION, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllBySpecies(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Population.class, entity);
        if (!list.isEmpty()) {
            result.put(Population.class, list);
        }

        return result;
    }

} //SpeciesDAOAbstract<E extends Species>
