package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Tue Jun 10 19:21:29 CEST 2014")
public abstract class PopulationDAOAbstract<E extends Population> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Population.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.Population;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<PopulationGroup> list = getContext()
                                                    .getDAO(PopulationGroup.class)
                                                    .findAllByProperties(PopulationGroup.PROPERTY_POPULATION, entity);
                                            for (PopulationGroup item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPopulation())) {
                                                    item.setPopulation(null);
                                                }
                        
                    }
                }

                                        {
                                        List<PopulationSeasonInfo> list = getContext()
                                                    .getDAO(PopulationSeasonInfo.class)
                                                    .findAllByProperties(PopulationSeasonInfo.PROPERTY_POPULATION, entity);
                                            for (PopulationSeasonInfo item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPopulation())) {
                                                    item.setPopulation(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_NAME, v);
        return result;
    }

    public E findByGeographicId(String v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_GEOGRAPHIC_ID, v);
        return result;
    }

    public List<E> findAllByGeographicId(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_GEOGRAPHIC_ID, v);
        return result;
    }

    public E findByPlusGroup(boolean v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_PLUS_GROUP, v);
        return result;
    }

    public List<E> findAllByPlusGroup(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_PLUS_GROUP, v);
        return result;
    }

    public E findByGrowth(Equation v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_GROWTH, v);
        return result;
    }

    public List<E> findAllByGrowth(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_GROWTH, v);
        return result;
    }

    public E findByGrowthReverse(Equation v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_GROWTH_REVERSE, v);
        return result;
    }

    public List<E> findAllByGrowthReverse(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_GROWTH_REVERSE, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_COMMENT, v);
        return result;
    }

    public E findByMeanWeight(Equation v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_MEAN_WEIGHT, v);
        return result;
    }

    public List<E> findAllByMeanWeight(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_MEAN_WEIGHT, v);
        return result;
    }

    public E findByPrice(Equation v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_PRICE, v);
        return result;
    }

    public List<E> findAllByPrice(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_PRICE, v);
        return result;
    }

    public E findByNaturalDeathRate(Equation v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_NATURAL_DEATH_RATE, v);
        return result;
    }

    public List<E> findAllByNaturalDeathRate(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_NATURAL_DEATH_RATE, v);
        return result;
    }

    public E findByCaractBioComment(String v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_CARACT_BIO_COMMENT, v);
        return result;
    }

    public List<E> findAllByCaractBioComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_CARACT_BIO_COMMENT, v);
        return result;
    }

    public E findByReproductionEquation(Equation v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_REPRODUCTION_EQUATION, v);
        return result;
    }

    public List<E> findAllByReproductionEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_REPRODUCTION_EQUATION, v);
        return result;
    }

    public E findByMonthGapBetweenReproRecrutement(int v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, v);
        return result;
    }

    public List<E> findAllByMonthGapBetweenReproRecrutement(int v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, v);
        return result;
    }

    public E findByRecruitmentDistribution(MatrixND v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_RECRUITMENT_DISTRIBUTION, v);
        return result;
    }

    public List<E> findAllByRecruitmentDistribution(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_RECRUITMENT_DISTRIBUTION, v);
        return result;
    }

    public E findByRecruitmentComment(String v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_RECRUITMENT_COMMENT, v);
        return result;
    }

    public List<E> findAllByRecruitmentComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_RECRUITMENT_COMMENT, v);
        return result;
    }

    public E findByZonesComment(String v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_ZONES_COMMENT, v);
        return result;
    }

    public List<E> findAllByZonesComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_ZONES_COMMENT, v);
        return result;
    }

    public E findBySeasonsComment(String v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_SEASONS_COMMENT, v);
        return result;
    }

    public List<E> findAllBySeasonsComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_SEASONS_COMMENT, v);
        return result;
    }

    public E findByCapturabilityComment(String v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_CAPTURABILITY_COMMENT, v);
        return result;
    }

    public List<E> findAllByCapturabilityComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_CAPTURABILITY_COMMENT, v);
        return result;
    }

    public E findByMigrationComment(String v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_MIGRATION_COMMENT, v);
        return result;
    }

    public List<E> findAllByMigrationComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_MIGRATION_COMMENT, v);
        return result;
    }

    public E findByMappingZoneReproZoneRecru(MatrixND v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_MAPPING_ZONE_REPRO_ZONE_RECRU, v);
        return result;
    }

    public List<E> findAllByMappingZoneReproZoneRecru(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_MAPPING_ZONE_REPRO_ZONE_RECRU, v);
        return result;
    }

    public E findByCapturability(MatrixND v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_CAPTURABILITY, v);
        return result;
    }

    public List<E> findAllByCapturability(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_CAPTURABILITY, v);
        return result;
    }

    public E findByCapturabilityEquationUsed(boolean v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_CAPTURABILITY_EQUATION_USED, v);
        return result;
    }

    public List<E> findAllByCapturabilityEquationUsed(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_CAPTURABILITY_EQUATION_USED, v);
        return result;
    }

    public E findByCapturabilityEquation(Equation v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_CAPTURABILITY_EQUATION, v);
        return result;
    }

    public List<E> findAllByCapturabilityEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_CAPTURABILITY_EQUATION, v);
        return result;
    }

    public E findByMaturityOgiveEquation(Equation v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_MATURITY_OGIVE_EQUATION, v);
        return result;
    }

    public List<E> findAllByMaturityOgiveEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_MATURITY_OGIVE_EQUATION, v);
        return result;
    }

    public E findByReproductionRateEquation(Equation v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_REPRODUCTION_RATE_EQUATION, v);
        return result;
    }

    public List<E> findAllByReproductionRateEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_REPRODUCTION_RATE_EQUATION, v);
        return result;
    }

    public E findByGroupMin(int v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_GROUP_MIN, v);
        return result;
    }

    public List<E> findAllByGroupMin(int v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_GROUP_MIN, v);
        return result;
    }

    public E findByGroupMax(int v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_GROUP_MAX, v);
        return result;
    }

    public List<E> findAllByGroupMax(int v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_GROUP_MAX, v);
        return result;
    }

    public E findContainsPopulationGroup(PopulationGroup v) throws TopiaException {
        E result = findContains(Population.PROPERTY_POPULATION_GROUP, v);
        return result;
    }

    public List<E> findAllContainsPopulationGroup(PopulationGroup v) throws TopiaException {
        List<E> result = findAllContains(Population.PROPERTY_POPULATION_GROUP, v);
        return result;
    }

    public E findContainsPopulationSeasonInfo(PopulationSeasonInfo v) throws TopiaException {
        E result = findContains(Population.PROPERTY_POPULATION_SEASON_INFO, v);
        return result;
    }

    public List<E> findAllContainsPopulationSeasonInfo(PopulationSeasonInfo v) throws TopiaException {
        List<E> result = findAllContains(Population.PROPERTY_POPULATION_SEASON_INFO, v);
        return result;
    }

    public E findBySpecies(Species v) throws TopiaException {
        E result = findByProperty(Population.PROPERTY_SPECIES, v);
        return result;
    }

    public List<E> findAllBySpecies(Species v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PROPERTY_SPECIES, v);
        return result;
    }

    public E findContainsReproductionZone(Zone v) throws TopiaException {
        E result = findContains(Population.PROPERTY_REPRODUCTION_ZONE, v);
        return result;
    }

    public List<E> findAllContainsReproductionZone(Zone v) throws TopiaException {
        List<E> result = findAllContains(Population.PROPERTY_REPRODUCTION_ZONE, v);
        return result;
    }

    public E findContainsPopulationZone(Zone v) throws TopiaException {
        E result = findContains(Population.PROPERTY_POPULATION_ZONE, v);
        return result;
    }

    public List<E> findAllContainsPopulationZone(Zone v) throws TopiaException {
        List<E> result = findAllContains(Population.PROPERTY_POPULATION_ZONE, v);
        return result;
    }

    public E findContainsRecruitmentZone(Zone v) throws TopiaException {
        E result = findContains(Population.PROPERTY_RECRUITMENT_ZONE, v);
        return result;
    }

    public List<E> findAllContainsRecruitmentZone(Zone v) throws TopiaException {
        List<E> result = findAllContains(Population.PROPERTY_RECRUITMENT_ZONE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Species.class) {
            SpeciesDAO dao = (SpeciesDAO)
                getContext().getDAO(Species.class);
            tmp = dao.findAllContainsPopulation(entity);
            result.addAll(tmp);
        }

        if (type == PopulationGroup.class) {
            PopulationGroupDAO dao = (PopulationGroupDAO)
                getContext().getDAO(PopulationGroup.class);
            tmp = dao.findAllByPopulation(entity);
            result.addAll(tmp);
        }

        if (type == PopulationSeasonInfo.class) {
            PopulationSeasonInfoDAO dao = (PopulationSeasonInfoDAO)
                getContext().getDAO(PopulationSeasonInfo.class);
            tmp = dao.findAllByPopulation(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(Species.class, entity);
        if (!list.isEmpty()) {
            result.put(Species.class, list);
        }

        list = findUsages(PopulationGroup.class, entity);
        if (!list.isEmpty()) {
            result.put(PopulationGroup.class, list);
        }

        list = findUsages(PopulationSeasonInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(PopulationSeasonInfo.class, list);
        }

        return result;
    }

} //PopulationDAOAbstract<E extends Population>
