package fr.ifremer.isisfish.ui.simulator;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.ui.SimulationUI;
import java.awt.LayoutManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SimulUI extends SimulationUI {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_PARAMS_UI_REGION_STORAGE = "paramsUI.regionStorage";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1Uu24TQRS9Ntix8yIQEQIEKUDEo2BNeDVBkCgQ4ciQKCZShBvG3rE90XpnmJlNNhSIT+AToKdBoqNCFNQUNIhfQIiCFnFnvfZmnbWcbVaac8+5Z+7MnPe/IKMknN8mvm9Jz9WsRa3Vpa2tteo2rekHVNUkE5pLaH+pNKQrMGJ315WGi5WSoRdCemGZtwR3qbuPvVCCYaX3HKqalGoN5+KMmlKFchde8IUnO6pdU0mqb//8Tr+xX79LA/gC3U3gVmYHsaKdHC1BmtkaTmCnHVJwiNtAG5K5DfQ7ZtaWHaLUE9KiL+AVDJUgK4hEMQ0XDr/lQCPg+0LD+FyZtTyHaMbdzeJ1DVfq0mJ1SVsU/4qpOlNNy2OWapdxaQWEzaIQgUoWNarc3ntKqlVqrxOXajhlvPqW2kXr1mqERJQcGicttVnUcHVgw/Ww1nBHuxIjQtJysDmjcm2wSqf8gFJWUTewcnnw3oPKOH2cCxw6exnOUENhoMxajBGXy1FfcKkPN5qHYW2PI0mV5+jlJmc1ejhHGzFGXG6C2DvErZkz7Bza/EDBpR5OXDI/h7ei6NY53rgzsRfSvjQhKg4S5s3CpQTgRj/gZj/gVj/gdj/gTgeQcDbmGhPDihIjetKpCmSkh8sapisHQ2YDoXa8TPfEixEM0H9Tk98//fy40smUFPY+mVi6LxLxrQvJBZWamdbH2oHiaeYUHhOxUIG8og7maZCXMwnGyiGM5rDfcUO3DN16RFQTJTJDPz5/mXr+7QikV2DY4cReIaa+CHndxNvX5I7ti/uLgaPR3ZwJQ+NNw5ikDbz1ZSwmDRzV+F2baDJbZa6NB3/Px1nMJMyia6ia//p3svxhcf88Tvctj2aSeQZZ5jrMpUHKhgGamKojQlHP5lFQJkVnyvwnhBD/AaXFTWWzBgAA";
    private static final Log log = LogFactory.getLog(SimulUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdvancedParamsUI advancedParamsUI;
    protected ExportUI exportUI;
    protected OptimizationUI optimizationUI;
    protected ParamsUI paramsUI;
    protected PreScriptsUI preScriptUI;
    protected ResultChoiceUI resultChoiceUI;
    protected SensUI sensUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SimulUI $SimulationUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;
    private TabInfo $TabInfo6;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
        public void refresh() {
            paramsUI.refresh();
            preScriptUI.refresh();
            sensUI.refresh();
            optimizationUI.refresh();
            exportUI.refresh();
            resultChoiceUI.refresh();
            advancedParamsUI.refresh();
            optimizationUI.refresh();
        }
       
        /**
         * Refresh all simulation launch UI.
         */
        @Override
        protected void regionStorageChanged() {
            optimizationUI.regionStorageChanged();
        }
        
        @Override
        public void selectParametersTab() {
            bodyTabbedPane.setSelectedIndex(0);
        }
    
        @Override
        public void setEnabledPrescriptTab(boolean selected) {
            bodyTabbedPane.setEnabledAt(1, selected);
            if (selected) {
                bodyTabbedPane.setSelectedIndex(1);
            }
        }
        
        @Override
        public void setEnabledSimulationPlanTab(boolean selected) {
            bodyTabbedPane.setEnabledAt(2, selected);
            if (selected) {
                bodyTabbedPane.setSelectedIndex(2);
            }
        }
    
        @Override
        public void setEnabledOptimizationTab(boolean selected) {
            bodyTabbedPane.setEnabledAt(3, selected);
            if (selected) {
                bodyTabbedPane.setSelectedIndex(3);
            }
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimulUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimulUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SimulUI() {
        $initialize();
    }

    public SimulUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SimulUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SimulUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimulUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SimulUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AdvancedParamsUI getAdvancedParamsUI() {
        return advancedParamsUI;
    }

    public ExportUI getExportUI() {
        return exportUI;
    }

    public OptimizationUI getOptimizationUI() {
        return optimizationUI;
    }

    public ParamsUI getParamsUI() {
        return paramsUI;
    }

    public PreScriptsUI getPreScriptUI() {
        return preScriptUI;
    }

    public ResultChoiceUI getResultChoiceUI() {
        return resultChoiceUI;
    }

    public SensUI getSensUI() {
        return sensUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBodyTabbedPane() {
        if (!allComponentsCreated) {
            return;
        }
        bodyTabbedPane.add(paramsUI);
        bodyTabbedPane.add(preScriptUI);
        bodyTabbedPane.add(sensUI);
        bodyTabbedPane.add(optimizationUI);
        bodyTabbedPane.add(exportUI);
        bodyTabbedPane.add(resultChoiceUI);
        bodyTabbedPane.add(advancedParamsUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 0));
        bodyTabbedPane.setTitleAt(0, t("isisfish.params.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 1));
        bodyTabbedPane.setTitleAt(1, t("isisfish.preScript.title"));
        bodyTabbedPane.setEnabledAt(1, false);
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 2));
        bodyTabbedPane.setTitleAt(2, t("isisfish.sens.title"));
        bodyTabbedPane.setEnabledAt(2, false);
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 3));
        bodyTabbedPane.setTitleAt(3, t("isisfish.optimization.title"));
        bodyTabbedPane.setEnabledAt(3, false);
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 4));
        bodyTabbedPane.setTitleAt(4, t("isisfish.export.title"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 5));
        bodyTabbedPane.setTitleAt(5, t("isisfish.resultChoice.title"));
        $TabInfo6.addPropertyChangeListener(new TabInfoPropertyChangeListener(bodyTabbedPane, 6));
        bodyTabbedPane.setTitleAt(6, t("isisfish.advancedParameters.title"));
    }

    protected void createAdvancedParamsUI() {
        $objectMap.put("advancedParamsUI", advancedParamsUI = new AdvancedParamsUI(this));
        
        advancedParamsUI.setName("advancedParamsUI");
    }

    @Override
    protected void createBodyTabbedPane() {
        super.createBodyTabbedPane();
        bodyTabbedPane.setName("bodyTabbedPane");
    }

    protected void createExportUI() {
        $objectMap.put("exportUI", exportUI = new ExportUI(this));
        
        exportUI.setName("exportUI");
    }

    protected void createOptimizationUI() {
        $objectMap.put("optimizationUI", optimizationUI = new OptimizationUI(this));
        
        optimizationUI.setName("optimizationUI");
    }

    protected void createParamsUI() {
        $objectMap.put("paramsUI", paramsUI = new ParamsUI(this));
        
        paramsUI.setName("paramsUI");
    }

    protected void createPreScriptUI() {
        $objectMap.put("preScriptUI", preScriptUI = new PreScriptsUI(this));
        
        preScriptUI.setName("preScriptUI");
    }

    protected void createResultChoiceUI() {
        $objectMap.put("resultChoiceUI", resultChoiceUI = new ResultChoiceUI(this));
        
        resultChoiceUI.setName("resultChoiceUI");
    }

    protected void createSensUI() {
        $objectMap.put("sensUI", sensUI = new SensUI(this));
        
        sensUI.setName("sensUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBodyTabbedPane();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$SimulationUI0", $SimulationUI0);
        createParamsUI();
        createPreScriptUI();
        createSensUI();
        createOptimizationUI();
        createExportUI();
        createResultChoiceUI();
        createAdvancedParamsUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.params.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setEnabled(false);
        $TabInfo1.setTitle(t("isisfish.preScript.title"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setEnabled(false);
        $TabInfo2.setTitle(t("isisfish.sens.title"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setEnabled(false);
        $TabInfo3.setTitle(t("isisfish.optimization.title"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(t("isisfish.export.title"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(t("isisfish.resultChoice.title"));
        // inline creation of $TabInfo6
        $objectMap.put("$TabInfo6", $TabInfo6 = new TabInfo());
        
        $TabInfo6.setTitle(t("isisfish.advancedParameters.title"));
        // inline creation of $SimulationUI0
        setName("$SimulationUI0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PARAMS_UI_REGION_STORAGE, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                paramsUI.setRegionStorage(getRegionStorage());
            }
        });
    }

}