/*
 * #%L
 * IsisFish
 * 
 * $Id: RuleParametersFactorTableCellRenderer.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.0.0/src/main/java/fr/ifremer/isisfish/ui/models/rule/RuleParametersFactorTableCellRenderer.java $
 * %%
 * Copyright (C) 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.rule;

import java.awt.Component;

import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputHandler;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;

/**
 * Specific editor for rule parameters.
 *
 * @author chatellier
 * @version $Revision: 3798 $
 * 
 * Last update : $Date: 2012-10-30 11:39:32 +0100 (Tue, 30 Oct 2012) $
 * By : $Author: echatellier $
 */
public class RuleParametersFactorTableCellRenderer extends DefaultTableCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1655744662816030649L;

    /** Class logger. */
    private static Log log = LogFactory.getLog(RuleParametersFactorTableCellRenderer.class);

    protected RuleChooser ruleChooser;

    protected Rule rule;

    public RuleParametersFactorTableCellRenderer(RuleChooser ruleChooser, Rule rule) {
        this.ruleChooser = ruleChooser;
        this.rule = rule;
    }

    /*
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {

        Component comp = null;

        String paramName = (String)value;
        try {
            Class paramType = RuleStorage.getParameterType(rule, paramName);
            SensitivityInputHandler handler = ruleChooser.getContextValue(SensitivityInputHandler.class);
            boolean canBeFactor = handler.canBeFactor(paramType);
            if (canBeFactor) {
                comp = new JButton(Resource.getIcon("/icons/building_add.png"));
            }
        } catch (IsisFishException ex) {
            if (log.isWarnEnabled()) {
                log.warn("Can't get value type", ex);
            }
        }

        if (comp == null) {
            comp = super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        }

        return comp;
    }

}
