package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PopulationEquationUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_MATURITY_OGIVE_ACTIVE = "maturityOgive.active";
    public static final String BINDING_MATURITY_OGIVE_BEAN = "maturityOgive.bean";
    public static final String BINDING_MEAN_WEIGHT_ACTIVE = "meanWeight.active";
    public static final String BINDING_MEAN_WEIGHT_BEAN = "meanWeight.bean";
    public static final String BINDING_NATURAL_DEATH_RATE_ACTIVE = "naturalDeathRate.active";
    public static final String BINDING_NATURAL_DEATH_RATE_BEAN = "naturalDeathRate.bean";
    public static final String BINDING_REPRODUCTION_RATE_ACTIVE = "reproductionRate.active";
    public static final String BINDING_REPRODUCTION_RATE_BEAN = "reproductionRate.bean";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWz08TQRTHh9qC/BKEQECrQcB4INmKxoOBAFokliAQECX24rQ7tEO2s8vMW9hyMP4J3r3o3YuJN0/Gg2cPXoz/gjEevBrfbEtLdV02bA+77bz3PvN9782b9M13klKSXNmlnmdIVwCvMGP5zvb2WmGXFWGRqaLkDtiS1D5tCZLIk26zsa6ATORXdHimHp7J2hXHFkwci55ZIV0KqhZTZcYAyKXWiKJSmc2GecZzXHlEbYgKor76+SPxwnz+OkGI56C6bkxl7KSoZibJFZLgJpAB3GmfZiwqSihDclFCvb16LWtRpVZphe2RZ6RjhbQ7VCIMyHj0lH2GH+85QPonc8JxIWsLQPet3HUg0zvS4DuSVRi+FVc7XJUNlxtcOxrrtuNaFLgt7u25/nsr5zg+sB1IssCoAHItCIF8DpypY4hmYOc+tbhJUSiQqZaSNQyGOsBSGJv6+eho8fjWtlnF4uk6eXXf5XUqmNX06Zh8SAsWwyRHWvaoefs27TnQCOgXFFxJrUVGobxBgQHJhJbHr+aaYM3iaNJQA9hVwQI9ZrxUBr1yodXaW9Hbcaiulfg+C3Dol8yRtukWNVvrCfBJKrqPOgdbCnHXBbBFq2N7kYois/SvibpFkosthcFJMJqT0DyqbXmSki4uYyXz/w7PBppqYzPy19hooG/9PTz45f23d0tHs5LGvYcCXY+NOp5hTN9hUp8jIH21QXGBW5kH1JnJk07FLLwn/HsgHSBss25GcbjfeR1u6HDjPlVlRKQ6vn74OPz08xmSWCJdlk3NJar9c6QTyhKrYFum58wv+Ip6Ds7is19rw2KiH9d1PzeLB5OOFbgwsfJzHhYhHVCEhpJC56dfg5tvF44K0YbCRv/r3ixG6glp58LigvnXRv1GCLwmuh3FXNNuTn7QXdCm36NOfVim/GcmKFN/xrX1hufq101ftP52KzKjRzPWa63UQztby2SMAt53BRfY3OnZqaJFDw9jCuzbsWUFD18WZ6xky6p2nD89LgnMg1gMvTwdklQ6EuF2bMJcSBbRCIuxNeRia1iNTQjrxeXYvYhGCOtFNEJYL6IRwnoRjRDWi2iEsF6Mxe5FNEJYL6IRwnoRjRDWi2iEsF6cTMA/WEzoP1FmSCrjsYVEI7wM0XA1tgZN+AMoc9+trQwAAA==";
    private static final Log log = LogFactory.getLog(PopulationEquationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton cancel;
    protected InputOneEquationUI maturityOgive;
    protected InputOneEquationUI meanWeight;
    protected InputOneEquationUI naturalDeathRate;
    protected InputOneEquationUI reproductionRate;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationEquationUI $InputContentUI0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationEquationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationEquationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationEquationUI() {
        $initialize();
    }

    public PopulationEquationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationEquationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationEquationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationEquationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationEquationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public InputOneEquationUI getMaturityOgive() {
        return maturityOgive;
    }

    public InputOneEquationUI getMeanWeight() {
        return meanWeight;
    }

    public InputOneEquationUI getNaturalDeathRate() {
        return naturalDeathRate;
    }

    public InputOneEquationUI getReproductionRate() {
        return reproductionRate;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createMaturityOgive() {
        $objectMap.put("maturityOgive", maturityOgive = new InputOneEquationUI(this));
        
        maturityOgive.setName("maturityOgive");
        maturityOgive.setBeanProperty("MaturityOgiveEquation");
        maturityOgive.setFormuleCategory("MaturityOgive");
        maturityOgive.setText(t("isisfish.populationEquation.MaturityOgive"));
        maturityOgive.putClientProperty("sensitivityBean", Population.class);
        maturityOgive.putClientProperty("sensitivityMethod", "MaturityOgiveEquation");
    }

    protected void createMeanWeight() {
        $objectMap.put("meanWeight", meanWeight = new InputOneEquationUI(this));
        
        meanWeight.setName("meanWeight");
        meanWeight.setBeanProperty("MeanWeight");
        meanWeight.setFormuleCategory("MeanWeight");
        meanWeight.setText(t("isisfish.populationEquation.meanWeight"));
        meanWeight.putClientProperty("sensitivityBean", Population.class);
        meanWeight.putClientProperty("sensitivityMethod", "MeanWeight");
    }

    protected void createNaturalDeathRate() {
        $objectMap.put("naturalDeathRate", naturalDeathRate = new InputOneEquationUI(this));
        
        naturalDeathRate.setName("naturalDeathRate");
        naturalDeathRate.setBeanProperty("NaturalDeathRate");
        naturalDeathRate.setFormuleCategory("NaturalDeathRate");
        naturalDeathRate.setText(t("isisfish.populationEquation.naturalDeathRate"));
        naturalDeathRate.putClientProperty("sensitivityBean", Population.class);
        naturalDeathRate.putClientProperty("sensitivityMethod", "NaturalDeathRate");
    }

    protected void createReproductionRate() {
        $objectMap.put("reproductionRate", reproductionRate = new InputOneEquationUI(this));
        
        reproductionRate.setName("reproductionRate");
        reproductionRate.setBeanProperty("ReproductionRateEquation");
        reproductionRate.setFormuleCategory("ReproductionRate");
        reproductionRate.setText(t("isisfish.populationEquation.reproductionRate"));
        reproductionRate.putClientProperty("sensitivityBean", Population.class);
        reproductionRate.putClientProperty("sensitivityMethod", "ReproductionRateEquation");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Population.class, "equation"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add(SwingUtil.boxComponentWithJxLayer(naturalDeathRate), new GridBagConstraints(0, 0, 2, 1, 0.5, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(meanWeight), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(maturityOgive), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(reproductionRate), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        naturalDeathRate.setClazz(fr.ifremer.isisfish.equation.PopulationNaturalDeathRate.class);
        meanWeight.setClazz(fr.ifremer.isisfish.equation.PopulationMeanWeight.class);
        maturityOgive.setClazz(fr.ifremer.isisfish.equation.PopulationMaturityOgiveEquation.class);
        reproductionRate.setClazz(fr.ifremer.isisfish.equation.PopulationReproductionRateEquation.class);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNaturalDeathRate();
        createMeanWeight();
        createMaturityOgive();
        createReproductionRate();
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        /*public void refresh() {
            Population population = getSaveVerifier().getEntity(Population.class);
            
            // add null before, for second to be considered as a changed event
            // otherwize, setBean has no effect
            setBean(null);
            setBean(population);
        
            getSaveVerifier().addCurrentPanel(naturalDeathRate, meanWeight, price);
        }*/;// registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NATURAL_DEATH_RATE_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                naturalDeathRate.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NATURAL_DEATH_RATE_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                naturalDeathRate.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MEAN_WEIGHT_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                meanWeight.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MEAN_WEIGHT_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                meanWeight.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MATURITY_OGIVE_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                maturityOgive.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MATURITY_OGIVE_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                maturityOgive.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPRODUCTION_RATE_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                reproductionRate.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REPRODUCTION_RATE_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                reproductionRate.setBean(getBean());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}