package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class PopulationCapturabilityUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CAPTURABILITY_EQUATION_ACTIVE = "capturabilityEquation.active";
    public static final String BINDING_CAPTURABILITY_EQUATION_BEAN = "capturabilityEquation.bean";
    public static final String BINDING_FIELD_POPULATION_CAPTURABILITY_COMMENT_ENABLED = "fieldPopulationCapturabilityComment.enabled";
    public static final String BINDING_FIELD_POPULATION_CAPTURABILITY_COMMENT_TEXT = "fieldPopulationCapturabilityComment.text";
    public static final String BINDING_FIELD_POPULATION_CAPTURABILITY_ENABLED = "fieldPopulationCapturability.enabled";
    public static final String BINDING_FIELD_POPULATION_CAPTURABILITY_MATRIX = "fieldPopulationCapturability.matrix";
    public static final String BINDING_FIELD_USE_CAPTURABILITY_EQUATION_ENABLED = "fieldUseCapturabilityEquation.enabled";
    public static final String BINDING_FIELD_USE_CAPTURABILITY_EQUATION_SELECTED = "fieldUseCapturabilityEquation.selected";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVQW8bRRSemNhJ2pSUpgktpDSlllqJah04IKREbRrTgCOXRrhBFb50vDu2px3PTGdm03UPiJ/AT4A7FyRunBAHzhy4IP4CQhy4It7M2t5s2W5XbA5jZ+a9b773zXufv/0DVbVCVx7hKPJUyA0dEe/g9oMH93qPiG8+JNpXVBqhUPw3V0GVLjodzPa1QVe7bZvemKQ3mmIkBSf8RPZ2G53SZsyIHhJiDLqUzvC1bnRmx9uRDNUUdUYqC/Xrv/6sfBV8+U0FoUgCuxUoZfNlWUkl821UoYFB5+CmY9xgmA+AhqJ8AHzP2L0mw1p/gkfkCfoCLbRRTWIFYAa9Xbxkh+HyI2nQ2XqLy9A0BTcQftTaMuj9vvJoX5ERgU9NdZ/qoRdSj9pA71DIkGFDBW9iaUKFe5RRMz5qSelQawbN9wjmBl3LwoFLqKFEn8BJEpeOMaMBBrYGvZPSbXbg6aegh9ex62fTzZNXi2AMClqxoknswSHmhCUxC/X7uMcIVHohdUcc7c5s5LlZwmL9oI17hG09D+x2bdDaLPZSnxIWHGmSUufOk9CVatBaCqA5JP7jPRGlMZaHUBawcLzt3vn0+Ya74wUPYdANoQYeD6kR3BthM7SLopE3gDe867464DsBRCgL+dYMec3PZt3IbQnXQfc4mcYftdKoU/3etf+/ka7lTP2g4yvBmOUEAr+e0ic5SmddzVMAmn/khiKt9X0SmduKYAtxPWkYjY+JQaup0L3QgHjpK2s+5n78HFuTE4XeTDUQ2IaX2EYy13NdVFUhbEPHdf/rNJ/CUewxF57zGAvoTv9ZX/31h9+/358ayzrcvZYZesIXYeClEpIoO28GrcSuEhrKGnex3O6iJU0YmKozzY0MYp3JMZCD+16z6Z5N9z7GeggQ1YXffvxp/eEvr6DKPjrFBA72sY1voSUzVKCCYEEkb+06RstPF2E9a7nBCBJuGxy87tUdmGC82aM8AOlvRqDCRoYKMyq9pZ//Xu18tztVYg6YXXxheKJG9XNUo5xRTpzJTvwz01RPS03CQCQ+meWcc/bzopy4ygdu3ckqdd5A34Fx7MS3b2IDE9gLDYFabdKuK8J+2yuIabdv2uVWNsJGAVaL8dOToBSO3d63y0f/n0mN4bEITQ6Py6UVuVKER+ySZVFgAOgxyUGpF+kZ+wNaEmPZYhzG8z/OeaMiWFWf4WfPShJa6Qs1AodqYkMGQpXj9LLOK4aQ1zPXSnMohpDH4UZxDqUQ8jg0SutQDCGPw3ulOViEfwH1255cXAwAAA==";
    private static final Log log = LogFactory.getLog(PopulationCapturabilityUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton cancel;
    protected InputOneEquationUI capturabilityEquation;
    protected MatrixPanelEditor fieldPopulationCapturability;
    protected JTextArea fieldPopulationCapturabilityComment;
    protected JCheckBox fieldUseCapturabilityEquation;
    protected JPanel hidablePanel;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationCapturabilityUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldPopulationCapturabilityComment.setText("");
                    fieldPopulationCapturability.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    if (getBean().getCapturability() != null) {
                        fieldPopulationCapturability.setMatrix(getBean().getCapturability().copy());
                    }
                    refreshHidablePanel();
                }
            }
        });
    }
    
    protected void populationCapturabilityMatrixChanged(MatrixPanelEvent event) {
        if (getBean() != null && fieldPopulationCapturability.getMatrix() != null) {
            getBean().setCapturability(fieldPopulationCapturability.getMatrix().copy());
        }
    }
    
    /*public void refresh() {
        Population population = getSaveVerifier().getEntity(Population.class);
    
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean(population);
    
        if (getBean() != null){
             if (getBean().getCapturability() != null) {
                fieldPopulationCapturability.setMatrix(getBean().getCapturability().copy());
             }
        }
    }*/
    protected void useEquationChanged() {
        getBean().setCapturabilityEquationUsed(fieldUseCapturabilityEquation.isSelected());
    
        // compute matrix again to not diplay values computed by equation
        if (!fieldUseCapturabilityEquation.isSelected()) {
            if (getBean().getCapturability() != null) {
                fieldPopulationCapturability.setMatrix(getBean().getCapturability().copy());
            }
        }
        refreshHidablePanel();
    }
    protected void refreshHidablePanel() {
        if (getBean() != null) {
            if (getBean().isCapturabilityEquationUsed()) {
                fieldUseCapturabilityEquation.setSelected(true);
                ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "fieldUseEquation");
            }
            else {
                fieldUseCapturabilityEquation.setSelected(false);
                ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "fieldUseMatrix");
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationCapturabilityUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationCapturabilityUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationCapturabilityUI() {
        $initialize();
    }

    public PopulationCapturabilityUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationCapturabilityUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationCapturabilityUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationCapturabilityUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationCapturabilityUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__fieldUseCapturabilityEquation(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        useEquationChanged();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldPopulationCapturabilityComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setCapturabilityComment(fieldPopulationCapturabilityComment.getText());
    }

    public void doMatrixChanged__on__fieldPopulationCapturability(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        populationCapturabilityMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public InputOneEquationUI getCapturabilityEquation() {
        return capturabilityEquation;
    }

    public MatrixPanelEditor getFieldPopulationCapturability() {
        return fieldPopulationCapturability;
    }

    public JTextArea getFieldPopulationCapturabilityComment() {
        return fieldPopulationCapturabilityComment;
    }

    public JCheckBox getFieldUseCapturabilityEquation() {
        return fieldUseCapturabilityEquation;
    }

    public JPanel getHidablePanel() {
        return hidablePanel;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToHidablePanel() {
        if (!allComponentsCreated) {
            return;
        }
        hidablePanel.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationCapturability), "fieldUseMatrix");
        hidablePanel.add(SwingUtil.boxComponentWithJxLayer(capturabilityEquation), "fieldUseEquation");
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCapturabilityEquation() {
        $objectMap.put("capturabilityEquation", capturabilityEquation = new InputOneEquationUI(this));
        
        capturabilityEquation.setName("capturabilityEquation");
        capturabilityEquation.setBeanProperty("CapturabilityEquation");
        capturabilityEquation.setFormuleCategory("Capturability");
        capturabilityEquation.setText(t("isisfish.common.capturability"));
        capturabilityEquation.putClientProperty("sensitivityBean", Population.class);
        capturabilityEquation.putClientProperty("sensitivityMethod", "CapturabilityEquation");
    }

    protected void createFieldPopulationCapturability() {
        $objectMap.put("fieldPopulationCapturability", fieldPopulationCapturability = new MatrixPanelEditor());
        
        fieldPopulationCapturability.setName("fieldPopulationCapturability");
        fieldPopulationCapturability.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__fieldPopulationCapturability"));
        fieldPopulationCapturability.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationCapturability.putClientProperty("sensitivityMethod", "Capturability");
    }

    protected void createFieldPopulationCapturabilityComment() {
        $objectMap.put("fieldPopulationCapturabilityComment", fieldPopulationCapturabilityComment = new JTextArea());
        
        fieldPopulationCapturabilityComment.setName("fieldPopulationCapturabilityComment");
        fieldPopulationCapturabilityComment.setColumns(15);
        fieldPopulationCapturabilityComment.setLineWrap(true);
        fieldPopulationCapturabilityComment.setWrapStyleWord(true);
        fieldPopulationCapturabilityComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationCapturabilityComment"));
    }

    protected void createFieldUseCapturabilityEquation() {
        $objectMap.put("fieldUseCapturabilityEquation", fieldUseCapturabilityEquation = new JCheckBox());
        
        fieldUseCapturabilityEquation.setName("fieldUseCapturabilityEquation");
        fieldUseCapturabilityEquation.setText(t("isisfish.populationCapturability.useCapturabilityEquation"));
        fieldUseCapturabilityEquation.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldUseCapturabilityEquation"));
    }

    protected void createHidablePanel() {
        $objectMap.put("hidablePanel", hidablePanel = new JPanel());
        
        hidablePanel.setName("hidablePanel");
        hidablePanel.setLayout(new CardLayout());
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Population.class, "capturability"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldUseCapturabilityEquation), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(hidablePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 5, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 5, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToHidablePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldPopulationCapturabilityComment));
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        capturabilityEquation.setClazz(fr.ifremer.isisfish.equation.PopulationCapturabilityEquation.class);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.populationCapturability.selectCoefficient"));
        createFieldUseCapturabilityEquation();
        createHidablePanel();
        createFieldPopulationCapturability();
        createCapturabilityEquation();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationCapturability.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldPopulationCapturabilityComment();
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_USE_CAPTURABILITY_EQUATION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldUseCapturabilityEquation.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_USE_CAPTURABILITY_EQUATION_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    fieldUseCapturabilityEquation.setSelected(getBean().isCapturabilityEquationUsed());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_CAPTURABILITY_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationCapturability.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_CAPTURABILITY_MATRIX, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null && getBean().getCapturability() != null) {
                    fieldPopulationCapturability.setMatrix(getBean().getCapturability() == null ? null : getBean().getCapturability().copy());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CAPTURABILITY_EQUATION_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                capturabilityEquation.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CAPTURABILITY_EQUATION_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                capturabilityEquation.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_CAPTURABILITY_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationCapturabilityComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_CAPTURABILITY_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationCapturabilityComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getCapturabilityComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}