package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.ui.input.model.MetierSeasonInfoComboModel;
import fr.ifremer.isisfish.ui.input.model.ZoneListModel;
import fr.ifremer.isisfish.ui.widget.Interval;
import fr.ifremer.isisfish.ui.widget.IntervalPanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MetierSeasonInfoZoneUI extends InputContentUI<Metier> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_METIER_SEASON_INFO = "metierSeasonInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_METIER_SEASON_ZONE_COMMENT_ENABLED = "fieldMetierSeasonZoneComment.enabled";
    public static final String BINDING_FIELD_METIER_SEASON_ZONE_COMMENT_TEXT = "fieldMetierSeasonZoneComment.text";
    public static final String BINDING_IP_ENABLED = "ip.enabled";
    public static final String BINDING_METIER_SEASON_INFO_COMBO_ENABLED = "metierSeasonInfoCombo.enabled";
    public static final String BINDING_METIER_ZONES_ENABLED = "metierZones.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_VALIDATOR_SEASON_BEAN = "validatorSeason.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWTW8jRRDtmDgfGwJhQ5YARoTFrBZFjMMGEFLC7mazBBwcPtYbFNYX2p5y3NG4Z+juSWY5IH4AB/gHcOeCxI0T4sCZAxfEX0CIw14R1T32jMeZHY+YHGairqpXr171VPn7v0hZCvLCCQ0CS/hcsT5Y+ztHRx+0T6CjboPsCOYpV5Dwb6pESi2yYEfnUpEXWw0dXhuE13bdvudy4CPRWw1yQar7DsgegFLkuWRER8paMzJvBZ4vhqgRqTTUb//5u/S1/eV3JUICD9k9g6WsTYqKK5lukBKzFbmImU5pzaH8GGkIxo+R76I+23WolO/TPnxGviCzDTLjUYFgilzOX7LBMPGBp8hStc49X+26XKH7YX1Dkc2usFhXQB/wLZnsMtmzfGYx7WgdgGIgmkCly+u8697DPId1zzOQM4pMt4FybEIaCGZgGC0HIHHQUn8MVZFXcgDE/jHU/Cl1mE2xYkXWE9pHBkueoaZWUz8/Hh7GCI9HjiG+Pn4yNi90etgYOHBtcBS5minWbuwaAyxXm6YndY61YKrPQaDqVwzXDjaOOYgVts0655kJ86o2VUZ74dr38T7pqxMMqt7/kPJRNrPVu7TtADJYTagVehub9nx+PMDkqurH5cg0V91v0DY4G+M5zal2einyXRlvOd7ZNvZ9JRFoDm+5QTJ2mMdweDlpK6EkZP0hXTlj9jEoq46XXWCXjRTp0NdSoBer+yi565g4rPGpBNXYlIxaCAvV3wkOpyeSujCptNtr5/JvTspvan8j6VDpMnDs0W9DZ0UN+2ZIJKW9C4HaEUB17PZ4d6+ldHda0lPAe5dAueUrFX4iO5HjTIfyTijs2+MWTKggzYKfCCQtgjybuJE4la14Ksdjc6pFysJ3tLqrrfOD/A6awhG+OjbCNaCx/ntp+fef/vxxbzi3K5h7JdV1ZO3gPPWE64HQAwmnRji0fcWc2gH1tlpkXmJJnXAnVVKINQdmJIf5zMWwdLj1LpU9hCjP/vHzL5c+/e0RUtojFxyX2ntU+9fJvOoJVMF17MC7cdMwevRsDp9Lmhs2MRxRuEoe28ZBRtfajNvYrusBqlBJUSGi0p7/9cFy84ebQyWmkNnTD3WP1SjfIzOMO4yD2WGD9ZS6sxY8Cb7txmsobTFN6feqNxhTH5nnYVqpZTOstfko8PXrE8Na/9fKDTILXF/6LJirOWCmFX5SOPq2QyXWqMLl3fYVXP+/mPo4i9V6DlZz+AvBBgGiEM4kJlYuBKYfJ0UQsjhsFEbYLFzFZAS9ERhnfb/fxJ2dQeb1HFCLnoAuCAF2YbBJ2rxZGGGrsLr5EL7K4PBWLoRvCiNk6XAjvw6FELI43C7ci3wIWRzeKcwhH0IWh3phDvkQsji8V5iDRvgPIbi8sTsPAAA=";
    private static final Log log = LogFactory.getLog(MetierSeasonInfoZoneUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Metier bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldMetierSeasonZoneComment;
    protected IntervalPanel ip;
    protected MetierSeasonInfo metierSeasonInfo;
    protected JComboBox metierSeasonInfoCombo;
    protected JList metierZones;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Metier> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorSeason")
    protected SwingValidator<MetierSeasonInfo> validatorSeason;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MetierSeasonInfoZoneUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected Interval interval;
    protected boolean init;
    
    
        protected void $afterCompleteSetup() {
            /*
             * Don't add both in same listener.
             * When first is set, last value from getPopulationSeasonInfo()
             * is erased by interval.getLast() default value.
             */
            ip.addPropertyChangeListener("first", new PropertyChangeListener() {
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (getMetierSeasonInfo() != null) {
                        getMetierSeasonInfo().setFirstMonth(new Month(interval.getFirst()));
                    }
                }
            });
            ip.addPropertyChangeListener("last", new PropertyChangeListener() {
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (getMetierSeasonInfo() != null) {
                        getMetierSeasonInfo().setLastMonth(new Month(interval.getLast()));
                    }
                }
            });
            
            addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() == null) {
        
                    }
                    if (evt.getNewValue() != null) {
                        refresh();
                    }
                }
            });
        }
    
        @Override
        public void resetChangeModel() {
            changeModel.setStayChanged(false);
        }
    
        protected void save() {
            getSaveVerifier().save();
            setMetierSeasonInfoCombo();
        }
    
        protected void create() {
               MetierSeasonInfo newMSI = getContextValue(InputAction.class).createMetierSeasonInfo(getBean());
            setMetierSeasonInfo(newMSI);
            setMetierSeasonInfoCombo();
        }
    
        protected void delete() {
            getContextValue(InputAction.class).removeMetierSeasonInfo(getBean(), getMetierSeasonInfo());
            setMetierSeasonInfo(null);
            setMetierSeasonInfoCombo();
        }
    
        public void refresh() {
            
            if (log.isDebugEnabled()) {
                log.debug("Refresh called in ui : " + this);
            }
    
            setMetierSeasonInfo(null);
    
            if (getBean() != null) {
                // Model instanciation
                interval = new Interval();
                interval.setMin(0);
                interval.setMax(11);
                interval.setFirst(0);
                interval.setLast(2);
    
                setMetierSeasonInfoCombo();
                setSeason();
                setMetierZone();
                
                ip.setLabelRenderer(Month.MONTH);
                ip.setModel(interval);
            }
        }
    
        protected void setSeason() {
            if (getMetierSeasonInfo() != null) {
            
                // register selected item in save verifier
                getSaveVerifier().addCurrentEntity(getMetierSeasonInfo());
    
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Refresh interval : ");
                    }
                    Month firstMonth = getMetierSeasonInfo().getFirstMonth();
                    if (firstMonth != null) {
                        interval.setFirst(firstMonth.getMonthNumber());
                        if (log.isDebugEnabled()) {
                            log.debug(" first : " + interval.getFirst());
                        }
                    } else {
                        interval.setFirst(0);
                    }
    
                    Month lastMonth = getMetierSeasonInfo().getLastMonth();
                    if (lastMonth != null) {
                        interval.setLast(lastMonth.getMonthNumber());
                        if (log.isDebugEnabled()) {
                            log.debug(" last : " + interval.getLast());
                        }
                    } else {
                        interval.setLast(3);
                    }
                } catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't display season", e);
                    }
                }
            }
        }
        protected void setMetierZone() {
            if (getMetierSeasonInfo() != null) {
                ListSelectionListener[] listeners = metierZones.getListSelectionListeners();
                for (ListSelectionListener listener : listeners) {
                    metierZones.removeListSelectionListener(listener);
                }
    
                List<Zone> allZones = getFisheryRegion().getZone();
                ZoneListModel model = new ZoneListModel(allZones);
                metierZones.setModel(model);
                // restore selection
                if (metierSeasonInfo.getZone() != null) {
                    for (Zone zone : metierSeasonInfo.getZone()) {
                        int index = allZones.indexOf(zone);
                        metierZones.getSelectionModel().addSelectionInterval(index, index);
                    }
                }
    
                for (ListSelectionListener listener : listeners) {
                    metierZones.addListSelectionListener(listener);
                }
            }
        }
       
        protected void setMetierSeasonInfoCombo() {
            java.util.List<MetierSeasonInfo> metierSeasonInfoList = getBean().getMetierSeasonInfo();
            MetierSeasonInfoComboModel metierSeasonInfoModel = new MetierSeasonInfoComboModel(metierSeasonInfoList);
            metierSeasonInfoCombo.setModel(metierSeasonInfoModel);
            metierSeasonInfoModel.setSelectedItem(getMetierSeasonInfo());
        }
    
        protected void metierZonesChanged() {
            Object[] selected = metierZones.getSelectedValues();
            java.util.List<Zone> zones = new ArrayList<Zone>();
            for (Object o : selected){
                zones.add((Zone)o);
            }
            getMetierSeasonInfo().setZone(zones);
        }
    
        protected void seasonChanged() {
            init = true;
            setMetierSeasonInfo((MetierSeasonInfo)metierSeasonInfoCombo.getSelectedItem());
            setSeason();
            setMetierZone();
            init = false;
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MetierSeasonInfoZoneUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierSeasonInfoZoneUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MetierSeasonInfoZoneUI() {
        $initialize();
    }

    public MetierSeasonInfoZoneUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoZoneUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoZoneUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierSeasonInfoZoneUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoZoneUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        create();
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        delete();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        save();validator.setChanged(false);validatorSeason.setChanged(false);
    }

    public void doItemStateChanged__on__metierSeasonInfoCombo(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        seasonChanged();
    }

    public void doKeyReleased__on__fieldMetierSeasonZoneComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getMetierSeasonInfo().setSeasonZoneComment(fieldMetierSeasonZoneComment.getText());
    }

    public void doValueChanged__on__metierZones(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        metierZonesChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Metier getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldMetierSeasonZoneComment() {
        return fieldMetierSeasonZoneComment;
    }

    public IntervalPanel getIp() {
        return ip;
    }

    public MetierSeasonInfo getMetierSeasonInfo() {
        return metierSeasonInfo;
    }

    public JComboBox getMetierSeasonInfoCombo() {
        return metierSeasonInfoCombo;
    }

    public JList getMetierZones() {
        return metierZones;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Metier> getValidator() {
        return validator;
    }

    public SwingValidator<MetierSeasonInfo> getValidatorSeason() {
        return validatorSeason;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Metier bean) {
        Metier oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo) {
        MetierSeasonInfo oldValue = this.metierSeasonInfo;
        this.metierSeasonInfo = metierSeasonInfo;
        firePropertyChange(PROPERTY_METIER_SEASON_INFO, oldValue, metierSeasonInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidatorSeason() {
        if (!allComponentsCreated) {
            return;
        }
        validatorSeason.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldMetierSeasonZoneComment() {
        $objectMap.put("fieldMetierSeasonZoneComment", fieldMetierSeasonZoneComment = new JTextArea());
        
        fieldMetierSeasonZoneComment.setName("fieldMetierSeasonZoneComment");
        fieldMetierSeasonZoneComment.setColumns(15);
        fieldMetierSeasonZoneComment.setLineWrap(true);
        fieldMetierSeasonZoneComment.setWrapStyleWord(true);
        fieldMetierSeasonZoneComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldMetierSeasonZoneComment"));
    }

    protected void createIp() {
        $objectMap.put("ip", ip = new IntervalPanel());
        
        ip.setName("ip");
    }

    protected void createMetierSeasonInfo() {
        $objectMap.put("metierSeasonInfo", metierSeasonInfo = null);
    }

    protected void createMetierSeasonInfoCombo() {
        $objectMap.put("metierSeasonInfoCombo", metierSeasonInfoCombo = new JComboBox());
        
        metierSeasonInfoCombo.setName("metierSeasonInfoCombo");
        metierSeasonInfoCombo.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__metierSeasonInfoCombo"));
    }

    protected void createMetierZones() {
        $objectMap.put("metierZones", metierZones = new JList());
        
        metierZones.setName("metierZones");
        metierZones.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__metierZones"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Metier.class, "metier"));
    }

    protected void createValidatorSeason() {
        $objectMap.put("validatorSeason", validatorSeason = SwingValidator.newValidator(MetierSeasonInfo.class, "metier"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToValidatorSeason();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(metierSeasonInfoCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(ip), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane1, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(metierZones));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldMetierSeasonZoneComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        metierSeasonInfoCombo.setRenderer(new fr.ifremer.isisfish.ui.input.renderer.MetierSeasonInfoComboRenderer());
        $JScrollPane0.setMinimumSize(new Dimension(0,0));
        $JScrollPane0.setPreferredSize(new Dimension(0,0));
        $JScrollPane1.setMinimumSize(new Dimension(0,0));
        $JScrollPane1.setPreferredSize(new Dimension(0,0));
        // late initializer
        // register 2 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createMetierSeasonInfo();
        createValidator();
        createValidatorSeason();
        createChangeModel();
        interval = null;
        init = false;
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.metierSeasonInfoZone.selectSeason"));
        createMetierSeasonInfoCombo();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.metierSeasonInfoZone.season"));
        createIp();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.common.zone"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createMetierZones();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.metierSeasonInfoZone.comments"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFieldMetierSeasonZoneComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 17 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_SEASON_BEAN, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                validatorSeason.setBean(getMetierSeasonInfo());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorSeason != null) {
                    changeModel.setChanged(validator.isChanged() || validatorSeason.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorSeason != null) {
                    changeModel.setValid(validator.isValid() && validatorSeason.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_METIER_SEASON_INFO_COMBO_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("active", this);
                addPropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    metierSeasonInfoCombo.setEnabled(isActive() && (isSensitivity() || !changeModel.isChanged() ) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("active", this);
                removePropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_IP_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                ip.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_ZONES_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                metierZones.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_METIER_SEASON_ZONE_COMMENT_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldMetierSeasonZoneComment.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_METIER_SEASON_ZONE_COMMENT_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("metierSeasonInfo", this);
                if (getMetierSeasonInfo() != null) {
                    getMetierSeasonInfo().addPropertyChangeListener("seasonZoneComment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getMetierSeasonInfo() != null) {
                    SwingUtil.setText(fieldMetierSeasonZoneComment, jaxx.runtime.SwingUtil.getStringValue(getMetierSeasonInfo().getSeasonZoneComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("metierSeasonInfo", this);
                if (getMetierSeasonInfo() != null) {
                    getMetierSeasonInfo().removePropertyChangeListener("seasonZoneComment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    create.setEnabled(!changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(getMetierSeasonInfo() != null);
            }
        });
    }

}