package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * IsisFish
 * %%
 * Copyright (C) 1999 - 2014 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.ui.input.model.EffortDescriptionListModel;
import fr.ifremer.isisfish.ui.input.renderer.EffortDescriptionListRenderer;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class EffortDescriptionParametersUI extends InputContentUI<SetOfVessels> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_EFFORT_DESCRIPTION = "effortDescription";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_CREW_FOOD_COST_ENABLED = "fieldEffortDescriptionCrewFoodCost.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_CREW_FOOD_COST_TEXT = "fieldEffortDescriptionCrewFoodCost.text";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_CREW_SHARE_RATE_ENABLED = "fieldEffortDescriptionCrewShareRate.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_CREW_SHARE_RATE_TEXT = "fieldEffortDescriptionCrewShareRate.text";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_CREW_SIZE_ENABLED = "fieldEffortDescriptionCrewSize.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_CREW_SIZE_TEXT = "fieldEffortDescriptionCrewSize.text";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_EFFORT_DESCRIPTION_LIST_ENABLED = "fieldEffortDescriptionEffortDescriptionList.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_FISHING_OPERATION_DURATION_ENABLED = "fieldEffortDescriptionFishingOperationDuration.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_FISHING_OPERATION_DURATION_TEXT = "fieldEffortDescriptionFishingOperationDuration.text";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_FISHING_OPERATION_ENABLED = "fieldEffortDescriptionFishingOperation.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_FISHING_OPERATION_TEXT = "fieldEffortDescriptionFishingOperation.text";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_FIXED_CREW_SALARY_ENABLED = "fieldEffortDescriptionFixedCrewSalary.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_FIXED_CREW_SALARY_TEXT = "fieldEffortDescriptionFixedCrewSalary.text";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_GEARS_NUMBER_PER_OPERATION_ENABLED = "fieldEffortDescriptionGearsNumberPerOperation.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_GEARS_NUMBER_PER_OPERATION_TEXT = "fieldEffortDescriptionGearsNumberPerOperation.text";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_LANDING_COSTS_ENABLED = "fieldEffortDescriptionLandingCosts.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_LANDING_COSTS_TEXT = "fieldEffortDescriptionLandingCosts.text";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_OTHER_RUNNING_COST_ENABLED = "fieldEffortDescriptionOtherRunningCost.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_OTHER_RUNNING_COST_TEXT = "fieldEffortDescriptionOtherRunningCost.text";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_REPAIR_AND_MAINTENANCE_GEAR_COST_ENABLED = "fieldEffortDescriptionRepairAndMaintenanceGearCost.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_REPAIR_AND_MAINTENANCE_GEAR_COST_TEXT = "fieldEffortDescriptionRepairAndMaintenanceGearCost.text";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_UNIT_COST_OF_FISHING_ENABLED = "fieldEffortDescriptionUnitCostOfFishing.enabled";
    public static final String BINDING_FIELD_EFFORT_DESCRIPTION_UNIT_COST_OF_FISHING_TEXT = "fieldEffortDescriptionUnitCostOfFishing.text";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_VALIDATOR_EFFORT_BEAN = "validatorEffort.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL10_ENABLED = "$JLabel10.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";
    private static final String BINDING_$JLABEL5_ENABLED = "$JLabel5.enabled";
    private static final String BINDING_$JLABEL6_ENABLED = "$JLabel6.enabled";
    private static final String BINDING_$JLABEL7_ENABLED = "$JLabel7.enabled";
    private static final String BINDING_$JLABEL8_ENABLED = "$JLabel8.enabled";
    private static final String BINDING_$JLABEL9_ENABLED = "$JLabel9.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWTW8bRRjHJyYvTdNASyAEaGloTUsprNNQmtBEIW2CaSLnRXYSRbWQGHvH8YT17jIzm2xAQly4Ah8B7lyQuPWEOHDmwAXxFRDiwBXxzNrezSab8YjJwXZm5vk9//nPyzPf/4kGOEOv7uMwtFjgCtoi1uqD3d2N2j6pi2XC64z6wmOo/deXQ7kqGrHjdi7Q9WpJhhc64YUlr+V7LnGPRc+V0HkujhzCm4QIga6kI+qcFypx91zoB6xLjUVlUb/9+6/cN/YX3+UQCn1Ql4epTPaKSmbSX0I5agv0LGQ6wAUHu3sgg1F3D/SOyrYlB3O+jlvkE/Q5GiqhQR8zgAl0TX/KESOKD32BLuZXXD8QS54rYPj2ypRA9xvMog1GWgS+OeUNyptWQC0qB1rvNxoei7nUczcxA0GCML694vsReVCg/hrBrkC3sliQiApKuFUhYqOxQzgnDk9CL5GTKQSylJxTmhLY8AF2qI3BAIFup5Yi7rD4IVhsVeTnTrcxITwTD2ynkc3PJd0j9SasE1nzbOII9LrSu6Vk6HGnPPsIFl2ub9jRsrqJ3eNjhvJbuOYQWJyJ1Bzao6M+OfKlOGA0v1qpM89xJAjCXkjRky45/EocdbtBiWOfcvNUQ4ly2HOXUkzZJjGTJ0Xfkf9eTSc6l18t4Rpxpk7OO2qVg27EY29kiyqCsxCy4ROG23vkaopU9FgLC0HsLRKKokSksV0Jkbw30n2WXsrloJt6PJW6R8bpjIxvZWf8gGDG14NWjbBNwuLEMmg6DeiYPa0w++0470zc90p23iVGDiv0UxInmjlFu5tBu5lN23YpXDAcznrHQQX2nQzsa2ctR0jsSCl2MDtSQO9lQK+dPfOi59lSr4I4k0G8rvCyCfd0GQuVobMZyOlsZJn4mLIHrr2Gqby3sVsncqv0EP2uvg0l7NqwUBLIM4jD3cMzlYE848BuiCZh5cB1O9wMbD/HB0SgsdRpehgI0d7yyZYerMspRxdFtdPD0MupqxFquJXU8KTI9lXRAAugGe7S6umyX4audsGfOFHwJTDq/Xd87Lcnf/xY7Fb5Wcj9fObQY48UqL4+8+AAy4IFRaVd4gNBncIa9ueqaBiKILxwohfM5QxhlU43iIN80d1ryXDrEeZNQAwM/f7Tz+Mf/foUyhXRecfDdhHL8StoWDQZuOA5dui/txgpunB4Dj4vSm1wdbQrGDw8np6HOocnazRa/IUQXLic4UIspTb8yz9jlR8Wu070gbIXzxyeuDHwGA1S16EuiV48ncdM5gtnxOcksL3k0ZL1jOmT3xN+p17Wo8+9rKkORLVcdu+Hgfz6OFItf7W0IRdg5zll4tqEEaZg5TVYQ3B44dpWSdLBjLY3D5wy+bgwhA3WPGYrZ3azJ0U2f6Yg3NLQ0S+gjsIDYb69VSahmjNaCwRZ+L/MXqre1CJ8ZUxQaSjoa/jahKDScEdjdUaE5zlb1JePHYWY3qheluoRVNO5a2ypHkGl4Z6xD3qELxWEWeNZ3Dd2Uo+g0jBv7KQeQaVhwdgHPYJKw6KxD3oElYaHxj7oEVQalo190COoNBSNfdAjqDQ8MvZBj6DSsGrsgx5BpaFk7IMeQaVh3dgHPYJKw6axD3oElYaysQ96BJWGLWMf9AgqDTvGPugRVBp2jX3QI6g0PDb2QY+g0vChsQZJ+A9UXsq7qRgAAA==";
    private static final Log log = LogFactory.getLog(EffortDescriptionParametersUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SetOfVessels bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected EffortDescription effortDescription;
    protected JTextField fieldEffortDescriptionCrewFoodCost;
    protected JTextField fieldEffortDescriptionCrewShareRate;
    protected JTextField fieldEffortDescriptionCrewSize;
    protected JList fieldEffortDescriptionEffortDescriptionList;
    protected JFormattedTextField fieldEffortDescriptionFishingOperation;
    protected JTextField fieldEffortDescriptionFishingOperationDuration;
    protected JTextField fieldEffortDescriptionFixedCrewSalary;
    protected JTextField fieldEffortDescriptionGearsNumberPerOperation;
    protected JTextField fieldEffortDescriptionLandingCosts;
    protected JTextField fieldEffortDescriptionOtherRunningCost;
    protected JTextField fieldEffortDescriptionRepairAndMaintenanceGearCost;
    protected JTextField fieldEffortDescriptionUnitCostOfFishing;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<SetOfVessels> validator;
    @Validator( validatorId = "validatorEffort")
    protected SwingValidator<EffortDescription> validatorEffort;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EffortDescriptionParametersUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel10;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JLabel $JLabel9;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    setEffortDescription(null);
                }
                if (evt.getNewValue() != null) {
                    EffortDescriptionListModel model = new EffortDescriptionListModel();
                    // getBean().getPossibleMetiers() can be null at region creation
                    if (getBean() != null && getBean().getPossibleMetiers() != null) {
                        java.util.List<EffortDescription> effortDescriptions = new ArrayList<EffortDescription>(getBean().getPossibleMetiers());
                        model.setEffortDescriptions(effortDescriptions);
                    }
                    fieldEffortDescriptionEffortDescriptionList.setModel(model);
                }
            }
        });
        addPropertyChangeListener(PROPERTY_EFFORT_DESCRIPTION, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldEffortDescriptionFishingOperation.setText("");
                    fieldEffortDescriptionFishingOperationDuration.setText("");
                    fieldEffortDescriptionGearsNumberPerOperation.setText("");
                    fieldEffortDescriptionCrewSize.setText("");
                    fieldEffortDescriptionUnitCostOfFishing.setText("");
                    fieldEffortDescriptionFixedCrewSalary.setText("");
                    fieldEffortDescriptionCrewFoodCost.setText("");
                    fieldEffortDescriptionCrewShareRate.setText("");
                    fieldEffortDescriptionRepairAndMaintenanceGearCost.setText("");
                    fieldEffortDescriptionLandingCosts.setText("");
                    fieldEffortDescriptionOtherRunningCost.setText("");
                }
                if (evt.getNewValue() != null) {
                    // FIX non working binding in jaxx 2.4.1
                    if (getEffortDescription().getFishingOperationDuration() == null) {
                        fieldEffortDescriptionFishingOperationDuration.setText("");
                    }
                }
            }
        });
    }
    
    @Override
    public void resetChangeModel() {
        changeModel.setStayChanged(false);
    }
    
    /*public void refresh() {
        SetOfVessels setOfVessels = getSaveVerifier().getEntity(SetOfVessels.class);
    
        // twice event for jaxx bindings detection
        setBean(null);
        setBean(setOfVessels);
    }*/
    
    protected void effortDescriptionSelectionChanged() {
        EffortDescription selectedEffort = (EffortDescription)fieldEffortDescriptionEffortDescriptionList.getSelectedValue();
        setEffortDescription(selectedEffort);
    
        if (getEffortDescription() != null) {
            getSaveVerifier().addCurrentEntity(getEffortDescription());
            selectedEffort.addPropertyChangeListener(new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent evt) {
                    changeModel.setStayChanged(true);
                }        
            });
    
            /* NumberEditor is not working
            fieldEffortDescriptionFishingOperation.init();
            fieldEffortDescriptionGearsNumberPerOperation.init();
            fieldEffortDescriptionCrewSize.init();
            fieldEffortDescriptionUnitCostOfFishing.init();
            fieldEffortDescriptionFixedCrewSalary.init();
            fieldEffortDescriptionCrewFoodCost.init();
            fieldEffortDescriptionCrewShareRate.init();
            fieldEffortDescriptionRepairAndMaintenanceGearCost.init();
            fieldEffortDescriptionLandingCosts.init();
            fieldEffortDescriptionOtherRunningCost.init();*/
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EffortDescriptionParametersUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EffortDescriptionParametersUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EffortDescriptionParametersUI() {
        $initialize();
    }

    public EffortDescriptionParametersUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public EffortDescriptionParametersUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EffortDescriptionParametersUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EffortDescriptionParametersUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EffortDescriptionParametersUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);validatorEffort.setChanged(false);changeModel.setStayChanged(false);
    }

    public void doKeyReleased__on__fieldEffortDescriptionCrewFoodCost(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setCrewFoodCost(Double.parseDouble(fieldEffortDescriptionCrewFoodCost.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionCrewShareRate(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setCrewShareRate(Double.parseDouble(fieldEffortDescriptionCrewShareRate.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionCrewSize(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setCrewSize(Integer.parseInt(fieldEffortDescriptionCrewSize.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionFishingOperation(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setFishingOperation(Integer.parseInt(fieldEffortDescriptionFishingOperation.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionFishingOperationDuration(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setFishingOperationDuration(new TimeUnit(3600 * Double.parseDouble(fieldEffortDescriptionFishingOperationDuration.getText())));
    }

    public void doKeyReleased__on__fieldEffortDescriptionFixedCrewSalary(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setFixedCrewSalary(Double.parseDouble(fieldEffortDescriptionFixedCrewSalary.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionGearsNumberPerOperation(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setGearsNumberPerOperation(Integer.parseInt(fieldEffortDescriptionGearsNumberPerOperation.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionLandingCosts(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setLandingCosts(Double.parseDouble(fieldEffortDescriptionLandingCosts.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionOtherRunningCost(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setOtherRunningCost(Double.parseDouble(fieldEffortDescriptionOtherRunningCost.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionRepairAndMaintenanceGearCost(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setRepairAndMaintenanceGearCost(Double.parseDouble(fieldEffortDescriptionRepairAndMaintenanceGearCost.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionUnitCostOfFishing(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getEffortDescription().setUnitCostOfFishing(Double.parseDouble(fieldEffortDescriptionUnitCostOfFishing.getText()));
    }

    public void doValueChanged__on__fieldEffortDescriptionEffortDescriptionList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        effortDescriptionSelectionChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVessels getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public EffortDescription getEffortDescription() {
        return effortDescription;
    }

    public JTextField getFieldEffortDescriptionCrewFoodCost() {
        return fieldEffortDescriptionCrewFoodCost;
    }

    public JTextField getFieldEffortDescriptionCrewShareRate() {
        return fieldEffortDescriptionCrewShareRate;
    }

    public JTextField getFieldEffortDescriptionCrewSize() {
        return fieldEffortDescriptionCrewSize;
    }

    public JList getFieldEffortDescriptionEffortDescriptionList() {
        return fieldEffortDescriptionEffortDescriptionList;
    }

    public JFormattedTextField getFieldEffortDescriptionFishingOperation() {
        return fieldEffortDescriptionFishingOperation;
    }

    public JTextField getFieldEffortDescriptionFishingOperationDuration() {
        return fieldEffortDescriptionFishingOperationDuration;
    }

    public JTextField getFieldEffortDescriptionFixedCrewSalary() {
        return fieldEffortDescriptionFixedCrewSalary;
    }

    public JTextField getFieldEffortDescriptionGearsNumberPerOperation() {
        return fieldEffortDescriptionGearsNumberPerOperation;
    }

    public JTextField getFieldEffortDescriptionLandingCosts() {
        return fieldEffortDescriptionLandingCosts;
    }

    public JTextField getFieldEffortDescriptionOtherRunningCost() {
        return fieldEffortDescriptionOtherRunningCost;
    }

    public JTextField getFieldEffortDescriptionRepairAndMaintenanceGearCost() {
        return fieldEffortDescriptionRepairAndMaintenanceGearCost;
    }

    public JTextField getFieldEffortDescriptionUnitCostOfFishing() {
        return fieldEffortDescriptionUnitCostOfFishing;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<SetOfVessels> getValidator() {
        return validator;
    }

    public SwingValidator<EffortDescription> getValidatorEffort() {
        return validatorEffort;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(SetOfVessels bean) {
        SetOfVessels oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setEffortDescription(EffortDescription effortDescription) {
        EffortDescription oldValue = this.effortDescription;
        this.effortDescription = effortDescription;
        firePropertyChange(PROPERTY_EFFORT_DESCRIPTION, oldValue, effortDescription);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidatorEffort() {
        if (!allComponentsCreated) {
            return;
        }
        validatorEffort.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createEffortDescription() {
        $objectMap.put("effortDescription", effortDescription = null);
    }

    protected void createFieldEffortDescriptionCrewFoodCost() {
        $objectMap.put("fieldEffortDescriptionCrewFoodCost", fieldEffortDescriptionCrewFoodCost = new JTextField());
        
        fieldEffortDescriptionCrewFoodCost.setName("fieldEffortDescriptionCrewFoodCost");
        fieldEffortDescriptionCrewFoodCost.setColumns(15);
        fieldEffortDescriptionCrewFoodCost.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionCrewFoodCost"));
        fieldEffortDescriptionCrewFoodCost.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionCrewFoodCost.putClientProperty("sensitivityMethod", "CrewFoodCost");
    }

    protected void createFieldEffortDescriptionCrewShareRate() {
        $objectMap.put("fieldEffortDescriptionCrewShareRate", fieldEffortDescriptionCrewShareRate = new JTextField());
        
        fieldEffortDescriptionCrewShareRate.setName("fieldEffortDescriptionCrewShareRate");
        fieldEffortDescriptionCrewShareRate.setColumns(15);
        fieldEffortDescriptionCrewShareRate.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionCrewShareRate"));
        fieldEffortDescriptionCrewShareRate.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionCrewShareRate.putClientProperty("sensitivityMethod", "CrewShareRate");
    }

    protected void createFieldEffortDescriptionCrewSize() {
        $objectMap.put("fieldEffortDescriptionCrewSize", fieldEffortDescriptionCrewSize = new JTextField());
        
        fieldEffortDescriptionCrewSize.setName("fieldEffortDescriptionCrewSize");
        fieldEffortDescriptionCrewSize.setColumns(15);
        fieldEffortDescriptionCrewSize.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionCrewSize"));
        fieldEffortDescriptionCrewSize.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionCrewSize.putClientProperty("sensitivityMethod", "CrewSize");
    }

    protected void createFieldEffortDescriptionEffortDescriptionList() {
        $objectMap.put("fieldEffortDescriptionEffortDescriptionList", fieldEffortDescriptionEffortDescriptionList = new JList());
        
        fieldEffortDescriptionEffortDescriptionList.setName("fieldEffortDescriptionEffortDescriptionList");
        fieldEffortDescriptionEffortDescriptionList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fieldEffortDescriptionEffortDescriptionList"));
    }

    protected void createFieldEffortDescriptionFishingOperation() {
        $objectMap.put("fieldEffortDescriptionFishingOperation", fieldEffortDescriptionFishingOperation = new JFormattedTextField());
        
        fieldEffortDescriptionFishingOperation.setName("fieldEffortDescriptionFishingOperation");
        fieldEffortDescriptionFishingOperation.setColumns(15);
        fieldEffortDescriptionFishingOperation.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionFishingOperation"));
        fieldEffortDescriptionFishingOperation.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionFishingOperation.putClientProperty("sensitivityMethod", "FishingOperation");
    }

    protected void createFieldEffortDescriptionFishingOperationDuration() {
        $objectMap.put("fieldEffortDescriptionFishingOperationDuration", fieldEffortDescriptionFishingOperationDuration = new JTextField());
        
        fieldEffortDescriptionFishingOperationDuration.setName("fieldEffortDescriptionFishingOperationDuration");
        fieldEffortDescriptionFishingOperationDuration.setColumns(15);
        fieldEffortDescriptionFishingOperationDuration.setToolTipText(t("isisfish.effortDescription.fishingOperationDuration.tooltip"));
        fieldEffortDescriptionFishingOperationDuration.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionFishingOperationDuration"));
        fieldEffortDescriptionFishingOperationDuration.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionFishingOperationDuration.putClientProperty("sensitivityMethod", "FishingOperationDuration");
    }

    protected void createFieldEffortDescriptionFixedCrewSalary() {
        $objectMap.put("fieldEffortDescriptionFixedCrewSalary", fieldEffortDescriptionFixedCrewSalary = new JTextField());
        
        fieldEffortDescriptionFixedCrewSalary.setName("fieldEffortDescriptionFixedCrewSalary");
        fieldEffortDescriptionFixedCrewSalary.setColumns(15);
        fieldEffortDescriptionFixedCrewSalary.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionFixedCrewSalary"));
        fieldEffortDescriptionFixedCrewSalary.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionFixedCrewSalary.putClientProperty("sensitivityMethod", "FixedCrewSalary");
    }

    protected void createFieldEffortDescriptionGearsNumberPerOperation() {
        $objectMap.put("fieldEffortDescriptionGearsNumberPerOperation", fieldEffortDescriptionGearsNumberPerOperation = new JTextField());
        
        fieldEffortDescriptionGearsNumberPerOperation.setName("fieldEffortDescriptionGearsNumberPerOperation");
        fieldEffortDescriptionGearsNumberPerOperation.setColumns(15);
        fieldEffortDescriptionGearsNumberPerOperation.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionGearsNumberPerOperation"));
        fieldEffortDescriptionGearsNumberPerOperation.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionGearsNumberPerOperation.putClientProperty("sensitivityMethod", "GearsNumberPerOperation");
    }

    protected void createFieldEffortDescriptionLandingCosts() {
        $objectMap.put("fieldEffortDescriptionLandingCosts", fieldEffortDescriptionLandingCosts = new JTextField());
        
        fieldEffortDescriptionLandingCosts.setName("fieldEffortDescriptionLandingCosts");
        fieldEffortDescriptionLandingCosts.setColumns(15);
        fieldEffortDescriptionLandingCosts.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionLandingCosts"));
        fieldEffortDescriptionLandingCosts.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionLandingCosts.putClientProperty("sensitivityMethod", "LandingCosts");
    }

    protected void createFieldEffortDescriptionOtherRunningCost() {
        $objectMap.put("fieldEffortDescriptionOtherRunningCost", fieldEffortDescriptionOtherRunningCost = new JTextField());
        
        fieldEffortDescriptionOtherRunningCost.setName("fieldEffortDescriptionOtherRunningCost");
        fieldEffortDescriptionOtherRunningCost.setColumns(15);
        fieldEffortDescriptionOtherRunningCost.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionOtherRunningCost"));
        fieldEffortDescriptionOtherRunningCost.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionOtherRunningCost.putClientProperty("sensitivityMethod", "OtherRunningCost");
    }

    protected void createFieldEffortDescriptionRepairAndMaintenanceGearCost() {
        $objectMap.put("fieldEffortDescriptionRepairAndMaintenanceGearCost", fieldEffortDescriptionRepairAndMaintenanceGearCost = new JTextField());
        
        fieldEffortDescriptionRepairAndMaintenanceGearCost.setName("fieldEffortDescriptionRepairAndMaintenanceGearCost");
        fieldEffortDescriptionRepairAndMaintenanceGearCost.setColumns(15);
        fieldEffortDescriptionRepairAndMaintenanceGearCost.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionRepairAndMaintenanceGearCost"));
        fieldEffortDescriptionRepairAndMaintenanceGearCost.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionRepairAndMaintenanceGearCost.putClientProperty("sensitivityMethod", "RepairAndMaintenanceGearCost");
    }

    protected void createFieldEffortDescriptionUnitCostOfFishing() {
        $objectMap.put("fieldEffortDescriptionUnitCostOfFishing", fieldEffortDescriptionUnitCostOfFishing = new JTextField());
        
        fieldEffortDescriptionUnitCostOfFishing.setName("fieldEffortDescriptionUnitCostOfFishing");
        fieldEffortDescriptionUnitCostOfFishing.setColumns(15);
        fieldEffortDescriptionUnitCostOfFishing.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldEffortDescriptionUnitCostOfFishing"));
        fieldEffortDescriptionUnitCostOfFishing.putClientProperty("sensitivityBean", EffortDescription.class);
        fieldEffortDescriptionUnitCostOfFishing.putClientProperty("sensitivityMethod", "UnitCostOfFishing");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SetOfVessels.class, "effortdescriptionparameters"));
    }

    protected void createValidatorEffort() {
        $objectMap.put("validatorEffort", validatorEffort = SwingValidator.newValidator(EffortDescription.class, "setofvessels"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToValidatorEffort();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 0, 1, 3, 0.4, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(1, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(1, 2, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(2, 2, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldEffortDescriptionEffortDescriptionList);
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionFishingOperation), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionFishingOperationDuration), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionGearsNumberPerOperation), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionCrewSize), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionUnitCostOfFishing), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionFixedCrewSalary), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel6, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionCrewFoodCost), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel7, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionCrewShareRate), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel8, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionRepairAndMaintenanceGearCost), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel9, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionLandingCosts), new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel10, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 12, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionOtherRunningCost), new GridBagConstraints(1, 7, 1, 1, 1.0, 1.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 40 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        fieldEffortDescriptionEffortDescriptionList.setCellRenderer(new EffortDescriptionListRenderer());
        fieldEffortDescriptionEffortDescriptionList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        $Table1.setBorder(BorderFactory.createTitledBorder(t("isisfish.effortDescription.effortTitle")));
        $Table2.setBorder(BorderFactory.createTitledBorder(t("isisfish.effortDescription.economicTitle")));
        // late initializer
        // register 2 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createEffortDescription();
        createValidator();
        createValidatorEffort();
        createChangeModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldEffortDescriptionEffortDescriptionList();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.effortDescription.fishingOperation"));
        createFieldEffortDescriptionFishingOperation();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.effortDescription.fishingOperationDuration"));
        createFieldEffortDescriptionFishingOperationDuration();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.effortDescription.gearsNumberPerOperation"));
        createFieldEffortDescriptionGearsNumberPerOperation();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.effortDescription.crewSize"));
        createFieldEffortDescriptionCrewSize();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.effortDescription.unitCostOfFishing"));
        createFieldEffortDescriptionUnitCostOfFishing();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("isisfish.effortDescription.fixedCrewSalary"));
        createFieldEffortDescriptionFixedCrewSalary();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(t("isisfish.effortDescription.crewFoodCost"));
        createFieldEffortDescriptionCrewFoodCost();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(t("isisfish.effortDescription.crewShareRate"));
        createFieldEffortDescriptionCrewShareRate();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(t("isisfish.effortDescription.repairAndMaintenanceGearCost"));
        createFieldEffortDescriptionRepairAndMaintenanceGearCost();
        // inline creation of $JLabel9
        $objectMap.put("$JLabel9", $JLabel9 = new JLabel());
        
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(t("isisfish.effortDescription.landingCosts"));
        createFieldEffortDescriptionLandingCosts();
        // inline creation of $JLabel10
        $objectMap.put("$JLabel10", $JLabel10 = new JLabel());
        
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(t("isisfish.effortDescription.otherRunningCost"));
        createFieldEffortDescriptionOtherRunningCost();
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 40 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 40 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_EFFORT_BEAN, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                validatorEffort.setBean(getEffortDescription());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                if (validatorEffort != null) {
                    validatorEffort.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorEffort != null) {
                    changeModel.setChanged(validator.isChanged() || validatorEffort.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                if (validatorEffort != null) {
                    validatorEffort.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validatorEffort != null) {
                    validatorEffort.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorEffort != null) {
                    changeModel.setValid(validator.isValid() && validatorEffort.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validatorEffort != null) {
                    validatorEffort.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_EFFORT_DESCRIPTION_LIST_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionEffortDescriptionList.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_FISHING_OPERATION_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionFishingOperation.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_FISHING_OPERATION_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("fishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null) {
                    SwingUtil.setText(fieldEffortDescriptionFishingOperation, String.valueOf(getEffortDescription().getFishingOperation()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("fishingOperation", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_FISHING_OPERATION_DURATION_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionFishingOperationDuration.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_FISHING_OPERATION_DURATION_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("fishingOperationDuration", this);
                }
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("fishingOperationDuration", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null && getEffortDescription().getFishingOperationDuration() != null) {
                    SwingUtil.setText(fieldEffortDescriptionFishingOperationDuration, String.valueOf(getEffortDescription().getFishingOperationDuration() == null ? "" : getEffortDescription().getFishingOperationDuration().getHour()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("fishingOperationDuration", this);
                }
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("fishingOperationDuration", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_GEARS_NUMBER_PER_OPERATION_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionGearsNumberPerOperation.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_GEARS_NUMBER_PER_OPERATION_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("gearsNumberPerOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null) {
                    SwingUtil.setText(fieldEffortDescriptionGearsNumberPerOperation, String.valueOf(getEffortDescription().getGearsNumberPerOperation()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("gearsNumberPerOperation", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_CREW_SIZE_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionCrewSize.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_CREW_SIZE_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("crewSize", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null) {
                    SwingUtil.setText(fieldEffortDescriptionCrewSize, String.valueOf(getEffortDescription().getCrewSize()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("crewSize", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_UNIT_COST_OF_FISHING_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionUnitCostOfFishing.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_UNIT_COST_OF_FISHING_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("unitCostOfFishing", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null) {
                    SwingUtil.setText(fieldEffortDescriptionUnitCostOfFishing, String.valueOf(getEffortDescription().getUnitCostOfFishing()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("unitCostOfFishing", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_FIXED_CREW_SALARY_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionFixedCrewSalary.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_FIXED_CREW_SALARY_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("fixedCrewSalary", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null) {
                    SwingUtil.setText(fieldEffortDescriptionFixedCrewSalary, String.valueOf(getEffortDescription().getFixedCrewSalary()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("fixedCrewSalary", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL6_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel6.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_CREW_FOOD_COST_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionCrewFoodCost.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_CREW_FOOD_COST_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("crewFoodCost", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null) {
                    SwingUtil.setText(fieldEffortDescriptionCrewFoodCost, String.valueOf(getEffortDescription().getCrewFoodCost()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("crewFoodCost", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL7_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel7.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_CREW_SHARE_RATE_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionCrewShareRate.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_CREW_SHARE_RATE_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("crewShareRate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null) {
                    SwingUtil.setText(fieldEffortDescriptionCrewShareRate, String.valueOf(getEffortDescription().getCrewShareRate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("crewShareRate", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL8_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel8.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_REPAIR_AND_MAINTENANCE_GEAR_COST_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionRepairAndMaintenanceGearCost.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_REPAIR_AND_MAINTENANCE_GEAR_COST_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("repairAndMaintenanceGearCost", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null) {
                    SwingUtil.setText(fieldEffortDescriptionRepairAndMaintenanceGearCost, String.valueOf(getEffortDescription().getRepairAndMaintenanceGearCost()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("repairAndMaintenanceGearCost", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL9_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel9.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_LANDING_COSTS_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionLandingCosts.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_LANDING_COSTS_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("landingCosts", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null) {
                    SwingUtil.setText(fieldEffortDescriptionLandingCosts, String.valueOf(getEffortDescription().getLandingCosts()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("landingCosts", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL10_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                $JLabel10.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_OTHER_RUNNING_COST_ENABLED, true ,"effortDescription") {
        
            @Override
            public void processDataBinding() {
                fieldEffortDescriptionOtherRunningCost.setEnabled(getEffortDescription() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_EFFORT_DESCRIPTION_OTHER_RUNNING_COST_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().addPropertyChangeListener("otherRunningCost", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEffortDescription() != null) {
                    SwingUtil.setText(fieldEffortDescriptionOtherRunningCost, String.valueOf(getEffortDescription().getOtherRunningCost()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("effortDescription", this);
                if (getEffortDescription() != null) {
                    getEffortDescription().removePropertyChangeListener("otherRunningCost", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}