/*
 * #%L
 * $Id: RConfigHandler.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL: https://svn.codelutin.com/isis-fish/tags/isis-fish-4.3.0.0/src/main/java/fr/ifremer/isisfish/ui/config/RConfigHandler.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.config;

import static org.nuiton.i18n.I18n.t;

import java.awt.Color;
import java.io.File;

import javax.swing.JOptionPane;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.RProxy;

/**
 * Handler for R Configuration UI.
 * 
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (Thu, 17 Apr 2014) $
 * By : $Author: echatellier $
 */
public class RConfigHandler {

    private static Log log = LogFactory.getLog(RConfigHandler.class);

    /**
     * Initialise l'ui.
     * 
     * @param rconfigUI ui to init
     */
    public void init(RConfigUI rconfigUI) {
        String rHome = System.getenv("R_HOME");
        rconfigUI.getRHomeField().setText(rHome);
        if (StringUtils.isBlank(rHome)) {
            rconfigUI.getRHomeField().setBackground(Color.RED);
        }
        
        String rType = System.getProperty("R.type");
        rconfigUI.getRTypeField().setText(rType);
        if (!"net".equals(rType) && !"jni".equals(rType)) {
            rconfigUI.getRTypeField().setBackground(Color.RED);
        }
        
        // sur windows c'est potentielement ca
        // sur linux, c'est pas possible
        String systemPath = System.getenv("PATH");
        String rBinPath = rHome + File.separator + "bin";
        if (systemPath.contains(rBinPath)) {
            rconfigUI.getSystemPathField().setText(t("isisfish.simulator.configuration.r.systempathok", rBinPath));
        }
        else {
            rconfigUI.getSystemPathField().setBackground(Color.RED);
            rconfigUI.getSystemPathField().setText(t("isisfish.simulator.configuration.r.systempathnok", rBinPath));
        }
        rconfigUI.getSystemPathField().setToolTipText(systemPath);
    }

    /**
     * Test r configuration.
     * 
     * @param rconfigUI
     */
    public void testRCOnfiguration(RConfigUI rconfigUI) {
        REngine engine = null;
        try {
            engine = new RProxy();
            
            boolean error = false;
            try {
                engine.eval("library('lhs')");
            }
            catch (RException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Can find 'lhs'", ex);
                }
                JOptionPane.showMessageDialog(rconfigUI, t("isisfish.simulator.configuration.r.lhsnotinstalled"),
                        t("isisfish.simulator.configuration.r.title"), JOptionPane.ERROR_MESSAGE);
                error = true;
            }
            try {
                engine.eval("library('sensitivity')");
            }
            catch (RException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Can find 'sensitivity'", ex);
                }
                JOptionPane.showMessageDialog(rconfigUI, t("isisfish.simulator.configuration.r.sensitivitynotinstalled"),
                        t("isisfish.simulator.configuration.r.title"), JOptionPane.ERROR_MESSAGE);
                error = true;
            }
            
            if (!error) {
                JOptionPane.showMessageDialog(rconfigUI, t("isisfish.simulator.configuration.r.testok"),
                        t("isisfish.simulator.configuration.r.title"), JOptionPane.INFORMATION_MESSAGE);
            }
        }
        catch (RException ex) {
            if (log.isWarnEnabled()) {
                log.warn("Can find call R", ex);
            }
            JOptionPane.showMessageDialog(rconfigUI, t("isisfish.simulator.configuration.r.cantinit", ex.getMessage()),
                    t("isisfish.simulator.configuration.r.title"), JOptionPane.ERROR_MESSAGE);
        }
    }
}
