package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Mon Jun 02 15:09:02 CEST 2014")
public abstract class VesselTypeDAOAbstract<E extends VesselType> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)VesselType.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.VesselType;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<SetOfVessels> list = getContext()
                                                    .getDAO(SetOfVessels.class)
                                                    .findAllByProperties(SetOfVessels.PROPERTY_VESSEL_TYPE, entity);
                                            for (SetOfVessels item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getVesselType())) {
                                                    item.setVesselType(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(VesselType.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.PROPERTY_NAME, v);
        return result;
    }

    public E findByLength(int v) throws TopiaException {
        E result = findByProperty(VesselType.PROPERTY_LENGTH, v);
        return result;
    }

    public List<E> findAllByLength(int v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.PROPERTY_LENGTH, v);
        return result;
    }

    public E findBySpeed(double v) throws TopiaException {
        E result = findByProperty(VesselType.PROPERTY_SPEED, v);
        return result;
    }

    public List<E> findAllBySpeed(double v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.PROPERTY_SPEED, v);
        return result;
    }

    public E findByMaxTripDuration(TimeUnit v) throws TopiaException {
        E result = findByProperty(VesselType.PROPERTY_MAX_TRIP_DURATION, v);
        return result;
    }

    public List<E> findAllByMaxTripDuration(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.PROPERTY_MAX_TRIP_DURATION, v);
        return result;
    }

    public E findByActivityRange(double v) throws TopiaException {
        E result = findByProperty(VesselType.PROPERTY_ACTIVITY_RANGE, v);
        return result;
    }

    public List<E> findAllByActivityRange(double v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.PROPERTY_ACTIVITY_RANGE, v);
        return result;
    }

    public E findByMinCrewSize(int v) throws TopiaException {
        E result = findByProperty(VesselType.PROPERTY_MIN_CREW_SIZE, v);
        return result;
    }

    public List<E> findAllByMinCrewSize(int v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.PROPERTY_MIN_CREW_SIZE, v);
        return result;
    }

    public E findByUnitFuelCostOfTravel(double v) throws TopiaException {
        E result = findByProperty(VesselType.PROPERTY_UNIT_FUEL_COST_OF_TRAVEL, v);
        return result;
    }

    public List<E> findAllByUnitFuelCostOfTravel(double v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.PROPERTY_UNIT_FUEL_COST_OF_TRAVEL, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(VesselType.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.PROPERTY_COMMENT, v);
        return result;
    }

    public E findContainsTripType(TripType v) throws TopiaException {
        E result = findContains(VesselType.PROPERTY_TRIP_TYPE, v);
        return result;
    }

    public List<E> findAllContainsTripType(TripType v) throws TopiaException {
        List<E> result = findAllContains(VesselType.PROPERTY_TRIP_TYPE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SetOfVessels.class) {
            SetOfVesselsDAO dao = (SetOfVesselsDAO)
                getContext().getDAO(SetOfVessels.class);
            tmp = dao.findAllByVesselType(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(SetOfVessels.class, entity);
        if (!list.isEmpty()) {
            result.put(SetOfVessels.class, list);
        }

        return result;
    }

} //VesselTypeDAOAbstract<E extends VesselType>
