package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Mon Jun 02 15:09:02 CEST 2014")
public abstract class PopulationSeasonInfoAbstract extends SeasonImpl implements PopulationSeasonInfo {

    /**
     * <p>Matrice repr&eacute;sentant la distribution de la reproduction sur les diff&eacute;rents mois de la saison.</p>
     * Nom de l'attribut en BD : reproductionDistribution
     */
    protected MatrixND reproductionDistribution;

    /**
     * <p>Si vrai alors la population change de groupe d'age ou de longueurs en debut de saison</p>
     * 
     * Nom de l'attribut en BD : groupChange
     */
    protected boolean groupChange;

    /**
     * <p>Indique si la matrice de changementde longeur est une matrice simple ou complexe</p>
     * 
     * Nom de l'attribut en BD : simpleLengthChangeMatrix
     */
    protected boolean simpleLengthChangeMatrix;

    /**
     * <p>La matrice de changement de longueur. Appliquable que si la MetaPopulation est en longueur. Cette matrice est [group x group] ou [ (group, zone) x ( group, zone)]</p>
     * <p></p>
     * Nom de l'attribut en BD : lengthChangeMatrix
     */
    protected MatrixND lengthChangeMatrix;

    /**
     * <p>Indique s'il y a de la reproduction durant la saison</p>
     * 
     * Nom de l'attribut en BD : reproduction
     */
    protected boolean reproduction;

    /**
     * Nom de l'attribut en BD : useEquationMigration
     */
    protected boolean useEquationMigration;

    /**
     * <p>Matrix [group x zone(left) x zone(reached)]</p>
     * Nom de l'attribut en BD : migrationMatrix
     */
    protected MatrixND migrationMatrix;

    /**
     * <p>Matrix [group x zone(left)]</p>
     * Nom de l'attribut en BD : emigrationMatrix
     */
    protected MatrixND emigrationMatrix;

    /**
     * <p>Matrix [group x zone(reached)]</p>
     * Nom de l'attribut en BD : immigrationMatrix
     */
    protected MatrixND immigrationMatrix;

    /**
     * Nom de l'attribut en BD : migrationEquation
     */
    protected Equation migrationEquation;

    /**
     * Nom de l'attribut en BD : emigrationEquation
     */
    protected Equation emigrationEquation;

    /**
     * Nom de l'attribut en BD : immigrationEquation
     */
    protected Equation immigrationEquation;

    /**
     * Nom de l'attribut en BD : population
     */
    protected Population population;

    private static final long serialVersionUID = 3702913498286810679L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PopulationSeasonInfo.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PopulationSeasonInfo.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_REPRODUCTION_DISTRIBUTION, MatrixND.class, reproductionDistribution);
        visitor.visit(this, PROPERTY_GROUP_CHANGE, boolean.class, groupChange);
        visitor.visit(this, PROPERTY_SIMPLE_LENGTH_CHANGE_MATRIX, boolean.class, simpleLengthChangeMatrix);
        visitor.visit(this, PROPERTY_LENGTH_CHANGE_MATRIX, MatrixND.class, lengthChangeMatrix);
        visitor.visit(this, PROPERTY_REPRODUCTION, boolean.class, reproduction);
        visitor.visit(this, PROPERTY_USE_EQUATION_MIGRATION, boolean.class, useEquationMigration);
        visitor.visit(this, PROPERTY_MIGRATION_MATRIX, MatrixND.class, migrationMatrix);
        visitor.visit(this, PROPERTY_EMIGRATION_MATRIX, MatrixND.class, emigrationMatrix);
        visitor.visit(this, PROPERTY_IMMIGRATION_MATRIX, MatrixND.class, immigrationMatrix);
        visitor.visit(this, PROPERTY_MIGRATION_EQUATION, Equation.class, migrationEquation);
        visitor.visit(this, PROPERTY_EMIGRATION_EQUATION, Equation.class, emigrationEquation);
        visitor.visit(this, PROPERTY_IMMIGRATION_EQUATION, Equation.class, immigrationEquation);
        visitor.visit(this, PROPERTY_POPULATION, Population.class, population);
        visitor.end(this);
    }

    @Override
    public void setReproductionDistribution(MatrixND reproductionDistribution) {
        MatrixND oldValue = this.reproductionDistribution;
        fireOnPreWrite(PROPERTY_REPRODUCTION_DISTRIBUTION, oldValue, reproductionDistribution);
        this.reproductionDistribution = reproductionDistribution;
        fireOnPostWrite(PROPERTY_REPRODUCTION_DISTRIBUTION, oldValue, reproductionDistribution);
    }

    @Override
    public MatrixND getReproductionDistribution() {
        MatrixND result = this.reproductionDistribution;

        return result;
    }

    @Override
    public void setGroupChange(boolean groupChange) {
        boolean oldValue = this.groupChange;
        fireOnPreWrite(PROPERTY_GROUP_CHANGE, oldValue, groupChange);
        this.groupChange = groupChange;
        fireOnPostWrite(PROPERTY_GROUP_CHANGE, oldValue, groupChange);
    }

    @Override
    public boolean isGroupChange() {
        boolean result = this.groupChange;

        return result;
    }

    @Override
    public boolean getGroupChange() {
        boolean result = this.groupChange;

        return result;
    }

    @Override
    public void setSimpleLengthChangeMatrix(boolean simpleLengthChangeMatrix) {
        boolean oldValue = this.simpleLengthChangeMatrix;
        fireOnPreWrite(PROPERTY_SIMPLE_LENGTH_CHANGE_MATRIX, oldValue, simpleLengthChangeMatrix);
        this.simpleLengthChangeMatrix = simpleLengthChangeMatrix;
        fireOnPostWrite(PROPERTY_SIMPLE_LENGTH_CHANGE_MATRIX, oldValue, simpleLengthChangeMatrix);
    }

    @Override
    public boolean isSimpleLengthChangeMatrix() {
        boolean result = this.simpleLengthChangeMatrix;

        return result;
    }

    @Override
    public boolean getSimpleLengthChangeMatrix() {
        boolean result = this.simpleLengthChangeMatrix;

        return result;
    }

    @Override
    public void setLengthChangeMatrix(MatrixND lengthChangeMatrix) {
        MatrixND oldValue = this.lengthChangeMatrix;
        fireOnPreWrite(PROPERTY_LENGTH_CHANGE_MATRIX, oldValue, lengthChangeMatrix);
        this.lengthChangeMatrix = lengthChangeMatrix;
        fireOnPostWrite(PROPERTY_LENGTH_CHANGE_MATRIX, oldValue, lengthChangeMatrix);
    }

    @Override
    public MatrixND getLengthChangeMatrix() {
        MatrixND result = this.lengthChangeMatrix;

        return result;
    }

    @Override
    public void setReproduction(boolean reproduction) {
        boolean oldValue = this.reproduction;
        fireOnPreWrite(PROPERTY_REPRODUCTION, oldValue, reproduction);
        this.reproduction = reproduction;
        fireOnPostWrite(PROPERTY_REPRODUCTION, oldValue, reproduction);
    }

    @Override
    public boolean isReproduction() {
        boolean result = this.reproduction;

        return result;
    }

    @Override
    public boolean getReproduction() {
        boolean result = this.reproduction;

        return result;
    }

    @Override
    public void setUseEquationMigration(boolean useEquationMigration) {
        boolean oldValue = this.useEquationMigration;
        fireOnPreWrite(PROPERTY_USE_EQUATION_MIGRATION, oldValue, useEquationMigration);
        this.useEquationMigration = useEquationMigration;
        fireOnPostWrite(PROPERTY_USE_EQUATION_MIGRATION, oldValue, useEquationMigration);
    }

    @Override
    public boolean isUseEquationMigration() {
        boolean result = this.useEquationMigration;

        return result;
    }

    @Override
    public boolean getUseEquationMigration() {
        boolean result = this.useEquationMigration;

        return result;
    }

    @Override
    public void setMigrationMatrix(MatrixND migrationMatrix) {
        MatrixND oldValue = this.migrationMatrix;
        fireOnPreWrite(PROPERTY_MIGRATION_MATRIX, oldValue, migrationMatrix);
        this.migrationMatrix = migrationMatrix;
        fireOnPostWrite(PROPERTY_MIGRATION_MATRIX, oldValue, migrationMatrix);
    }

    @Override
    public MatrixND getMigrationMatrix() {
        MatrixND result = this.migrationMatrix;

        return result;
    }

    @Override
    public void setEmigrationMatrix(MatrixND emigrationMatrix) {
        MatrixND oldValue = this.emigrationMatrix;
        fireOnPreWrite(PROPERTY_EMIGRATION_MATRIX, oldValue, emigrationMatrix);
        this.emigrationMatrix = emigrationMatrix;
        fireOnPostWrite(PROPERTY_EMIGRATION_MATRIX, oldValue, emigrationMatrix);
    }

    @Override
    public MatrixND getEmigrationMatrix() {
        MatrixND result = this.emigrationMatrix;

        return result;
    }

    @Override
    public void setImmigrationMatrix(MatrixND immigrationMatrix) {
        MatrixND oldValue = this.immigrationMatrix;
        fireOnPreWrite(PROPERTY_IMMIGRATION_MATRIX, oldValue, immigrationMatrix);
        this.immigrationMatrix = immigrationMatrix;
        fireOnPostWrite(PROPERTY_IMMIGRATION_MATRIX, oldValue, immigrationMatrix);
    }

    @Override
    public MatrixND getImmigrationMatrix() {
        MatrixND result = this.immigrationMatrix;

        return result;
    }

    @Override
    public void setMigrationEquation(Equation migrationEquation) {
        Equation oldValue = this.migrationEquation;
        fireOnPreWrite(PROPERTY_MIGRATION_EQUATION, oldValue, migrationEquation);
        this.migrationEquation = migrationEquation;
        fireOnPostWrite(PROPERTY_MIGRATION_EQUATION, oldValue, migrationEquation);
    }

    @Override
    public Equation getMigrationEquation() {
        Equation result = this.migrationEquation;

        return result;
    }

    @Override
    public void setEmigrationEquation(Equation emigrationEquation) {
        Equation oldValue = this.emigrationEquation;
        fireOnPreWrite(PROPERTY_EMIGRATION_EQUATION, oldValue, emigrationEquation);
        this.emigrationEquation = emigrationEquation;
        fireOnPostWrite(PROPERTY_EMIGRATION_EQUATION, oldValue, emigrationEquation);
    }

    @Override
    public Equation getEmigrationEquation() {
        Equation result = this.emigrationEquation;

        return result;
    }

    @Override
    public void setImmigrationEquation(Equation immigrationEquation) {
        Equation oldValue = this.immigrationEquation;
        fireOnPreWrite(PROPERTY_IMMIGRATION_EQUATION, oldValue, immigrationEquation);
        this.immigrationEquation = immigrationEquation;
        fireOnPostWrite(PROPERTY_IMMIGRATION_EQUATION, oldValue, immigrationEquation);
    }

    @Override
    public Equation getImmigrationEquation() {
        Equation result = this.immigrationEquation;

        return result;
    }

    @Override
    public void setPopulation(Population population) {
        Population oldValue = this.population;
        fireOnPreWrite(PROPERTY_POPULATION, oldValue, population);
        this.population = population;
        fireOnPostWrite(PROPERTY_POPULATION, oldValue, population);
    }

    @Override
    public Population getPopulation() {
        Population result = this.population;

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getMigrationEquation());
        tmp.add(getEmigrationEquation());
        tmp.add(getImmigrationEquation());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_REPRODUCTION_DISTRIBUTION, this.reproductionDistribution).
            append(PROPERTY_GROUP_CHANGE, this.groupChange).
            append(PROPERTY_SIMPLE_LENGTH_CHANGE_MATRIX, this.simpleLengthChangeMatrix).
            append(PROPERTY_LENGTH_CHANGE_MATRIX, this.lengthChangeMatrix).
            append(PROPERTY_REPRODUCTION, this.reproduction).
            append(PROPERTY_USE_EQUATION_MIGRATION, this.useEquationMigration).
            append(PROPERTY_MIGRATION_MATRIX, this.migrationMatrix).
            append(PROPERTY_EMIGRATION_MATRIX, this.emigrationMatrix).
            append(PROPERTY_IMMIGRATION_MATRIX, this.immigrationMatrix).
            append(PROPERTY_MIGRATION_EQUATION, this.migrationEquation).
            append(PROPERTY_EMIGRATION_EQUATION, this.emigrationEquation).
            append(PROPERTY_IMMIGRATION_EQUATION, this.immigrationEquation).
         toString();
        return result;
    }

} //PopulationSeasonInfoAbstract
