/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SensitivityUtils {
    private static final Log log = LogFactory.getLog(SensitivityUtils.class);
    protected static final String PROPERTIES_PATH = "/sensitivity.properties";
    protected static Properties sensitivityProperties;

    public static boolean isSensitivityFactorEnabled(String sensitivityFactorName) {
        Properties data = SensitivityUtils.getProperties();
        return data.getProperty(sensitivityFactorName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties() {
        if (sensitivityProperties == null) {
            sensitivityProperties = new Properties();
            InputStream stream = null;
            try {
                stream = SensitivityUtils.class.getResourceAsStream(PROPERTIES_PATH);
                sensitivityProperties.load(stream);
            }
            catch (IOException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't load sensitivity properties file", (Throwable)ex);
                }
            }
            finally {
                block15: {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!log.isErrorEnabled()) break block15;
                        log.error((Object)"Can't load sensitivity properties file", (Throwable)ex);
                    }
                }
            }
        }
        return sensitivityProperties;
    }
}

