/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script.action;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.ui.script.FileSelectionTableModel;
import fr.ifremer.isisfish.ui.util.IsisAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ZipUtil;

public class ExportAction
extends IsisAction {
    private static final long serialVersionUID = 3373564473968724365L;
    private static Log log = LogFactory.getLog(ExportAction.class);
    protected FileSelectionTableModel model;
    protected JTextField file;
    protected File root;
    private List<String> selected;
    private File dst;

    public ExportAction(JDialog dialog, JTextField file, File root, FileSelectionTableModel model) {
        super(dialog);
        this.file = file;
        this.root = root;
        this.model = model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean prepare() {
        this.dst = new File(this.file.getText());
        if ("".equals(this.dst.getAbsolutePath())) {
            return false;
        }
        if (this.dst.exists()) {
            int resp = JOptionPane.showConfirmDialog(this.dialog, I18n._((String)"isisfish.message.file.already.exists", (Object[])new Object[]{this.dst}));
            if (resp == 2) {
                this.dialog.dispose();
                return false;
            }
            if (resp != 0) return false;
            this.dst.getParentFile().mkdirs();
        } else if (!this.dst.getParentFile().exists()) {
            int resp = JOptionPane.showConfirmDialog(this.dialog, I18n._((String)"isisfish.message.directory.not.exists", (Object[])new Object[]{this.dst}));
            if (resp == 2) {
                this.dialog.dispose();
                return false;
            }
            if (resp != 0) return false;
            this.dst.getParentFile().mkdirs();
        }
        this.selected = this.model.getSelectedFiles();
        if (this.selected == null) return false;
        if (this.selected.isEmpty()) return false;
        return true;
    }

    @Override
    protected void perform(ActionEvent e) {
        try {
            ArrayList<File> toZip = new ArrayList<File>();
            for (String path : this.selected) {
                toZip.add(new File(this.root, path));
            }
            if (this.dst.exists()) {
                this.dst.delete();
            }
            this.dst.createNewFile();
            ZipUtil.compressFiles((File)this.dst, (File)this.root, toZip);
            if (log.isInfoEnabled()) {
                log.info((Object)("Zip DataStorage in " + this.dst + "[" + toZip.size() + " files] (size " + this.dst.length() + ")"));
            }
        }
        catch (IOException ex) {
            throw new IsisFishRuntimeException("Can't export script", ex);
        }
    }
}

