/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.queue;

import fr.ifremer.isisfish.logging.SimulationLoggerUtil;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.ui.queue.QueueUI;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class QueueAction {
    private static Log log = LogFactory.getLog(QueueAction.class);
    protected QueueUI queueUI;

    public QueueAction(QueueUI queueUI) {
        this.queueUI = queueUI;
    }

    public void updateActions() {
        this.queueUI.setCanStop(!this.queueUI.getSelectionModelQueueTable().isSelectionEmpty());
        this.queueUI.setCanShowLog(!this.queueUI.getSelectionModelQueueTableDone().isSelectionEmpty());
        this.queueUI.setCanClear(this.queueUI.getQueueTableDone().getModel().getRowCount() > 0);
        this.queueUI.setCanRestart(!this.queueUI.getSelectionModelQueueTableDone().isSelectionEmpty());
    }

    protected void stopSimulation() {
        int[] selectedRows = this.queueUI.getQueueTable().getSelectedRows();
        SimulationJob[] jobsToStop = new SimulationJob[selectedRows.length];
        int index = 0;
        for (int selectedRow : selectedRows) {
            jobsToStop[index++] = this.queueUI.getNewSimulationModel().getJob(selectedRow);
        }
        for (SimulationJob jobToStop : jobsToStop) {
            jobToStop.stop();
            if (!log.isInfoEnabled()) continue;
            log.info((Object)I18n._((String)"User stop simulation %s", (Object[])new Object[]{jobToStop.getItem().getControl().getId()}));
        }
    }

    protected void restartSimulation() {
        int[] selectedRows = this.queueUI.getQueueTableDone().getSelectedRows();
        SimulationJob[] jobsToRestart = new SimulationJob[selectedRows.length];
        int index = 0;
        for (int selectedRow : selectedRows) {
            jobsToRestart[index++] = this.queueUI.getDoneSimulationModel().getJob(selectedRow);
        }
        for (SimulationJob jobToRestart : jobsToRestart) {
            jobToRestart.restart();
            jobToRestart.getItem().getControl().setText(I18n._((String)"isisfish.simulation.restarting", (Object[])new Object[0]));
            if (!log.isInfoEnabled()) continue;
            log.info((Object)I18n._((String)"User restart simulation %s", (Object[])new Object[]{jobToRestart.getItem().getControl().getId()}));
        }
    }

    protected void viewLog() {
        if (this.queueUI.getQueueTableDone().getSelectedRow() >= 0) {
            SimulationJob selectedJob = this.queueUI.getDoneSimulationModel().getJob(this.queueUI.getQueueTableDone().getSelectedRow());
            String id = selectedJob.getItem().getControl().getId();
            try {
                SimulationLoggerUtil.showSimulationLogConsole(id);
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)I18n._((String)"Can't open log for %s", (Object[])new Object[]{id}), (Throwable)eee);
                }
                ErrorHelper.showErrorDialog(I18n._((String)"Can't open log for %s", (Object[])new Object[]{id}), eee);
            }
        }
    }

    protected void clearDoneJobs() {
        SimulationService ss = SimulationService.getService();
        ss.clearJobDone();
    }
}

