/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationQueue;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationExecutor
extends ThreadPoolExecutor {
    private static Log log = LogFactory.getLog(SimulationExecutor.class);
    protected PropertyChangeSupport propertyListeners = new PropertyChangeSupport(this);
    protected boolean pause = false;
    protected int lastCorePoolSize;
    protected SimulationService simulationService;
    protected SimulatorLauncher launcher;

    public SimulationExecutor(SimulationService simulationService, SimulatorLauncher launcher, SimulationQueue workQueue) {
        super(launcher.maxSimulationThread(), launcher.maxSimulationThread(), 0L, TimeUnit.MILLISECONDS, workQueue);
        this.simulationService = simulationService;
        this.launcher = launcher;
        this.lastCorePoolSize = this.prestartAllCoreThreads();
        log.info((Object)I18n._((String)"SimulationExecutor started with %s thread for %s", (Object[])new Object[]{this.lastCorePoolSize, launcher}));
    }

    public SimulationService getSimulationService() {
        return this.simulationService;
    }

    public SimulatorLauncher getLauncher() {
        return this.launcher;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyListeners.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyListeners.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.getSimulationService().waitAutoLaunch();
        if (this.isPause()) {
            if (r instanceof SimulationJob) {
                SimulationService.getService().resubmit((SimulationJob)r);
            }
            throw new RuntimeException(I18n._((String)"Normal stop thread, this is not an error", (Object[])new Object[0]));
        }
        if (r instanceof SimulationJob) {
            SimulationJob job = (SimulationJob)r;
            if (job.getLauncher() == null) {
                job.setLauncher(this.launcher);
            }
        } else {
            log.warn((Object)I18n._((String)"Jobs submited is not ItemSimulation but was %s", (Object[])new Object[]{r.getClass().getName()}));
        }
    }

    public boolean isPause() {
        return this.pause;
    }

    public void pause() {
        this.setPause(true);
    }

    public void resume() {
        this.setPause(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPause(boolean pause) {
        boolean oldValue = this.pause;
        SimulationExecutor simulationExecutor = this;
        synchronized (simulationExecutor) {
            this.pause = pause;
            if (this.pause) {
                this.lastCorePoolSize = this.getCorePoolSize();
                this.setCorePoolSize(0);
            } else {
                this.setCorePoolSize(this.lastCorePoolSize);
                this.prestartAllCoreThreads();
            }
        }
        this.propertyListeners.firePropertyChange("pause", oldValue, this.pause);
    }
}

