/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationMeta;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationProperties {
    private static final Log log = LogFactory.getLog(SimulationProperties.class);
    protected String name;
    protected Properties data;

    public SimulationProperties(String name) throws IOException {
        File simulationDirectory = SimulationStorage.getSimulationDirectory(name);
        this.name = simulationDirectory.getName();
        this.data = new Properties();
        this.data.put(SimulationMeta.simulationName.name(), this.name);
        this.loadProperties(SimulationStorage.getSimulationParametersFile(simulationDirectory));
        this.loadProperties(SimulationStorage.getSimulationInformationFile(simulationDirectory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(File file) {
        if (file.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                this.data.load(reader);
                this.data.remove("preScript");
            }
            catch (IOException e) {
                block5: {
                    try {
                        if (!log.isWarnEnabled()) break block5;
                        log.warn((Object)I18n._((String)"isisfish.error.load.file", (Object[])new Object[]{file}));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public Properties getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }
}

