/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.mexico.xml.AbstractXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.ContinuousDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.DiscreteDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.DomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.EquationContinuousDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.EquationDiscreteDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.MatrixContinuousDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.RuleDiscreteDomainXMLVisitor;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.RuleDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntity;

public class FactorXMLVisitor
extends AbstractXMLVisitor
implements FactorVisitor {
    @Override
    public void start(Factor factor) {
        this.xmlBuffer.append("<factor");
        this.xmlBuffer.append(" name=\"").append(factor.getName()).append("\"");
        Object referenceValueForType = null;
        Domain domain = factor.getDomain();
        if (domain instanceof ContinuousDomain) {
            if (domain instanceof MatrixContinuousDomain) {
                this.xmlBuffer.append(" property=\"matrixcontinuous\"");
            } else if (domain instanceof EquationContinuousDomain) {
                this.xmlBuffer.append(" property=\"equationcontinuous\"");
            } else {
                this.xmlBuffer.append(" property=\"continuous\"");
            }
            referenceValueForType = ((ContinuousDomain)domain).getReferenceValue();
            if (referenceValueForType == null) {
                referenceValueForType = ((ContinuousDomain)domain).getMinBound();
            }
        } else if (domain instanceof DiscreteDomain) {
            this.xmlBuffer.append(" property=\"discrete\"");
            Object firstKey = ((DiscreteDomain)domain).getValues().firstKey();
            referenceValueForType = ((DiscreteDomain)domain).getValues().get(firstKey);
        }
        if (referenceValueForType instanceof Double || referenceValueForType instanceof Float || referenceValueForType instanceof MatrixND) {
            this.xmlBuffer.append(" type=\"real\"");
        } else if (referenceValueForType instanceof Integer) {
            this.xmlBuffer.append(" type=\"integer\"");
        } else if (domain instanceof RuleDiscreteDomain) {
            this.xmlBuffer.append(" type=\"rule\"");
        } else if (domain instanceof EquationDiscreteDomain) {
            this.xmlBuffer.append(" type=\"equation\"");
        } else if (referenceValueForType instanceof TopiaEntity || referenceValueForType instanceof TimeStep || referenceValueForType instanceof Month) {
            this.xmlBuffer.append(" type=\"string\"");
        }
        this.xmlBuffer.append(" cardinality=\"");
        this.xmlBuffer.append(factor.getCardinality());
        this.xmlBuffer.append("\"");
        this.xmlBuffer.append(">");
        this.xmlBuffer.append("<target>").append(factor.getPath()).append("</target>");
    }

    @Override
    public void visit(Factor factor, Domain domain) {
        DomainXMLVisitor visitor = null;
        if (factor.getDomain() instanceof MatrixContinuousDomain) {
            visitor = new MatrixContinuousDomainXMLVisitor();
        } else if (factor.getDomain() instanceof EquationContinuousDomain) {
            visitor = new EquationContinuousDomainXMLVisitor();
        } else if (factor.getDomain() instanceof ContinuousDomain) {
            visitor = new ContinuousDomainXMLVisitor();
        } else if (factor.getDomain() instanceof RuleDiscreteDomain) {
            visitor = new RuleDiscreteDomainXMLVisitor();
        } else if (factor.getDomain() instanceof EquationDiscreteDomain) {
            visitor = new EquationDiscreteDomainXMLVisitor();
        } else if (factor.getDomain() instanceof DiscreteDomain) {
            visitor = new DiscreteDomainXMLVisitor();
        }
        domain.accept(visitor);
        this.xmlBuffer.append(visitor.getXML());
    }

    @Override
    public void end(Factor factor) {
        this.xmlBuffer.append("</factor>");
    }
}

