/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.MetierSeasonInfoAbstract;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.entities.Zone;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class MetierSeasonInfoImpl
extends MetierSeasonInfoAbstract {
    private static final long serialVersionUID = 4554500494092542926L;
    private static final Log log = LogFactory.getLog(MetierSeasonInfoImpl.class);

    @Override
    public double getTargetFactor(PopulationGroup group) {
        double result = 1.0;
        Species species = group.getPopulation().getSpecies();
        TargetSpecies targetSpecies = this.getSpeciesTargetSpecies(species);
        if (targetSpecies != null) {
            result = targetSpecies.getTargetFactor(group);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)I18n._((String)"isisfish.error.no.target.species", (Object[])new Object[]{this, group}));
        }
        return result;
    }

    @Override
    public List<Cell> getCells() {
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (Zone zone : this.getZone()) {
            result.addAll(zone.getCell());
        }
        return result;
    }

    @Override
    public String toString() {
        String result = I18n._((String)"isisfish.metierSeasonInfo.toString", (Object[])new Object[]{this.getMetier(), this.getFirstMonth(), this.getLastMonth()});
        return result;
    }
}

