/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import bsh.Interpreter;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.EquationAbstract;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import java.util.HashMap;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class EquationImpl
extends EquationAbstract {
    private static final long serialVersionUID = -2195404062556810283L;

    @Override
    public double evaluate(Map<String, Object> param) {
        String eq = this.getContent();
        try {
            param.put("context", SimulationContext.get());
            if ("BSH".equals(this.getLanguage()) || ("".equals(this.getLanguage()) || this.getLanguage() == null) && this.getJavaInterface() == null) {
                Interpreter bsh = new Interpreter();
                for (Map.Entry<String, Object> e : param.entrySet()) {
                    bsh.set(e.getKey(), e.getValue());
                }
                Object val = bsh.eval(eq);
                if (val instanceof Number) {
                    double result = ((Number)val).doubleValue();
                    return result;
                }
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.equation.return.number", (Object[])new Object[]{eq}));
            }
            if ("java".equals(this.getLanguage()) || this.getJavaInterface() != null) {
                Object val = EvaluatorHelper.evaluate("formules", this.getTopiaId(), this.getJavaInterface(), this.getContent(), param);
                if (val instanceof Number) {
                    double result = ((Number)val).doubleValue();
                    return result;
                }
                throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.equation.return.number", (Object[])new Object[]{eq}));
            }
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.unsupported.equation.langage", (Object[])new Object[]{this.getLanguage(), eq}));
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n._((String)"isisfish.error.evaluate.equation", (Object[])new Object[]{eq}), eee);
        }
    }

    @Override
    public double evaluate(String name, Object value, Object ... others) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(name, value);
        int i = 0;
        while (i < others.length) {
            name = (String)others[i++];
            value = others[i++];
            param.put(name, value);
        }
        double result = this.evaluate(param);
        return result;
    }

    @Override
    public String toString() {
        String result = this.getName() + "(" + this.getCategory() + ")";
        return result;
    }
}

