/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.Doc;
import fr.ifremer.isisfish.util.Docable;
import fr.ifremer.isisfish.util.JavadocHelper;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public abstract class JavaSourceStorage
extends CodeSourceStorage
implements Docable {
    private static Log log = LogFactory.getLog(ExportStorage.class);
    protected static final String PARAM_PREFIX = "param_";

    protected JavaSourceStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name, ".java");
    }

    public String getFQN() {
        String root = this.getRoot().getAbsolutePath();
        String path = this.getFile().getParentFile().getAbsolutePath();
        String packageName = path.substring(1 + root.length()).replace(File.separatorChar, '.');
        String result = packageName + "." + this.getName();
        if (result.endsWith(".java")) {
            result = result.substring(0, result.length() - ".java".length());
        }
        return result;
    }

    public static String getName(Object instance) {
        return ClassUtils.getShortClassName((Object)instance, null);
    }

    public int compile(boolean force, PrintWriter out) {
        return CompileHelper.compile(this, IsisFish.config.getCompileDirectory(), force, out);
    }

    public int doJavadoc(boolean force, PrintWriter out) {
        int result = JavadocHelper.generateJavadoc(this, IsisFish.config.getJavadocDirectory(), force, out);
        return result;
    }

    public Class<?> getCodeClass() throws IsisFishException {
        String fqn = this.getFQN();
        this.compile(false, null);
        Class<?> result = CompileHelper.loadClass(fqn);
        if (result == null) {
            throw new IsisFishException(I18n._((String)"isisfish.error.load.class", (Object[])new Object[]{fqn}));
        }
        return result;
    }

    public Object getNewInstance() throws IsisFishException {
        Object result;
        Class<?> clazz = this.getCodeClass();
        try {
            result = clazz.newInstance();
        }
        catch (InstantiationException eee) {
            throw new IsisFishException("Can't instanciate class: " + clazz.getName(), eee);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't instanciate class: " + clazz.getName(), eee);
        }
        return result;
    }

    protected static Doc getFieldDoc(Class klass, String paramName) throws SecurityException, NoSuchFieldException {
        Field f = klass == null ? null : klass.getField(paramName);
        Doc result = f == null ? null : f.getAnnotation(Doc.class);
        return result;
    }

    public static Doc getParameterDoc(Object object, String paramName) {
        Doc result = null;
        try {
            result = JavaSourceStorage.getFieldDoc(object.getClass(), PARAM_PREFIX + paramName);
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.field", (Object[])new Object[]{paramName, object}));
        }
        return result;
    }

    @Override
    public Doc getFieldDoc(String paramName) {
        Doc result = null;
        try {
            Class<?> clazz = this.getCodeClass();
            result = JavaSourceStorage.getFieldDoc(clazz, PARAM_PREFIX + paramName);
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"isisfish.error.not.found.field", (Object[])new Object[]{paramName, this}));
        }
        return result;
    }

    @Override
    public String getDescription() {
        return null;
    }

    public Map<String, Class<?>> getParameterNames() throws IsisFishException {
        Map<String, Class<?>> result = null;
        try {
            if (0 == this.compile(false, null)) {
                Object instance = this.getNewInstance();
                result = JavaSourceStorage.getParameterNames(instance);
            }
        }
        catch (Exception eee) {
            log.info((Object)I18n._((String)"isisfish.error.compiled.parameter", (Object[])new Object[0]), (Throwable)eee);
        }
        if (result == null) {
            try {
                log.fatal((Object)"FIXME a faire recherche des parametre dans le source");
                throw new IsisFishException(I18n._((String)"isisfish.error.source.parameter", (Object[])new Object[0]));
            }
            catch (Exception eee) {
                throw new IsisFishException(I18n._((String)"isisfish.error.source.parameter", (Object[])new Object[0]), eee);
            }
        }
        return result;
    }

    public static Map<String, Class<?>> getParameterNames(Object instance) {
        LinkedHashMap result = new LinkedHashMap();
        for (Field field : instance.getClass().getFields()) {
            if (!field.getName().startsWith(PARAM_PREFIX)) continue;
            result.put(field.getName().substring(PARAM_PREFIX.length()), field.getType());
        }
        return result;
    }

    public static Object getParameterValue(Object instance, String name) throws IsisFishException {
        if (instance == null || name == null || "".equals(name)) {
            return null;
        }
        try {
            String fieldName = PARAM_PREFIX + name;
            Field field = instance.getClass().getDeclaredField(fieldName);
            return field.get(instance);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't get rule parameter: " + name, eee);
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't get rule parameter: " + name, eee);
        }
    }

    public static Class getParameterType(Object instance, String name) throws IsisFishException {
        if (instance == null || name == null || "".equals(name)) {
            return null;
        }
        try {
            String fieldName = PARAM_PREFIX + name;
            Field field = instance.getClass().getDeclaredField(fieldName);
            return field.getType();
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't get rule parameter: " + name, eee);
        }
    }

    public static void setParameterValue(Object instance, String name, Object value) throws IsisFishException {
        try {
            String fieldName = PARAM_PREFIX + name;
            Field field = instance.getClass().getDeclaredField(fieldName);
            field.set(instance, value);
        }
        catch (IllegalAccessException eee) {
            throw new IsisFishException("Can't modify script parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
        catch (NoSuchFieldException eee) {
            throw new IsisFishException("Can't modify script parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
        catch (IllegalArgumentException eee) {
            throw new IsisFishException("Can't modify script parameter: " + name + " with '" + value + "'(" + ObjectUtils.identityToString((Object)value) + ")", eee);
        }
    }

    public static String getParamAsString(Object instance) throws IsisFishException {
        StringBuffer result = new StringBuffer();
        for (String name : JavaSourceStorage.getParameterNames(instance).keySet()) {
            Object value = JavaSourceStorage.getParameterValue(instance, name);
            result.append(name).append(" : ").append(value);
            result.append("\n");
        }
        return result.toString();
    }
}

