/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.actions;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import java.io.File;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;

public class ImportAction {
    protected IsisConfig config = null;

    public ImportAction(IsisConfig config) {
        this.config = config;
    }

    public void importSimulationPlan(boolean force, File file) throws Exception {
        String name = file.getName();
        SimulationPlanStorage storage = SimulationPlanStorage.getSimulationPlan(name, new CodeSourceStorage.Location[0]);
        if (!force && storage.exists()) {
            throw new IllegalArgumentException(I18n._((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{storage.getFile()}));
        }
        String content = FileUtil.readAsString((File)file);
        storage.setContent(content);
    }

    public void importExport(boolean force, File file) throws Exception {
        String name = file.getName();
        ExportStorage storage = ExportStorage.getExport(name, new CodeSourceStorage.Location[0]);
        if (!force && storage.exists()) {
            throw new IllegalArgumentException(I18n._((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{storage.getFile()}));
        }
        String content = FileUtil.readAsString((File)file);
        storage.setContent(content);
    }

    public void importRule(boolean force, File file) throws Exception {
        String name = file.getName();
        RuleStorage storage = RuleStorage.getRule(name, new CodeSourceStorage.Location[0]);
        if (!force && storage.exists()) {
            throw new IllegalArgumentException(I18n._((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{storage.getFile()}));
        }
        String content = FileUtil.readAsString((File)file);
        storage.setContent(content);
    }

    public void importScript(boolean force, File file) throws Exception {
        String name = file.getName();
        ScriptStorage storage = ScriptStorage.getScript(name, new CodeSourceStorage.Location[0]);
        if (!force && storage.exists()) {
            throw new IllegalArgumentException(I18n._((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{storage.getFile()}));
        }
        String content = FileUtil.readAsString((File)file);
        storage.setContent(content);
    }

    public void importSimulator(boolean force, File file) throws Exception {
        String name = file.getName();
        SimulatorStorage storage = SimulatorStorage.getSimulator(name, new CodeSourceStorage.Location[0]);
        if (!force && storage.exists()) {
            throw new IllegalArgumentException(I18n._((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{storage.getFile()}));
        }
        String content = FileUtil.readAsString((File)file);
        storage.setContent(content);
    }

    public void importFormula(boolean force, String formulaType, File file) throws Exception {
        if (!FormuleStorage.getCategories().contains(formulaType)) {
            throw new IllegalArgumentException(I18n._((String)"Could not found formule type %s autorised type are %s", (Object[])new Object[]{formulaType, FormuleStorage.getCategories()}));
        }
        String name = file.getName();
        FormuleStorage storage = FormuleStorage.getFormule(formulaType, name);
        if (!force && storage.exists()) {
            throw new IllegalArgumentException(I18n._((String)"destination already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{storage.getFile()}));
        }
        String content = FileUtil.readAsString((File)file);
        storage.setContent(content);
    }

    public void importRegion(boolean force, File file) throws Exception {
        RegionStorage.importZip(file);
    }

    public void importRegionAndRename(boolean force, File file, String name) throws Exception {
        if (RegionStorage.exists(name) && !force) {
            throw new IllegalArgumentException(I18n._((String)"region already exists %s use 'force' argument to force overwrite", (Object[])new Object[]{name}));
        }
        RegionStorage.importAndRenameZip(file, name);
    }

    public void importSimulation(boolean force, File file) throws Exception {
        SimulationStorage.importZip(file);
    }

    public void importScriptModule(boolean force, File file) throws Exception {
    }
}

