<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<!--
  #%L
  IsisFish
  
  $Id: isis-fish-2.1_2.2.xsl 3124 2010-11-29 18:14:09Z chatellier $
  $HeadURL$
  %%
  Copyright (C) 1999 - 2010 CodeLutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 2 of the 
  License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public 
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/gpl-2.0.html>.
  #L%
  -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!-- Carbon copy as default -->
  <xsl:template match="child::node()|attribute::*" priority="-10">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>
        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>


  <!-- changement de version -->
  <xsl:template match="/dbobjects">
    <xsl:copy>
      <xsl:attribute name="version">2.2</xsl:attribute>
      <xsl:apply-templates select="child::*"/>
    </xsl:copy>
  </xsl:template>


  <!--
   | Add attribute coeff in MappingZoneReproZoneRecru
   +-->
  <xsl:template match="dbobject[@type='MappingZoneReproZoneRecru']">
    <xsl:copy>
        <xsl:apply-templates select="attribute::*"/>

        <xsl:element name="attribute">
            <xsl:attribute name="name">coeff</xsl:attribute>
            <xsl:text>1</xsl:text>
        </xsl:element>

        <xsl:apply-templates select="child::node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
